/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.history;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.net.URLFactory;
import oracle.ide.persistence.SecondaryKeyProvider;
import oracle.ideimpl.history.HistoryManagerImpl2;
import oracle.javatools.assembly.AssemblyException;
import oracle.javatools.assembly.AssemblyFactory;
import oracle.javatools.assembly.ObjectFactory;
import oracle.javatools.assembly.StringFactory;

public class NodeInfo {
    public static final String NODE_ID_KEY = "nodeId";
    public static final String DELETED_KEY = "deleted";
    private final Integer _nodeId;
    private final URL _nodeURL;
    private final String _key;
    private int _hashcode = -1;
    private boolean _deleted;
    private URL _historyURL;
    private static Logger logger = Logger.getLogger(NodeInfo.class.getName());
    private static final AssemblyFactory ASSEMBLY_FACTORY = new ObjectFactory(){

        public Object assembleImpl(DataInput input) throws IOException, AssemblyException {
            Integer nodeId = input.readInt();
            Boolean deleted = input.readBoolean();
            String nodeUrlStr = (String)StringFactory.STRING_FACTORY.assemble(input);
            return new NodeInfo(nodeId, URLFactory.newURL((String)nodeUrlStr), deleted);
        }

        public void disassembleImpl(Object object, DataOutput output) throws IOException, ClassCastException, AssemblyException {
            NodeInfo node = (NodeInfo)object;
            output.writeInt(node._nodeId);
            output.writeBoolean(node._deleted);
            StringFactory.STRING_FACTORY.disassemble((Object)node._nodeURL.toString(), output);
        }
    };
    public static final SecondaryKeyProvider SECONDARY_KEY_PROVIDER = new SecondaryKeyProvider(){
        private final List<String> KEYS = Arrays.asList("nodeId", "deleted");

        public Collection<String> getSecondaryKeyNames() {
            return this.KEYS;
        }

        public Collection<String> getSecondaryKeys(String keyName, String primaryKey, byte[] data) {
            NodeInfo node = NodeInfo.assemble(data);
            if (node != null && keyName.equals(NodeInfo.NODE_ID_KEY)) {
                return Collections.singleton(node.getNodeId().toString());
            }
            if (node != null && keyName.equals(NodeInfo.DELETED_KEY)) {
                return Collections.singleton(String.valueOf(node.isDeleted()));
            }
            return Collections.emptyList();
        }
    };

    static String asKey(URL url) {
        return String.valueOf(url);
    }

    public NodeInfo(Integer nodeId, URL nodeURL) {
        this(nodeId, nodeURL, false);
    }

    public NodeInfo(Integer nodeId, URL nodeURL, boolean deleted) {
        if (nodeId == null) {
            throw new IllegalArgumentException("nodeId can't be null");
        }
        if (nodeURL == null) {
            throw new IllegalArgumentException("nodeURL can't be null");
        }
        this._nodeId = nodeId;
        this._nodeURL = nodeURL;
        this._deleted = deleted;
        this._key = NodeInfo.asKey(nodeURL);
    }

    public Integer getNodeId() {
        return this._nodeId;
    }

    public URL getNodeURL() {
        return this._nodeURL;
    }

    public boolean isDeleted() {
        return this._deleted;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NodeInfo)) {
            return false;
        }
        NodeInfo other = (NodeInfo)obj;
        return this._nodeId.equals(other._nodeId) && this._nodeURL.toString().equals(other._nodeURL.toString());
    }

    public int hashCode() {
        if (this._hashcode == -1) {
            int seed = 851;
            this._hashcode = seed * this._nodeId.hashCode();
            this._hashcode = seed * this._hashcode + this._nodeURL.toString().hashCode();
        }
        return this._hashcode;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(super.toString()).append("[nodeId: ").append(this._nodeId).append(", nodeUrl: ").append(this._nodeURL).append(", deleted: ").append(this._deleted).append("]");
        return b.toString();
    }

    String getKey() {
        return this._key;
    }

    void setDeleted(boolean deleted) {
        this._deleted = deleted;
    }

    URL getHistoryURL() {
        if (this._historyURL == null) {
            this._historyURL = URLFactory.newDirURL((String)(HistoryManagerImpl2.HISTORY_DIR + this._nodeId));
        }
        return this._historyURL;
    }

    static byte[] disassemble(NodeInfo state) {
        try {
            return ASSEMBLY_FACTORY.disassemble((Object)state);
        }
        catch (AssemblyException e) {
            logger.log(Level.SEVERE, "An error occured while disassembling data, the record may be corrupted", e);
            return null;
        }
    }

    public static NodeInfo assemble(byte[] data) {
        try {
            return (NodeInfo)ASSEMBLY_FACTORY.assemble(data);
        }
        catch (AssemblyException e) {
            logger.log(Level.SEVERE, "An error occured while assembling data, the record may be corrupted", e);
            return null;
        }
    }
}

