/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.io.PrintWriter;
import java.util.Hashtable;
import oracle.xml.parser.v2.NSName;
import oracle.xml.util.FastVector;
import oracle.xml.xqxp.XQException;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLNode;
import oracle.xml.xslt.XSLStylesheet;
import oracle.xml.xslt.XSLTContext;
import oracle.xml.xslt.XSLTemplate;
import oracle.xml.xslt.XSLVariable;

class XSLCallTemplate
extends XSLNode
implements XSLConstants {
    private NSName templName;
    private XSLTemplate template;

    XSLCallTemplate(XSLStylesheet xSLStylesheet) throws XSLException {
        super(xSLStylesheet);
        this.elementType = 4;
    }

    @Override
    public void processAction(XSLTContext xSLTContext) throws XSLException, XQException {
        if (xSLTContext.isInDebugMode()) {
            this.addJDWPDataBefore(xSLTContext, this, "xsl:call-template", this.templName.getExpandedName(), (byte)-1);
        }
        if (xSLTContext.getOSBDebugMode()) {
            this.fireOSBDebuggerTraceEventBeforeExe(xSLTContext, this, "xsl:call-template");
        }
        this.setContextBaseURL(xSLTContext);
        this.setDefaultCollation(xSLTContext);
        Hashtable hashtable = null;
        if (this.nParams > 0) {
            hashtable = xSLTContext.allocHashtable();
            for (int i = 0; i < this.nParams; ++i) {
                XSLVariable xSLVariable = (XSLVariable)this.paramList.elementAt(i);
                hashtable.put(xSLVariable.getName(), xSLVariable.getValue(xSLTContext));
            }
        }
        int n = xSLTContext.getCurrentTmpl();
        xSLTContext.setCurrentTmpl(-2);
        this.template.setParams(hashtable, xSLTContext);
        this.template.processAction(xSLTContext);
        xSLTContext.setCurrentTmpl(n);
        if (hashtable != null) {
            xSLTContext.freeHashtable(hashtable);
        }
        if (xSLTContext.getOSBDebugMode()) {
            this.fireOSBDebuggerTraceEventAfterExe(xSLTContext, this, "xsl:call-template");
        }
        if (xSLTContext.isInDebugMode()) {
            this.addJDWPDataAfter(this, (byte)-1, null);
        }
    }

    @Override
    public void appendChild(XSLNode xSLNode) throws XSLException {
        super.appendChild(xSLNode);
        if (xSLNode.namespace == "http://www.w3.org/1999/XSL/Transform" && xSLNode.localName == "with-param") {
            if (this.paramList == null) {
                this.paramList = new FastVector(4);
            }
            this.paramList.addElement(xSLNode);
            ++this.nParams;
            this.children.setSize(this.children.size() - 1);
        }
    }

    @Override
    public void setAttribute(String string, String string2, String string3, String string4) throws XSLException, XQException {
        if (string == "" && string3 == "name") {
            this.templName = this.resolveQname(string4);
        }
        super.setAttribute(string, string2, string3, string4);
    }

    @Override
    public void startContent() throws XSLException {
        if (this.templName == null) {
            this.xss.err.error2(1009, 1, "name", this.getQualifiedName());
        }
    }

    @Override
    public void finalizeXSLNode() throws XSLException, XQException {
        for (int i = 0; i < this.nParams; ++i) {
            ((XSLNode)this.paramList.elementAt(i)).finalizeXSLNode();
        }
        super.finalizeXSLNode();
        if (this.templName != null) {
            this.template = this.xss.getNamedTemplate(this.templName);
            if (this.template == null) {
                this.xss.err.setLocator(this);
                this.xss.err.error1(1049, 1, this.templName.getQualifiedName());
                return;
            }
        }
    }

    @Override
    void printChildren(PrintWriter printWriter, int n) {
        for (int i = 0; i < this.nParams; ++i) {
            ((XSLNode)this.paramList.elementAt(i)).printXSLNode(printWriter, n);
        }
        super.printChildren(printWriter, n);
    }
}

