/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.quickdiff;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Observable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.algorithm.text.TextCompareContributor;
import oracle.jdeveloper.compare.InputStreamTextContributor;

public abstract class QuickDiffReference
extends Observable {
    private final Node _node;
    private final NodeListener _nodeListener = this.createNodeListener();
    private final String _type;
    private TextCompareContributor _compareContributor;

    protected QuickDiffReference(URL url) {
        Node node = this._node = this._nodeListener != null ? NodeFactory.find((URL)url) : null;
        if (this._node != null) {
            this._node.addNodeListener(this._nodeListener);
        }
        this._type = URLFileSystem.getSuffix((URL)url);
    }

    protected NodeListener createNodeListener() {
        return null;
    }

    protected final Node getNode() {
        return this._node;
    }

    public final TextCompareContributor getCompareContributor() throws Exception {
        if (this._compareContributor == null) {
            this._compareContributor = this.createCompareContributor();
        }
        return this._compareContributor;
    }

    protected TextCompareContributor createCompareContributor() throws Exception {
        InputStream in = this.openInputStream();
        return in != null ? new InputStreamTextContributor(in, "", "", this._type) : null;
    }

    public abstract InputStream openInputStream() throws IOException;

    public void dispose() {
        if (this._node != null) {
            this._node.removeNodeListener(this._nodeListener);
        }
    }

    protected void doNotifyObservers() {
        this._compareContributor = null;
        this.setChanged();
        this.notifyObservers();
    }

    public class DefaultNodeListener
    extends NodeListener {
        public void nodeSaved(NodeEvent ne) {
            QuickDiffReference.this.doNotifyObservers();
        }

        public void nodeReverted(NodeEvent ne) {
            QuickDiffReference.this.doNotifyObservers();
        }

        public void nodeClosed(NodeEvent ne) {
            QuickDiffReference.this.dispose();
        }
    }
}

