/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.quickdiff;

import java.util.Observable;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.quickdiff.QuickDiffContextMenuListener;
import oracle.ide.quickdiff.QuickDiffReferenceProvider;
import oracle.ide.quickdiff.QuickDiffReferenceRegistry;
import oracle.javatools.editor.EditorProperties;

final class QuickDiffManager {
    private static final String ENABLE_QUICKDIFF_CMD = "QuickDiff.EnableQuickDiff";
    static final int ENABLE_QUICKDIFF_CMD_ID = Ide.findOrCreateCmdID((String)"QuickDiff.EnableQuickDiff");
    private static final String DISABLE_QUICKDIFF_CMD = "QuickDiff.DisableQuickDiff";
    static final int DISABLE_QUICKDIFF_CMD_ID = Ide.findOrCreateCmdID((String)"QuickDiff.DisableQuickDiff");
    private static final String TURNOFF_QUICKDIFF_CMD = "QuickDiff.TurnOffQuickDiff";
    static final int TURNOFF_QUICKDIFF_CMD_ID = Ide.findOrCreateCmdID((String)"QuickDiff.TurnOffQuickDiff");
    private static final ProviderObservable _providerObservable = new ProviderObservable();
    static final String QUICKDIFF_ENABLED_DTCACHE_KEY = "QuickDiff.Enabled";
    private static final String QUICKDIFF_REFERENCE_DTCACHE_KEY = "QuickDiff.Reference";
    private static final QuickDiffManager _instance = new QuickDiffManager();
    private Runnable _initClosure = new Runnable(){

        @Override
        public final void run() {
            CodeEditorGutter.getGutterContextMenu().addContextMenuListener((ContextMenuListener)new QuickDiffContextMenuListener());
            boolean enableQuickDiff = Ide.getDTCache().getBoolean(QuickDiffManager.QUICKDIFF_ENABLED_DTCACHE_KEY, true);
            EditorProperties.getProperties().putBooleanProperty("show-quickdiff-margin", enableQuickDiff);
            String id = Ide.getDTCache().getString(QuickDiffManager.QUICKDIFF_REFERENCE_DTCACHE_KEY);
            if (id == null) {
                Ide.getDTCache().putString(QuickDiffManager.QUICKDIFF_REFERENCE_DTCACHE_KEY, "FileOnDisk");
            }
        }
    };

    QuickDiffManager() {
    }

    static final QuickDiffManager getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void runInitClosure() {
        QuickDiffManager quickDiffManager = this;
        synchronized (quickDiffManager) {
            if (this._initClosure != null) {
                this._initClosure.run();
                this._initClosure = null;
            }
        }
    }

    final ProviderObservable getProviderObservable() {
        this.runInitClosure();
        return _providerObservable;
    }

    static final class ProviderObservable
    extends Observable {
        ProviderObservable() {
        }

        final QuickDiffReferenceProvider getProvider() {
            String id = Ide.getDTCache().getString(QuickDiffManager.QUICKDIFF_REFERENCE_DTCACHE_KEY);
            return id != null ? QuickDiffReferenceRegistry.lookup(id) : null;
        }

        final void setProvider(QuickDiffReferenceProvider provider) {
            if (provider == this.getProvider()) {
                return;
            }
            Ide.getDTCache().putString(QuickDiffManager.QUICKDIFF_REFERENCE_DTCACHE_KEY, provider.getID());
            this.setChanged();
            this.notifyObservers();
        }
    }
}

