/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.ide.db.util.LiveValidationController;
import oracle.ide.panels.TraversalException;

public abstract class ValidatedTextField
extends JTextField {
    private boolean m_listening;
    private Timer m_timer;
    private LiveValidationController m_vController;
    private String m_error = null;
    private boolean valid = true;
    private boolean m_currentlyInvalid = false;
    public static final String VALID = "valid";
    private static final int DEFAULT_COLUMNS = 15;
    private static final int DEFAULT_DELAY = 1500;

    public ValidatedTextField() {
        this(true);
    }

    public ValidatedTextField(boolean bl) {
        this.setColumns(15);
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ValidatedTextField.this.commitName();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ValidatedTextField.this.commitName();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ValidatedTextField.this.commitName();
            }
        });
        this.addAncestorListener(new LocalAncestorListener());
        if (bl) {
            this.m_vController = new LiveValidationController((JComponent)this);
        }
    }

    public void commitName() {
        if (this.m_listening) {
            if (this.m_currentlyInvalid) {
                this.showNameError(this.commitIdentifier());
            }
            this.getTimer().restart();
        }
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        this.m_listening = true;
    }

    public void commit() throws TraversalException {
        String string = this.commitIdentifier();
        if (string != null) {
            throw new TraversalException(string);
        }
        this.m_listening = false;
    }

    protected Timer getTimer() {
        if (this.m_timer == null) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ValidatedTextField.this.showNameError(ValidatedTextField.this.commitIdentifier());
                }
            };
            this.m_timer = new Timer(1500, actionListener);
            this.m_timer.setRepeats(false);
        }
        return this.m_timer;
    }

    private String commitIdentifier() {
        String string;
        String string2;
        this.m_currentlyInvalid = true;
        this.getTimer().stop();
        if (this.m_listening && (string2 = this.validate(string = this.getText())) != null) {
            this.setValid(false);
            return string2;
        }
        this.setValid(true);
        this.m_currentlyInvalid = false;
        return null;
    }

    protected void showNameError(String string) {
        this.m_error = string;
        if (this.m_vController != null) {
            this.m_vController.showError(string);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.m_vController != null) {
            this.m_vController.hidePopup();
        }
        super.setEnabled(bl);
    }

    public void setValid(boolean bl) {
        boolean bl2 = bl;
        this.valid = bl;
        this.firePropertyChange(VALID, bl2, bl);
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    protected abstract String validate(String var1);

    private class LocalAncestorListener
    implements AncestorListener {
        private LocalAncestorListener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            if (ValidatedTextField.this.m_vController != null) {
                ValidatedTextField.this.m_vController.showError(ValidatedTextField.this.m_error);
            }
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            if (ValidatedTextField.this.m_vController != null) {
                ValidatedTextField.this.m_vController.hidePopup();
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }
    }
}

