/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.plsql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.plsql.BasicPlSqlTab;

public class PlSqlDependencies
extends BasicPlSqlTab {
    private MyTableModel theModel;
    protected static Logger theLogger = Logger.getLogger(PlSqlDependencies.class.getPackage().getName());

    @Override
    protected AbstractTableModel initializeModel() throws Exception {
        this.theModel = new MyTableModel();
        return this.theModel;
    }

    @Override
    protected void refreshData() throws Exception {
        if (this.theModel == null) {
            this.theModel = new MyTableModel();
            return;
        }
        this.theModel.init();
    }

    private class MyTableModel
    extends AbstractTableModel {
        private List<Object[]> theRows = new ArrayList<Object[]>(32);
        private String[] theDependencyInfoColumnNames = new String[]{Messages.getString("TimesTen.plsql.col.objectId"), Messages.getString("TimesTen.plsql.col.owner"), Messages.getString("TimesTen.plsql.col.objectType"), Messages.getString("TimesTen.plsql.col.objectName"), Messages.getString("TimesTen.plsql.col.status")};
        List<Integer> theDependentObjects = new ArrayList<Integer>(32);

        private MyTableModel() throws Exception {
            try {
                this.init();
            }
            catch (SQLException sQLException) {
                theLogger.log(Level.SEVERE, "PL/SQL Dependencies init failed " + sQLException.toString());
                throw sQLException;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void getDependents(String string) throws SQLException {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                Connection connection = PlSqlDependencies.this.theDbObject.getConnection();
                statement = connection.createStatement();
                resultSet = statement.executeQuery("SELECT distinct object_id, referenced_object_id FROM public_dependency where object_id = " + string);
                while (resultSet.next()) {
                    int n = resultSet.getInt(2);
                    if (this.theDependentObjects.contains(n)) continue;
                    this.theDependentObjects.add(n);
                    this.getDependents(Integer.toString(n));
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                theLogger.log(Level.SEVERE, "Getting dependents failed", sQLException);
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }

        private void init() throws SQLException {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                String string = PlSqlDependencies.this.theDbObject.getObjectId();
                this.theRows.clear();
                this.theDependentObjects.clear();
                this.getDependents(string);
                Collections.sort(this.theDependentObjects);
                Connection connection = PlSqlDependencies.this.theDbObject.getConnection();
                statement = connection.createStatement();
                for (int n : this.theDependentObjects) {
                    resultSet = statement.executeQuery("SELECT OBJECT_ID, owner, object_type, object_name, status from sys.all_objects  where OBJECT_ID = " + n + " and owner NOT IN ('SYS', 'SYSTEM', 'PUBLIC') and object_name <> 'DUAL'");
                    int n2 = 0;
                    while (resultSet.next()) {
                        Object[] objectArray = new Object[this.theDependencyInfoColumnNames.length];
                        for (int i = 1; i <= this.theDependencyInfoColumnNames.length; ++i) {
                            objectArray[i - 1] = resultSet.getString(i);
                        }
                        this.theRows.add(objectArray);
                        ++n2;
                    }
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                theLogger.log(Level.SEVERE, "PL/SQL Dependencies SELECT failed " + sQLException.toString(), sQLException);
                throw sQLException;
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }

        @Override
        public final int getColumnCount() {
            return this.theDependencyInfoColumnNames.length;
        }

        @Override
        public final int getRowCount() {
            return this.theRows.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n > this.theRows.size() || n2 > this.theDependencyInfoColumnNames.length) {
                return null;
            }
            return this.theRows.get(n)[n2];
        }

        @Override
        public final String getColumnName(int n) {
            return this.theDependencyInfoColumnNames[n];
        }
    }
}

