/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.format;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.query.QueryCache;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.commands.BuiltInProcedure;
import oracle.dbtools.raptor.timesten.format.GenericResultsFormatter;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.i18n.util.LocaleMapper;
import oracle.javatools.dialogs.MessageDialog;

public class TimesTenLoaderFormatter
extends GenericResultsFormatter {
    private String theTableName;
    private List<String> theColumnNames;
    private Map<String, String> theColumnTypes;
    private static final Logger theLogger = Logger.getLogger(TimesTenLoaderFormatter.class.getPackage().getName());
    static final String[] encodings = new String[]{"UTF-8"};

    public TimesTenLoaderFormatter() {
        super("TTBULKCP", Messages.getString("TimesTenLoaderFormatter.LoaderFile"), "dump");
    }

    @Override
    public void setTableName(String string) {
        this.theTableName = string;
    }

    @Override
    public void start() throws IOException {
        String string;
        String string2 = LocaleMapper.getOraCharacterSet((int)3, (String)this.getEncode());
        String string3 = string2 = string2 == null ? this.getEncode() : string2;
        String string4 = string2.equalsIgnoreCase("AL32UTF8") ? "UTF-8" : (string = string2.equalsIgnoreCase("US7ASCII") ? "ASCII" : string2);
        if (!string.toLowerCase().contains("utf-8")) {
            MessageDialog.error(null, (Object)Messages.getString("TimesTenLoaderFormatter.wrongEncoding"), (String)Messages.getString("TimesTen.common.error"), null);
            return;
        }
        if (this.isTimesTen()) {
            this.write("##ttBulkCp:FSEP=,:QUOTES=1" + this.getLineTerminator());
            this.write("##ttBulkCp:CHARACTERSET=" + string2 + this.getLineTerminator());
            this.write("##ttBulkCp:NCHARENCODING=" + string + this.getLineTerminator());
            this.write("##ttBulkCp:DATEMODE=TIMESTAMP" + this.getLineTerminator());
        } else if (this.isOracle()) {
            this.write("##ttBulkCp:FSEP=,:QUOTES=1:TSFORMAT=Oracle" + this.getLineTerminator());
            this.write("##ttBulkCp:CHARACTERSET=" + string2 + this.getLineTerminator());
            this.write("##ttBulkCp:NCHARENCODING=" + string + this.getLineTerminator());
        }
        this.write("#Generated at : " + new Timestamp(System.currentTimeMillis()).toString() + this.getLineTerminator());
        this.write("#end " + this.getLineTerminator());
        this.printColumnData();
    }

    @Override
    public void startRow() throws IOException {
    }

    public void printColumnWithDoubleQuotes(Object object, int n, int n2) throws IOException {
        String string = "";
        if (object != null) {
            String string2 = this.getValue(object).toString();
            string2 = this.cleanString(string2);
            string = "\"" + string2 + "\"";
        }
        this.write(n == 0 ? string : "," + string);
    }

    public void printColumnWithoutQuotes(Object object, int n, int n2) throws IOException {
        String string = "";
        if (object != null) {
            string = this.getValue(object).toString();
        }
        this.write(n == 0 ? string : "," + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printBlobColumn(Object object, int n, int n2) throws IOException {
        Blob blob = null;
        Object object2 = this.getValue(object);
        if (object2 == null) {
            this.write(n == 0 ? "NULL" : ",NULL");
            return;
        }
        if (!(object2 instanceof Blob)) {
            StackTraceElement[] stackTraceElementArray;
            theLogger.log(Level.SEVERE, "Internal error, unexpected object type:" + object2.getClass().getName());
            for (StackTraceElement stackTraceElement : stackTraceElementArray = Thread.currentThread().getStackTrace()) {
                theLogger.log(Level.SEVERE, stackTraceElement.toString());
            }
            return;
        }
        blob = (Blob)object2;
        InputStream inputStream = null;
        try {
            if (n > 0) {
                this.write(",");
            }
            this.write("{");
            inputStream = blob.getBinaryStream();
            byte[] byArray = new byte[131072];
            int n3 = 0;
            while ((n3 = inputStream.read(byArray)) != -1) {
                this.write(BuiltInProcedure.toHexString(byArray, n3));
            }
        }
        catch (IOException iOException) {
            theLogger.log(Level.SEVERE, "Read/write failed while writing BLOB data", iOException);
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, "SQL exception while writing BLOB data", sQLException);
        }
        finally {
            this.write("}");
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printClobColumn(Object object, int n, int n2) throws IOException {
        Clob clob = (Clob)this.getValue(object);
        Reader reader = null;
        try {
            if (n > 0) {
                this.write(",");
            }
            this.write("\"");
            reader = clob.getCharacterStream();
            char[] cArray = new char[131072];
            int n3 = 0;
            while ((n3 = reader.read(cArray)) != -1) {
                if (n3 < 131072) {
                    char[] cArray2 = new char[n3];
                    System.arraycopy(cArray, 0, cArray2, 0, n3);
                    cArray = cArray2;
                }
                this.write(this.cleanString(new String(cArray)));
            }
        }
        catch (IOException iOException) {
            theLogger.log(Level.SEVERE, "Read/write failed while writing CLOB data", iOException);
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, "SQL exception while writing CLOB data", sQLException);
            theLogger.log(Level.SEVERE, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        finally {
            this.write("\"");
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printNclobColumn(Object object, int n, int n2) throws IOException {
        NClob nClob = (NClob)this.getValue(object);
        Reader reader = null;
        try {
            if (n > 0) {
                this.write(",");
            }
            this.write("\"");
            reader = nClob.getCharacterStream();
            char[] cArray = new char[131072];
            int n3 = 0;
            while ((n3 = reader.read(cArray)) != -1) {
                if (n3 < 131072) {
                    char[] cArray2 = new char[n3];
                    System.arraycopy(cArray, 0, cArray2, 0, n3);
                    cArray = cArray2;
                }
                this.write(this.cleanString(new String(cArray)));
            }
        }
        catch (IOException iOException) {
            theLogger.log(Level.SEVERE, "Read/write failed while writing NCLOB data", iOException);
        }
        catch (SQLException sQLException) {
            theLogger.log(Level.SEVERE, "SQL exception while writing NCLOB data", sQLException);
            theLogger.log(Level.SEVERE, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        finally {
            this.write("\"");
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void printBinaryColumn(Object object, int n, int n2) throws IOException {
        String string = "";
        Object object2 = this.getValue(object);
        string = object2 != null ? "{" + this.cleanString(object2.toString()) + "}" : "NULL";
        this.write(n == 0 ? string : "," + string);
    }

    @Override
    public void printColumn(Object object, int n, int n2) throws IOException {
        String string = this.theColumnNames.get(n);
        if (object == null) {
            if (n > 0) {
                this.write(",");
            }
            this.write("NULL");
            return;
        }
        switch (this.getDataType(n)) {
            case -1: 
            case 1: 
            case 12: {
                if (this.isTimesTen() && this.theColumnTypes.get(string) != null && this.theColumnTypes.get(string).equalsIgnoreCase("ROWID")) {
                    this.printColumnWithoutQuotes(object, n, n2);
                } else {
                    this.printColumnWithDoubleQuotes(object, n, n2);
                }
                return;
            }
            case 2011: {
                if (!(object instanceof String)) {
                    this.printNclobColumn(object, n, n2);
                }
                return;
            }
            case 2005: {
                if (!(object instanceof String)) {
                    this.printClobColumn(object, n, n2);
                }
                return;
            }
            case 2004: {
                this.printBlobColumn(object, n, n2);
                return;
            }
            case -4: 
            case -3: 
            case -2: {
                this.printBinaryColumn(object, n, n2);
                return;
            }
        }
        this.printColumnWithoutQuotes(object, n, n2);
    }

    public String cleanString(String string) {
        String string2 = string.replaceAll("\\\\", "\\\\\\\\");
        string2 = string2.replaceAll("\"", "\\\\\"");
        return string2;
    }

    @Override
    public void endRow() throws IOException {
        this.write(this.getLineTerminator());
    }

    protected void printColumnData() throws IOException {
        Object object;
        this.theColumnNames = this.getColumns();
        try {
            object = this.getConnection();
            String string = this.getObjectOwner();
            if (this.isTimesTen()) {
                this.theColumnTypes = TimesTenLoaderFormatter.getColumnType(string, this.theTableName, (Connection)object);
            }
        }
        catch (SQLException sQLException) {
            IOException iOException = new IOException("Cannot process column type");
            iOException.setStackTrace(sQLException.getStackTrace());
            throw iOException;
        }
        for (int i = 0; i < this.theColumnNames.size(); ++i) {
            object = this.theColumnNames.get(i);
            if (this.isOracle()) {
                this.write("# " + (i + 1) + ". " + (String)object + this.getLineTerminator());
                continue;
            }
            this.write("# " + (i + 1) + ". " + (String)object + " " + this.theColumnTypes.get(object) + " " + this.getLineTerminator());
        }
    }

    private List<String> getColumns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.getColumnCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getColumnName(i));
        }
        return arrayList;
    }

    @Override
    public void end() throws IOException {
        this.getOutWriter().close();
    }

    private String getBinaryValue(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("{");
        stringBuffer.append(BuiltInProcedure.toHexString(byArray));
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static Map<String, String> getColumnType(String string, String string2, Connection connection) throws SQLException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = QueryCache.getQuery((String)"timesten.table.metadata").getSql();
        String string4 = string3.replace(":OBJECT_OWNER", "'" + string + "'");
        string4 = string4.replace(":OBJECT_NAME", "'" + string2 + "'");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string4);
        while (resultSet.next()) {
            hashMap.put(resultSet.getString(1), resultSet.getString(2));
        }
        return hashMap;
    }

    public String getObjectOwner() {
        DBObject dBObject = (DBObject)this.getDbObject();
        if (dBObject == null) {
            return null;
        }
        return dBObject.getSchemaName();
    }

    public String getObjectName() {
        DBObject dBObject = (DBObject)this.getDbObject();
        if (dBObject == null) {
            return null;
        }
        return dBObject.getObjectName();
    }

    public boolean isStandardEncodings() {
        return false;
    }

    public String[] getEncodings() {
        return encodings;
    }
}

