/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table.load;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.TimesTenPassthrough;
import oracle.dbtools.raptor.timesten.dialogs.table.load.LoadOracleTablePanel;
import oracle.dbtools.raptor.timesten.dialogs.table.load.MultipleOracleLoadable;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.javatools.dialogs.progress.ProgressPanel;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.language.LanguageModule;

public class LoadOracleTableDataOnlyPanel
extends JPanel
implements ActionListener {
    private static Logger _logger = Logger.getLogger(LoadOracleTablePanel.class.getPackage().getName());
    private DBObject _dbObject;
    private JEWTDialog _dialog;
    private JButton _loadButton;
    private BasicEditorPane _queryEditor;
    private JLabel _queryEditorLable;
    private JLabel _threadCountLabel;
    private JLabel _ttUsernameLabel;
    private JLabel _tableNameLabel;
    private JLabel _oraUsernameLabel;
    private JTextField _threadCountJTF;
    private JTextField _ttUsernameJTF;
    private JTextField _tableNameJTF;
    private JTextField _oraUsernameJTF;

    public LoadOracleTableDataOnlyPanel(DBObject dBObject, MultipleOracleLoadable multipleOracleLoadable) {
        this._dbObject = dBObject;
        this._loadButton = new JButton(StringUtils.stripMnemonic((String)Messages.getString("LoadTablesFromOracle.loadButton")));
        this._loadButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)Messages.getString("LoadTablesFromOracle.loadButton")));
        this.setLayout(new GridBagLayout());
        this._ttUsernameLabel = new JLabel(Messages.getString("LoadTablesFromOracle.timestenUsername"));
        this._ttUsernameJTF = new JTextField(15);
        this._ttUsernameJTF.setEditable(false);
        this._tableNameLabel = new JLabel(Messages.getString("LoadTablesFromOracle.timesTenTableName"));
        this._tableNameJTF = new JTextField(15);
        this._tableNameJTF.setEditable(false);
        this._oraUsernameLabel = new JLabel(Messages.getString("LoadTablesFromORacle.schemaName"));
        this._oraUsernameJTF = new JTextField(15);
        this._oraUsernameJTF.setEditable(false);
        this._threadCountLabel = new JLabel(Messages.getString("LoadTablesFromOracle.parallelThreadcount"));
        this._threadCountJTF = new JTextField(15);
        this._threadCountJTF.setText(String.valueOf(4));
        this._queryEditorLable = new JLabel(Messages.getString("LoadTablesFromOracle.selectQuery"));
        this._queryEditor = EditorFactory.createIdeEditorPane();
        BasicDocument basicDocument = (BasicDocument)this._queryEditor.getDocument();
        basicDocument.setLanguageSupport(LanguageModule.createSupportForFileType((String)".sql"));
        this._queryEditor.setPreferredSize(new Dimension(200, 200));
        this._queryEditorLable.setVerticalAlignment(1);
        this._queryEditorLable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        ResourceUtils.resLabel((JLabel)this._ttUsernameLabel, (Component)this._ttUsernameJTF, (String)Messages.getString("LoadTablesFromOracle.timestenUsername"));
        ResourceUtils.resLabel((JLabel)this._oraUsernameLabel, (Component)this._oraUsernameJTF, (String)Messages.getString("LoadTablesFromORacle.schemaName"));
        ResourceUtils.resLabel((JLabel)this._threadCountLabel, (Component)this._threadCountJTF, (String)Messages.getString("LoadTablesFromOracle.parallelThreadcount"));
        ResourceUtils.resLabel((JLabel)this._tableNameLabel, (Component)this._tableNameJTF, (String)Messages.getString("LoadTablesFromOracle.timesTenTableName"));
        ResourceUtils.resLabel((JLabel)this._queryEditorLable, (Component)this._queryEditor, (String)Messages.getString("LoadTablesFromOracle.selectQuery"));
        Insets insets = new Insets(2, 2, 2, 2);
        this.add((Component)this._oraUsernameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._oraUsernameJTF, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)this._ttUsernameLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._ttUsernameJTF, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)this._tableNameLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._tableNameJTF, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)this._queryEditorLable, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)new JScrollPane((Component)this._queryEditor), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this.add((Component)this._threadCountLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, insets, 0, 0));
        this.add((Component)this._threadCountJTF, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 18, 2, insets, 0, 0));
        this._tableNameJTF.setText(this._dbObject.getObjectName());
        this._ttUsernameJTF.setText(this._dbObject.getSchemaName());
        try {
            this._oraUsernameJTF.setText(this._dbObject.getConnection().getMetaData().getUserName());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this._loadButton.addActionListener(this);
    }

    public void setDialog(JEWTDialog jEWTDialog) {
        this._dialog = jEWTDialog;
        this._dialog.addCustomButton((Component)this._loadButton);
    }

    public void setEnabledLoadButton(boolean bl) {
        if (this._dialog != null) {
            this._loadButton.setEnabled(bl);
        }
    }

    public JEWTDialog getDialog() {
        return this._dialog;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._loadButton && this.validateInput()) {
            try {
                this.loadData(this._ttUsernameJTF.getText(), this._tableNameJTF.getText(), this._queryEditor.getText(), this._threadCountJTF.getText(), this);
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "Error on loading table " + this._tableNameJTF.getText(), actionEvent);
            }
        }
    }

    private void loadData(final String string, final String string2, final String string3, final String string4, final LoadOracleTableDataOnlyPanel loadOracleTableDataOnlyPanel) throws Exception {
        final LoadProgressMonitor loadProgressMonitor = new LoadProgressMonitor(loadOracleTableDataOnlyPanel, Messages.getString("TimesTen.common.pleaseWait"));
        final TimesTenPassthrough timesTenPassthrough = new TimesTenPassthrough(this._dbObject);
        final String string5 = this.getSelectCountSQL(string3);
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
            String errorMessage = "";

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void doInBackground() throws Exception {
                loadProgressMonitor.display();
                Statement statement = null;
                Connection connection = null;
                try {
                    connection = LoadOracleTableDataOnlyPanel.this._dbObject.getConnection();
                    Connections.getInstance().lock(connection);
                    Integer n = timesTenPassthrough.executeTableCountOnOracle(string5);
                    String string6 = "call ttLoadFromOracle('#tblOwner#','#tblName#', '#Query#', #numThreads#);".replace("#tblOwner#", string).replace("#tblName#", string2).replace("#Query#", string3).replace("#numThreads#", string4);
                    loadProgressMonitor.updateMessage(string2);
                    QueryForUpdate queryForUpdate = new QueryForUpdate(n, string5, LoadOracleTableDataOnlyPanel.this._dbObject, loadProgressMonitor, string2);
                    queryForUpdate.execute();
                    statement = connection.createStatement();
                    statement.execute(string6);
                    statement.execute("commit;");
                    loadProgressMonitor.updateMessage(Messages.getString("LoadTablesFromOracle.updatingTableStats"));
                    statement.execute("call ttOptUpdateStats('#table#', 1, 0);".replace("#table#", string2));
                    queryForUpdate.cancel(true);
                }
                catch (SQLException sQLException) {
                    _logger.log(Level.SEVERE, "Couldn't load table from oracle", sQLException);
                    this.errorMessage = connection != null ? (statement != null ? TTSQLExceptionScrubber.getInstance().getMessage(connection, statement.toString(), sQLException) : TTSQLExceptionScrubber.getMessage(sQLException.getMessage(), "")) : TTSQLExceptionScrubber.getMessage(sQLException.getMessage(), "");
                }
                finally {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {
                            _logger.log(Level.SEVERE, "Couldn't  close statement", sQLException);
                            this.errorMessage = TTSQLExceptionScrubber.getInstance().getMessage(connection, statement.toString(), sQLException);
                        }
                    }
                    if (connection != null) {
                        Connections.getInstance().unlock(connection);
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                loadProgressMonitor.close();
                if (this.errorMessage.equals("")) {
                    loadOracleTableDataOnlyPanel.getDialog().dispose();
                    MessageDialog.information(null, (Object)Messages.getString("LoadTablesFromOracle.successfulLoadMessage"), (String)Messages.getString("LoadTablesFromOracle.loadTableTitle"), null);
                } else {
                    MessageDialog.error(null, (Object)this.errorMessage, (String)Messages.getString("TimesTen.common.error"), null);
                }
            }
        };
        loadProgressMonitor.setSwingWorker(swingWorker);
        swingWorker.execute();
    }

    private boolean validateInput() {
        boolean bl = true;
        if (this._queryEditor.getText() == null || this._queryEditor.getText().length() <= 0) {
            bl = false;
            MessageDialog.error(null, (Object)Messages.getString("LoadTablesFromOracle.selectQueryError"), (String)Messages.getString("TimesTen.common.error"), null);
        }
        try {
            Integer n = new Integer(this._threadCountJTF.getText());
            if (n < 2) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
            MessageDialog.error((Component)this, (Object)(MessageFormat.format(Messages.getString("LoadTablesFromOracle.parallelThreadCountError"), this._threadCountJTF.getText()) + " " + Messages.getString("LoadTablesFromOracle.parallelThreadHint")), (String)Messages.getString("TimesTen.common.error"), null);
        }
        return bl;
    }

    public String getSelectCountSQL(String string) {
        return "SELECT count(*) FROM (" + string + ")";
    }

    private class QueryForUpdate
    extends SwingWorker<Void, Void> {
        private int rowCount;
        private int currentRowsLoaded;
        private DBObject dbObject;
        private LoadProgressMonitor monitor;
        private String rowCountQuery = "";
        private String tableName;

        public QueryForUpdate(int n, String string, DBObject dBObject, LoadProgressMonitor loadProgressMonitor, String string2) {
            this.rowCount = n;
            this.dbObject = dBObject;
            this.monitor = loadProgressMonitor;
            this.rowCountQuery = string;
            this.tableName = string2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Void doInBackground() throws Exception {
            Connection connection = null;
            Statement statement = null;
            try {
                connection = Connections.getInstance().getUniqueConnection(LoadOracleTableDataOnlyPanel.this._dbObject.getConnectionName());
                statement = connection.createStatement();
                Connections.getInstance().lock(connection);
                while (!this.isCancelled() && this.currentRowsLoaded < this.rowCount) {
                    ResultSet resultSet = statement.executeQuery(this.rowCountQuery);
                    while (resultSet.next()) {
                        this.currentRowsLoaded = resultSet.getInt(1);
                        int n = (int)((double)this.currentRowsLoaded / ((double)this.rowCount * 1.0)) * 100;
                        this.monitor.updateRowsLoaded(Integer.toString(this.currentRowsLoaded), Integer.toString(n), this.tableName);
                    }
                    Thread.sleep(5000L);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                Connections.getInstance().unlock(connection);
            }
            return null;
        }
    }

    private class LoadProgressMonitor
    extends IndeterminateProgressMonitor
    implements ChangeListener {
        private ProgressPanel progressPanel;
        private String message;
        private SwingWorker<Void, Void> worker;

        public LoadProgressMonitor(Component component, String string) {
            super(component, string);
            this.progressPanel = this.getPanel();
            this.setCancellable(true);
            this.setCloseOnFinish(false);
            this.addCancellationListener(this);
        }

        public void setSwingWorker(SwingWorker<Void, Void> swingWorker) {
            this.worker = swingWorker;
        }

        public void updateMessage(final String string) {
            this.message = string;
            if (SwingUtilities.isEventDispatchThread()) {
                this.progressPanel.setMessage(this.message);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LoadProgressMonitor.this.progressPanel.setMessage(string);
                    }
                });
            }
        }

        public void updateRowsLoaded(final String string, final String string2, final String string3) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.progressPanel.setMessage(MessageFormat.format(Messages.getString("LoadTablesFromOracle.insertMessage"), string, string3, string2));
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LoadProgressMonitor.this.progressPanel.setMessage(MessageFormat.format(Messages.getString("LoadTablesFromOracle.insertMessage"), string, string3, string2));
                    }
                });
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.worker.cancel(true);
            this.close();
        }
    }
}

