/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.Connection;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.advisor.StatisticsPanel;
import oracle.dbtools.raptor.timesten.utils.TTSQLDevFileNames;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;

public class ExportOptimizerStatistics
extends AbstractMenuAction {
    private JEWTDialog _dialog;
    private StatisticsPanel _statisticsPanel;
    private JButton _saveButton;
    private static final String HOME_DIR = System.getProperty("user.home");
    private IndeterminateProgressMonitor _progressMonitor;

    public void launch() {
        DBObject dBObject = this.getDBObject();
        String string = dBObject.getObjectName();
        String string2 = dBObject.getSchemaName();
        this._statisticsPanel = dBObject.getObjectType().equalsIgnoreCase("TABLE_FOLDER") ? new StatisticsPanel() : new StatisticsPanel(string2 + "." + string);
        JPanel[] jPanelArray = new JPanel[]{this._statisticsPanel};
        String[] stringArray = new String[]{Messages.getString("IndexAdvisor.statistics")};
        MyActionListener myActionListener = new MyActionListener();
        this._dialog = UIUtils.createTabbedPanelDialog2((JPanel[])jPanelArray, (String[])stringArray, (String)Messages.getString("IndexAdvisor.exportOptimizerStatistics"), (ActionListener)myActionListener, null, null);
        this._dialog.setSize(new Dimension(800, 650));
        this._dialog.setButtonMask(20);
        this._saveButton = new JButton(Messages.getString("IndexAdvisor.saveStatistics"));
        this._saveButton.addActionListener(myActionListener);
        this._dialog.addCustomButton((Component)this._saveButton);
        this._dialog.setSize(new Dimension(800, 650));
        this.generateStatistics();
        this._dialog.setVisible(true);
    }

    private void generateStatistics() {
        this._progressMonitor = new IndeterminateProgressMonitor((Component)this._dialog, Messages.getString("IndexAdvisor.indexAdvisorDatabaseCaptureInProgress"), (Object)Messages.getString("IndexAdvisor.indexAdvisorDatabaseCaptureInProgress"), null);
        this._progressMonitor.setCancellable(true);
        this._progressMonitor.setMillisToPopup(500);
        this._progressMonitor.setCloseOnFinish(true);
        this._progressMonitor.setModal(true);
        this._progressMonitor.setBarVisible(true);
        this._progressMonitor.addCancellationListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ExportOptimizerStatistics.this._progressMonitor.close();
            }
        });
        GenerateStatistics generateStatistics = new GenerateStatistics();
        generateStatistics.execute();
        this._progressMonitor.start();
    }

    private void save(File file) {
        String[] stringArray = TTSQLDevFileNames.getHeaders(this.getDBObject());
        this._statisticsPanel.save(file, stringArray);
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ExportOptimizerStatistics.this._saveButton) {
                this.save();
                return;
            }
        }

        private void save() {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setDialogTitle(Messages.getString("IndexAdvisor.saveOptimizerStatisticsExportCommands"));
            String string = Connections.getDisplayName((String)ExportOptimizerStatistics.this.getDBObject().getConnectionName());
            File file = new File(HOME_DIR, TTSQLDevFileNames.getFileName(string, TTSQLDevFileNames.TTSQLDevFileType.EXPORT_OPTIMIZER_STATS));
            file.delete();
            jFileChooser.setSelectedFile(file);
            int n = jFileChooser.showSaveDialog((Component)ExportOptimizerStatistics.this._dialog);
            if (n == 0) {
                File file2 = jFileChooser.getSelectedFile();
                ExportOptimizerStatistics.this.save(file2);
            }
        }
    }

    private class GenerateStatistics
    extends SwingWorker<Void, Void> {
        private GenerateStatistics() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            Connection connection = ExportOptimizerStatistics.this.getDBObject().getConnection();
            ExportOptimizerStatistics.this._statisticsPanel.generateStatistics(connection);
            return null;
        }

        @Override
        protected void done() {
            super.done();
            if (ExportOptimizerStatistics.this._statisticsPanel.hasStatistics()) {
                ExportOptimizerStatistics.this._saveButton.setEnabled(true);
            } else {
                ExportOptimizerStatistics.this._saveButton.setEnabled(false);
            }
            ExportOptimizerStatistics.this._progressMonitor.close();
        }
    }
}

