/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.connection;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.dialogs.DialogBase;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.dialogs.MessageDialog;

public class TTStatsDropSnapshotsPanel
extends DialogBase {
    private Connection _conn;
    private static final String _getSnapshotSQL = "DECLARE currentSnapshot tt_stats.report_table; BEGIN TT_STATS.SHOW_SNAPSHOTS(:currentSnapshot); END;";
    private static final String _dropSnapshotSQL = " call TT_STATS.DROP_SNAPSHOTS_RANGE(:snapshotLow, :snapshotHigh); \n";
    private Method _registerIndexTableOutParameterMethod;
    private Method _getPlsqlIndexTableMethod;
    private JTable _snapshotTable;
    private MyTableModel _tableModel;
    private JCheckBox _selectAll;
    private boolean _isSelectingAll = false;
    private static Logger _logger = Logger.getLogger(TTStatsDropSnapshotsPanel.class.getPackage().getName());

    protected TTStatsDropSnapshotsPanel(DBObject dBObject) {
        super(dBObject, null, "TTStatsDropSnapshotsPanel");
    }

    @Override
    protected void initGUI() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(0));
        this._selectAll = new JCheckBox(Messages.getString("TimesTenStatistics.selectAll"));
        jPanel.add(this._selectAll);
        this.add((Component)jPanel, "North");
        this._selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                if (jCheckBox.isSelected()) {
                    TTStatsDropSnapshotsPanel.this._tableModel.setAllCheckBox(true);
                } else {
                    TTStatsDropSnapshotsPanel.this._tableModel.setAllCheckBox(false);
                }
            }
        });
        this._snapshotTable = new JTable();
        this._snapshotTable.setModel(this._tableModel);
        this._snapshotTable.setDefaultRenderer(Timestamp.class, new DateRenderer());
        this._snapshotTable.setAutoResizeMode(4);
        this._snapshotTable.setAutoCreateRowSorter(true);
        this._snapshotTable.setFillsViewportHeight(true);
        JScrollPane jScrollPane = new JScrollPane(this._snapshotTable, 22, 32);
        this.add((Component)jScrollPane, "Center");
    }

    @Override
    protected void initModel(DBObject dBObject) {
        this._conn = dBObject.getConnection();
        this._tableModel = new MyTableModel(this._conn);
    }

    private void discoverCustomMethods(Object object) {
        try {
            if (this._registerIndexTableOutParameterMethod == null) {
                this._registerIndexTableOutParameterMethod = object.getClass().getMethod("registerIndexTableOutParameter", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            if (this._getPlsqlIndexTableMethod == null) {
                this._getPlsqlIndexTableMethod = object.getClass().getMethod("getPlsqlIndexTable", Integer.TYPE);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean validateValues() {
        if (!this._tableModel.isAtLeastOneSelected()) {
            MessageDialog.error(null, (Object)Messages.getString("TimesTenStatistics.selectAtLeastOneOnDrop"), (String)Messages.getString("TimesTen.common.error"), null);
            return false;
        }
        return MessageDialog.confirm(null, (Object)Messages.getString("TimesTenStatistics.dropSnapshotConfirmation"), (String)Messages.getString("TimesTen.common.confirm"), null);
    }

    @Override
    public String getSql() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._selectAll.isSelected()) {
            return _dropSnapshotSQL.replaceAll(":snapshotLow", "0").replace(":snapshotHigh", "0");
        }
        for (String string : this._tableModel.getSelectedPids()) {
            stringBuffer.append(_dropSnapshotSQL.replaceAll(":snapshotLow", string).replace(":snapshotHigh", string));
        }
        return stringBuffer.toString();
    }

    private class MyTableModel
    extends AbstractTableModel {
        private final Class<?>[] _columnClasses = new Class[]{Boolean.class, Integer.class, Timestamp.class, String.class};
        private final String[] _columnNames = new String[]{Messages.getString("TimesTenStatistics.selector"), Messages.getString("TimesTenStatistics.snapshot"), Messages.getString("TimesTenStatistics.timestamp"), Messages.getString("TimesTenStatistics.captureLevel")};
        private List<Object> _dataModel = new ArrayList<Object>(32);

        private MyTableModel(Connection connection) {
            this.initModel(connection);
        }

        private void setAllCheckBox(boolean bl) {
            Object[] objectArray = null;
            TTStatsDropSnapshotsPanel.this._isSelectingAll = true;
            for (int i = 0; i < this._dataModel.size(); ++i) {
                objectArray = (Object[])this._dataModel.get(i);
                this.setValueAt(bl ? Boolean.TRUE : Boolean.FALSE, i, 0);
            }
        }

        private void initModel(Connection connection) {
            SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected Void doInBackground() throws Exception {
                    Connections.getInstance().getLock(TTStatsDropSnapshotsPanel.this._conn);
                    CallableStatement callableStatement = null;
                    try {
                        callableStatement = TTStatsDropSnapshotsPanel.this._conn.prepareCall(TTStatsDropSnapshotsPanel._getSnapshotSQL);
                        TTStatsDropSnapshotsPanel.this.discoverCustomMethods(callableStatement);
                        TTStatsDropSnapshotsPanel.this._registerIndexTableOutParameterMethod.invoke((Object)callableStatement, 1, 1024, 12, Short.MAX_VALUE);
                        callableStatement.execute();
                        SQLWarning sQLWarning = callableStatement.getWarnings();
                        if (sQLWarning == null) {
                            Object object = TTStatsDropSnapshotsPanel.this._getPlsqlIndexTableMethod.invoke((Object)callableStatement, 1);
                            String[] stringArray = (String[])object;
                            int n = 0;
                            for (String string : stringArray) {
                                String[] stringArray2;
                                if (++n <= 2 || (stringArray2 = string.trim().split("\\s+")).length < 4) continue;
                                Object[] objectArray = new Object[]{Boolean.FALSE, stringArray2[0], Timestamp.valueOf(stringArray2[1].trim() + " " + stringArray2[2].trim()), stringArray2[3]};
                                MyTableModel.this._dataModel.add(objectArray);
                            }
                        } else {
                            _logger.log(Level.SEVERE, "Warnings in prepared statement", sQLWarning);
                        }
                    }
                    catch (SQLException sQLException) {
                        _logger.log(Level.SEVERE, "Couldn't get snapshots", sQLException);
                        MessageDialog.error(null, (Object)TTSQLExceptionScrubber.getInstance().getMessage(TTStatsDropSnapshotsPanel.this._conn, TTStatsDropSnapshotsPanel._getSnapshotSQL, sQLException), (String)Messages.getString("TimesTen.common.error"), null);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        _logger.log(Level.SEVERE, "Couldn't access to discovered method", illegalAccessException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        _logger.log(Level.SEVERE, "Bad arguments passed to discovered method", illegalArgumentException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        _logger.log(Level.SEVERE, "Couldn't invoke to discovered method", invocationTargetException);
                    }
                    finally {
                        if (callableStatement != null) {
                            try {
                                callableStatement.close();
                            }
                            catch (SQLException sQLException) {
                                _logger.log(Level.SEVERE, "Statement couldn't be closed ", sQLException);
                            }
                        }
                        Connections.getInstance().unlock(TTStatsDropSnapshotsPanel.this._conn);
                    }
                    return null;
                }

                @Override
                protected void done() {
                    MyTableModel.this.fireTableDataChanged();
                }
            };
            swingWorker.execute();
        }

        @Override
        public int getColumnCount() {
            return this._columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this._dataModel.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Object[] objectArray = (Object[])this._dataModel.get(n);
            return objectArray[n2];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this._columnClasses[n];
        }

        @Override
        public String getColumnName(int n) {
            return this._columnNames[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            Object[] objectArray = (Object[])this._dataModel.get(n);
            objectArray[n2] = object;
            this.fireTableCellUpdated(n, n2);
            if (n2 == 0) {
                if (!TTStatsDropSnapshotsPanel.this._isSelectingAll && this.areAllRowsSelected()) {
                    TTStatsDropSnapshotsPanel.this._selectAll.setSelected(true);
                }
                if (!((Boolean)object).booleanValue()) {
                    TTStatsDropSnapshotsPanel.this._selectAll.setSelected(false);
                }
            }
        }

        public boolean areAllRowsSelected() {
            for (int i = 0; i < this._dataModel.size(); ++i) {
                Object[] objectArray = (Object[])this._dataModel.get(i);
                if (((Boolean)objectArray[0]).booleanValue()) continue;
                return false;
            }
            return true;
        }

        public boolean isAtLeastOneSelected() {
            for (int i = 0; i < this._dataModel.size(); ++i) {
                Object[] objectArray = (Object[])this._dataModel.get(i);
                if (!((Boolean)objectArray[0]).booleanValue()) continue;
                return true;
            }
            return false;
        }

        public List<String> getSelectedPids() {
            LinkedList<String> linkedList = new LinkedList<String>();
            for (int i = 0; i < this._dataModel.size(); ++i) {
                Object[] objectArray = (Object[])this._dataModel.get(i);
                if (!((Boolean)objectArray[0]).booleanValue()) continue;
                linkedList.add(objectArray[1].toString());
            }
            return linkedList;
        }
    }

    static class DateRenderer
    extends DefaultTableCellRenderer {
        DateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

        @Override
        public void setValue(Object object) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateInstance();
            }
            this.setText(object == null ? "" : this.formatter.format(object));
        }
    }
}

