/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.connection;

import java.awt.event.ActionEvent;
import java.sql.CallableStatement;
import java.sql.SQLException;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TTSQLExceptionScrubber;
import oracle.dbtools.raptor.timesten.dialogs.TTDialog;
import oracle.dbtools.raptor.timesten.dialogs.connection.TTStatsCreateSnapshotPanel;
import oracle.dbtools.raptor.timesten.dialogs.sql.ActionSqlPanel;
import oracle.dbtools.raptor.timesten.dialogs.sql.ISqlPromptPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.raptor.utils.Log;
import oracle.javatools.dialogs.MessageDialog;

public class TTStatsCreateSnapshot
extends AbstractMenuAction {
    public void launch() {
        DBObject dBObject = this.getDBObject();
        ObjectActionController.ObjectActionPostProcess objectActionPostProcess = ObjectActionController.getPostProcessCallback((ObjectAction)this.getObjectAction(), (DBObject)dBObject);
        this.setBlockOACRefresh(true);
        new TTDialog(dBObject, new TTStatsCreateSnapshotPanel(dBObject), Messages.getString("TimesTenStatistics.createSnapshotPaneTitle"), "f1_ott_performance_metric_create_snapshot_html", Messages.getString("TimesTenStatistics.createSnapshotPaneResult"), objectActionPostProcess){

            @Override
            protected String[] getStatements(String string) {
                String[] stringArray = new String[]{string};
                return stringArray;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected boolean processStatement(String string, String string2, ActionEvent actionEvent, ActionSqlPanel actionSqlPanel) {
                boolean bl = true;
                Connections.getInstance().getLock(string2).lock();
                CallableStatement callableStatement = null;
                ISqlPromptPanel iSqlPromptPanel = this.getDialogGUI();
                try {
                    callableStatement = iSqlPromptPanel.getDbObject().getConnection().prepareCall(string);
                    callableStatement.registerOutParameter(1, 4);
                    Connections.getInstance().getLock(string2).unlock();
                    if (callableStatement == null) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    Connections.getInstance().getLock(string2).lock();
                    Log.log((String)string);
                    boolean bl3 = callableStatement.execute();
                    int n = callableStatement.getInt(1);
                    if (n >= 0) {
                        this.confirmMessage = this.confirmMessage.replace("{0}", Integer.toString(n));
                    } else {
                        MessageDialog.error(null, (Object)Messages.getString("TimesTenStatistics.createSnapshotError"), (String)Messages.getString("TimesTen.common.error"), null);
                        bl = false;
                    }
                    ((JEWTDialog)actionEvent.getSource()).closeDialog(false);
                }
                catch (SQLException sQLException) {
                    ExceptionHandler.handleException((Throwable)TTSQLExceptionScrubber.cloneScrubbedSQLException(sQLException, iSqlPromptPanel.getSql()));
                    bl = false;
                }
                catch (Exception exception) {
                    ExceptionHandler.handleException((Throwable)exception);
                    bl = false;
                }
                finally {
                    if (callableStatement != null) {
                        try {
                            callableStatement.close();
                        }
                        catch (Exception exception) {}
                        callableStatement = null;
                    }
                    Connections.getInstance().getLock(string2).unlock();
                }
                return bl;
            }
        };
    }
}

