/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.connection;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;

public class IndexAdvisorHelper {
    private static Logger LOGGER = Logger.getLogger(IndexAdvisorHelper.class.getPackage().getName());
    public static final String[] _indexAdviceBounds = new String[]{"-- >>>>> START ttIndexAdviceCaptureOutput", "-- <<<<< END ttIndexAdviceCaptureOutput"};
    public static final String[] _tableStatisticsBounds = new String[]{"-- >>>>> START ttOptStatsExport", "-- >>>>> END ttOptStatsExport"};

    public static String[] getHeaders(Connection connection, String string) {
        String[] stringArray = new String[4];
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String string2 = simpleDateFormat.format(System.currentTimeMillis());
        stringArray[0] = "-- This file was generated by SQL Developer at " + string2;
        stringArray[1] = "-- SQL Developer version " + Ide.getProductVersion();
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            stringArray[2] = "-- Database version: " + databaseMetaData.getDatabaseProductVersion();
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.SEVERE, "Can't get database version", sQLException);
            stringArray[2] = "-- Database version: Cannot ascertain database version";
        }
        stringArray[3] = "-- Connection name: " + string;
        return stringArray;
    }

    public static String[] getHeaders(DBObject dBObject) {
        String string = dBObject.getConnectionName();
        String string2 = Connections.getDisplayName((String)string);
        return IndexAdvisorHelper.getHeaders(dBObject.getConnection(), string2);
    }

    public static File getFileName(String string, String string2) {
        File file = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String string3 = simpleDateFormat.format(System.currentTimeMillis());
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(string + "-");
        stringBuilder.append("indexadvice-");
        stringBuilder.append(string3);
        stringBuilder.append(".sql");
        file = new File(string2, stringBuilder.toString());
        try {
            file.delete();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Can't delete file", exception);
        }
        return file;
    }

    public static File[] getFileNames(String string, String string2) {
        File[] fileArray = new File[2];
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String string3 = simpleDateFormat.format(System.currentTimeMillis());
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("SQLDEV-IA-advice-");
        stringBuilder.append(string + "-");
        stringBuilder.append(string3);
        stringBuilder.append(".sql");
        fileArray[0] = new File(string2, stringBuilder.toString());
        stringBuilder = new StringBuilder(128);
        stringBuilder.append("SQLDEV-IA-tablestatistics-");
        stringBuilder.append(string + "-");
        stringBuilder.append(string3);
        stringBuilder.append(".sql");
        fileArray[1] = new File(string2, stringBuilder.toString());
        for (File file : fileArray) {
            try {
                file.delete();
            }
            catch (Exception exception) {
                LOGGER.log(Level.SEVERE, "Can't delete files", exception);
            }
        }
        return fileArray;
    }
}

