/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import oracle.dbtools.raptor.timesten.DataSheet;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.utils.ValidatedTextField;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.javatools.dialogs.MessageDialog;

class CacheGroupNameField
extends ValidatedTextField {
    private String _lastName;
    private final int MAX_NAME_FIELD_LENGTH = 30;
    private final boolean allowHashInCG;

    public CacheGroupNameField(DBObject dBObject) {
        super(true);
        DataSheet dataSheet = DataSheet.getInstance();
        this.allowHashInCG = dataSheet.isCapable(dBObject, DataSheet.FeatureType.HashInCacheGroup);
        this.setText("");
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                CacheGroupNameField.this.setText(CacheGroupNameField.this.getText());
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (CacheGroupNameField.this.getText().length() > 30) {
                    MessageDialog.error(null, (Object)(CacheGroupNameField.this.getText() + " " + Messages.getString("CGCCGPanel.isTooLong")), (String)Messages.getString("TimesTen.common.error"), null);
                    CacheGroupNameField.this.setText(CacheGroupNameField.this._lastName);
                    return;
                }
                String string = "[a-zA-Z][_0-9a-zA-Z]*";
                String string2 = "[\\W]|_";
                if (CacheGroupNameField.this.allowHashInCG) {
                    string = "[a-zA-Z][_0-9a-zA-Z#]*";
                    string2 = "[^A-Za-z0-9_#]|_";
                }
                if (!CacheGroupNameField.this.getText().matches(string) && CacheGroupNameField.this.getText().length() > 0) {
                    MessageDialog.error(null, (Object)(CacheGroupNameField.this.getText() + " " + Messages.getString("CGCCGPanel.containsIllegalCharacter")), (String)Messages.getString("TimesTen.common.error"), null);
                    if (CacheGroupNameField.this.allowHashInCG && CacheGroupNameField.this.getText().startsWith("#")) {
                        int n = 0;
                        while (n < CacheGroupNameField.this.getText().length() && CacheGroupNameField.this.getText().charAt(++n) == '#') {
                        }
                        CacheGroupNameField.this.setText(CacheGroupNameField.this.getText().substring(n));
                    }
                    CacheGroupNameField.this.setText(CacheGroupNameField.this.getText().replaceAll(string2, ""));
                }
                CacheGroupNameField.this._lastName = CacheGroupNameField.this.getText();
            }
        });
    }

    @Override
    protected String validate(String string) {
        if (string.length() > 30) {
            return this.getText() + " " + Messages.getString("CGCCGPanel.isTooLong");
        }
        if (string.length() == 0) {
            return Messages.getString("CGCCGPanel.cacheGroupNameCannotBeempty");
        }
        String string2 = "[a-zA-Z][_0-9a-zA-Z]*";
        if (this.allowHashInCG) {
            string2 = "[a-zA-Z][_0-9a-zA-Z#]*";
        }
        if (!string.matches(string2)) {
            return string + " " + Messages.getString("CGCCGPanel.containsIllegalCharacter");
        }
        return null;
    }
}

