/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.dialogs.cache;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.SimpleQuery;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCPanel;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCTableTreeNode;
import oracle.dbtools.raptor.utils.DBObject;

public final class CGCColInfo {
    public String name;
    public String type;
    public int len;
    public int prec;
    public int scale;
    public boolean precisnull;
    public boolean scaleisnull;
    public String nullability;
    public String charUsed;
    public int charlen;
    public int colID;
    public int defLength;
    public String defData;
    boolean isFK;
    boolean isPK;
    String _defValue = null;
    static final Pattern typePat = Pattern.compile("^(date|timestamp|raw|long raw|blob)", 2);
    long _LOBSize;
    String _oratypename;
    String _factory;
    String _default = null;
    String[] _ttTypes;
    boolean _inline;
    boolean _nullable;
    boolean _mustNotNull;
    int _warnmsgType = -1;
    boolean _cacheable;
    boolean _mustCache;
    boolean _cached;
    int _maxlen;
    int _the_len;
    String _byte_char;
    ArrayList<String> _matchtypenames;
    DBObject _dbObject;

    public void setIsFK() {
        this.isFK = true;
        this._nullable = false;
        this._mustCache = true;
    }

    public boolean getIsFK() {
        return this.isFK;
    }

    public void setIsPK() {
        this.isPK = true;
        this._nullable = false;
        this._mustCache = true;
    }

    public boolean getIsPK() {
        return this.isPK;
    }

    public String getDefValue() {
        return this._defValue;
    }

    public void setDefValue(String string) {
        this._defValue = string;
        if (string.length() <= 2 && !string.matches("\\(")) {
            return;
        }
        String[] stringArray = this.type.split("\\(");
        Matcher matcher = typePat.matcher(stringArray[0]);
        if (!matcher.matches()) {
            return;
        }
        String[] stringArray2 = string.split("\\(");
        if (stringArray2.length <= 1) {
            return;
        }
        String string2 = stringArray2[0];
        if (string2.length() > 32 || !string2.matches("^(?i)[a-z][a-z0-9_$]+")) {
            return;
        }
        String string3 = SimpleQuery.dualEval(this._dbObject, string);
        this._defValue = string3 != null ? "'" + string3 + "'" : null;
    }

    public String getColName() {
        return this.name;
    }

    public String getOraJustTypeName() {
        return this.type;
    }

    public String getOraTypeName() {
        return this._oratypename;
    }

    public String[] getTTTypes() {
        return this._ttTypes;
    }

    public String getTTTypeName() {
        return this._default;
    }

    public String getTTTypeNameDefault() {
        return this._factory;
    }

    public Boolean getInline() {
        return new Boolean(this._inline);
    }

    public Boolean getInlinable() {
        boolean bl = this._default.matches(".*VARCHAR.*") || this._default.matches(".*VARBINARY.*");
        return new Boolean(bl);
    }

    public Boolean getNullable() {
        return new Boolean(this._nullable);
    }

    public boolean getMustNotNull() {
        return this._mustNotNull;
    }

    public boolean getCacheable() {
        return this._cacheable;
    }

    public boolean getMustCache() {
        return this._mustCache;
    }

    public Boolean getCached() {
        return new Boolean(this._cached);
    }

    public long getLOBSize() {
        return this._LOBSize;
    }

    public String setLOBSize(long l, String string) {
        this._LOBSize = l;
        String[] stringArray = new String[2];
        String string2 = this._ttTypes[0];
        String string3 = string2.substring(0, string2.indexOf("("));
        stringArray[0] = string3 = string3 + "(" + l + string + ")";
        stringArray[1] = this._ttTypes[1];
        this._ttTypes = stringArray;
        return string3;
    }

    public void setTTTypeName(String string) {
        this._default = string;
    }

    public void setNullable(Boolean bl) {
        if (this.getMustNotNull()) {
            return;
        }
        this._nullable = bl;
    }

    public void setCached(Boolean bl) {
        this._cached = bl;
    }

    public void setInline(Boolean bl) {
        this._inline = bl;
    }

    int getWarningType() {
        return this._warnmsgType;
    }

    public CGCColInfo(ResultSet resultSet, DBObject dBObject) {
        this._dbObject = dBObject;
        try {
            this.colID = resultSet.getInt("COLUMN_ID");
            this.name = resultSet.getString("COLUMN_NAME");
            this.type = resultSet.getString("DATA_TYPE");
            this.len = resultSet.getInt("DATA_LENGTH");
            this.prec = resultSet.getInt("DATA_PRECISION");
            this.precisnull = resultSet.wasNull();
            this.scale = resultSet.getInt("DATA_SCALE");
            this.scaleisnull = resultSet.wasNull();
            this.nullability = resultSet.getString("NULLABLE");
            this.charlen = resultSet.getInt("CHAR_LENGTH");
            this.charUsed = resultSet.getString("CHAR_USED");
            this.defLength = resultSet.getInt("DEFAULT_LENGTH");
            if (0 < this.defLength && this.defLength < 1024) {
                this.defData = resultSet.getString("DATA_DEFAULT");
                this.setDefValue(this.defData);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.init();
    }

    void init() {
        CGCPanel cGCPanel;
        boolean bl;
        this._matchtypenames = new ArrayList();
        this._oratypename = "???";
        this._cacheable = true;
        this._mustCache = false;
        this._nullable = true;
        this._mustNotNull = this.nullability.equals("N");
        if (this._mustNotNull) {
            this._nullable = false;
        }
        this._default = null;
        this._cached = true;
        this._byte_char = "BYTE";
        this._the_len = this.len;
        if (this.charlen > 0 && this.charUsed != null && this.charUsed.equals("C")) {
            this._byte_char = "CHAR";
            this._the_len = this.charlen;
        }
        int n = this._maxlen = (bl = (cGCPanel = CGCPanel.theDialog).isAWT()) ? 256000 : 0x400000;
        if (this.len > this._maxlen) {
            this._warnmsgType = 1;
            this._cacheable = false;
        } else {
            CGCTableTreeNode cGCTableTreeNode;
            this.doTypeMapping();
            if (this._cacheable) {
                this.repackageInfo();
            }
            if ((cGCTableTreeNode = cGCPanel.getCurrentSelection()).isRootTable() && this.canBeTBAgingCol()) {
                cGCPanel.saveTimestampCol(this);
            }
        }
    }

    void doTypeMapping() {
        if (this.type.equals("REAL") || this.type.equals("FLOAT")) {
            this.mapRealFloat();
        } else if (this.type.equals("DOUBLE PRECISION")) {
            this.mapDblPrec();
        } else if (this.type.equals("NUMBER")) {
            this.mapNumber();
        } else if (this.type.equals("LONG")) {
            this.mapLong();
        } else if (this.type.equals("CHAR") || this.type.equals("VARCHAR2")) {
            this.mapCharVarchar2();
        } else if (this.type.equals("RAW") || this.type.equals("LONG RAW")) {
            this.mapRawLongRaw();
        } else if (this.type.equals("DATE") || this.type.equals("TIMESTAMP") || this.type.startsWith("TIMESTAMP(") && this.type.endsWith(")") || this.type.equals("BINARY_FLOAT") || this.type.equals("BINARY_DOUBLE")) {
            this.mapBlind();
        } else if (this.type.equals("NCHAR") || this.type.equals("NVARCHAR2")) {
            this.mapNcharNVarchar2();
        } else if (CGCPanel.allowTypeMapLOB(this._dbObject)) {
            if (this.type.equals("BLOB")) {
                this.mapBlob();
            } else if (this.type.equals("CLOB")) {
                this.mapClob();
            } else if (this.type.equals("NCLOB")) {
                this.mapNclob();
            }
        }
        if (this._default == null) {
            this._warnmsgType = 2;
            this._cacheable = false;
        }
        if (this._default != null) {
            this._factory = this._default;
        }
    }

    void mapRealFloat() {
        String string = "FLOAT(" + this.prec + ")";
        this._oratypename = this.type.equals("FLOAT") && this.prec > 0 ? string : this.type;
        this._matchtypenames.add("FLOAT(" + this.prec + ")");
        this._matchtypenames.add("BINARY_FLOAT");
        this._matchtypenames.add("BINARY_DOUBLE");
        this._default = this.type.equals("FLOAT") ? string : "REAL";
        this._warnmsgType = 3;
    }

    void mapDblPrec() {
        this._oratypename = this.type;
        this._matchtypenames.add("BINARY_DOUBLE");
        this._default = "BINARY_DOUBLE";
    }

    void mapNumber() {
        boolean bl;
        boolean bl2 = this.precisnull || this.prec == 0;
        boolean bl3 = bl = this.scaleisnull || this.scale == 0;
        if (bl) {
            if (bl2) {
                this._default = this.precisnull && this.scaleisnull ? "NUMBER" : "NUMBER(38)";
                this._matchtypenames.add("TT_TINYINT");
                this._matchtypenames.add("TT_SMALLINT");
                this._matchtypenames.add("TT_INTEGER");
                this._matchtypenames.add("TT_BIGINT");
            } else {
                this._default = "NUMBER(" + this.prec + ")";
                if (this.prec < 3) {
                    this._matchtypenames.add("TT_TINYINT");
                }
                if (this.prec < 5) {
                    this._matchtypenames.add("TT_SMALLINT");
                }
                if (this.prec < 10) {
                    this._matchtypenames.add("TT_INTEGER");
                }
                if (this.prec < 19) {
                    this._matchtypenames.add("TT_BIGINT");
                }
            }
        } else {
            this._default = this.precisnull ? "NUMBER(38," + this.scale + ")" : "NUMBER(" + this.prec + "," + this.scale + ")";
            this._matchtypenames.add("REAL");
            this._matchtypenames.add("BINARY_FLOAT");
            this._matchtypenames.add("BINARY_DOUBLE");
            this._warnmsgType = 3;
        }
        this._oratypename = this.precisnull && this.scaleisnull ? this.type : (this.precisnull ? this.type + "(*," + this.scale + ")" : (this.scaleisnull ? this.type + "(" + this.prec + ",*)" : (this.scale == 0 ? this.type + "(" + this.prec + ")" : this.type + "(" + this.prec + "," + this.scale + ")")));
    }

    void mapLong() {
        this._oratypename = this.type;
        String string = "";
        for (int i = 4096; i <= this._maxlen; i *= 2) {
            string = "VARCHAR2(" + i + " BYTE)";
            this._matchtypenames.add(string);
        }
        this._default = string;
    }

    void mapCharVarchar2() {
        this._default = this._oratypename = this.type + "(" + this._the_len + " " + this._byte_char + ")";
    }

    void mapRawLongRaw() {
        if (this.type.equals("RAW")) {
            this._oratypename = "RAW(" + this.len + ")";
        } else {
            this.len = this._maxlen;
            this._oratypename = "LONG RAW";
        }
        this._default = "VARBINARY(" + this.len + ")";
        if (this.len == this._maxlen) {
            for (int i = 4096; i <= this._maxlen; i *= 2) {
                this._matchtypenames.add("VARBINARY(" + i + ")");
            }
        }
    }

    void mapBlind() {
        this._oratypename = this.type;
        this._default = this.type;
    }

    void mapNcharNVarchar2() {
        this._default = this._oratypename = this.type + "(" + this._the_len + ")";
    }

    void mapBlob() {
        this._oratypename = this.type;
        this._the_len = this.len = 0x400000;
        this._LOBSize = this.len;
        this._default = "VARBINARY(" + this.len + ")";
        this._matchtypenames.add(Messages.getString("CGCColInfo.Change"));
    }

    void mapClob() {
        this._oratypename = this.type;
        this._the_len = this.len = 0x400000;
        this._LOBSize = this.len;
        this._byte_char = "BYTE";
        this._default = "VARCHAR2(" + this._the_len + " " + this._byte_char + ")";
        this._matchtypenames.add(Messages.getString("CGCColInfo.Change"));
    }

    void mapNclob() {
        this._oratypename = this.type;
        this._the_len = this.len = 0x200000;
        this._LOBSize = this.len;
        this._default = "NVARCHAR2(" + this.len + ")";
        this._matchtypenames.add(Messages.getString("CGCColInfo.Change"));
    }

    boolean canBeTBAgingCol() {
        return this.type.startsWith("TIMESTAMP") && this.type.indexOf("ZONE") == -1 || this.type.equals("DATE");
    }

    public String toString() {
        return this.name;
    }

    private void repackageInfo() {
        int n = this._matchtypenames.size();
        boolean bl = n > 0 && this._matchtypenames.contains(this._default);
        this._ttTypes = new String[bl ? n : n + 1];
        int n2 = 0;
        if (!bl) {
            this._ttTypes[0] = this._default;
            ++n2;
        }
        Iterator<String> iterator = this._matchtypenames.iterator();
        while (iterator.hasNext()) {
            this._ttTypes[n2++] = iterator.next();
        }
    }

    void dump() {
        System.out.println("COLUMN_ID       : " + this.colID);
        System.out.println("COLUMN_NAME     : " + this.name);
        System.out.println("DATA_TYPE       : " + this.type);
        System.out.println("DATA_LENGTH     : " + this.len);
        System.out.println("DATA_PRECISION  : " + this.prec);
        System.out.println("DATA_SCALE      : " + this.scale);
        System.out.println("NULLABLE        : " + this.nullability);
        System.out.println("CHAR_LENGTH     : " + this.charlen);
        System.out.println("CHAR_USED       : " + this.charUsed);
        System.out.println("");
    }

    void dumpMappedInfo() {
        System.out.println("    Oracle type : " + this._oratypename);
        System.out.println("Default TT type : " + this._default);
        System.out.println("  Other TT types: ");
        Iterator<String> iterator = this._matchtypenames.iterator();
        while (iterator.hasNext()) {
            System.out.println("                 " + iterator.next());
        }
        System.out.println("------");
    }
}

