/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten.connection;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.raptor.connections.IConnectionPanel;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.raptor.timesten.Messages;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.timesten.commands.TTInstanceInformation;
import oracle.dbtools.raptor.timesten.connection.TTAdvancedPanel;
import oracle.dbtools.raptor.timesten.connection.TTBasicPanel;
import oracle.dbtools.raptor.timesten.connection.TTCSPanel;
import oracle.dbtools.raptor.timesten.connection.TTComponentView;
import oracle.dbtools.raptor.timesten.connection.TimesTenConnectionCreator;
import oracle.dbtools.raptor.timesten.connection.TimesTenConnectionType;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.DatabaseConnections;

public class TTConnectionPanel
extends IConnectionPanel {
    private static final String[] ERROR_STRINGS = new String[]{Messages.getString("TTConnectionPanel.ConnectionCannotBeEmptyForUserSpecifiedDSN"), Messages.getString("TTConnectionPanel.ConnectionStringNeedsToIncludeDSNAttribure"), Messages.getString("TTConnectionPanel.ConnectionStringCannotContainDSNAttribute"), Messages.getString("TTConnectionPanel.ConnectionStringCannotContainOraclePWD"), Messages.getString("TTConnectionPanel.AccessControlIsEnabledUsernameORPassword")};
    private static final String PWD_REGEX = "\\s*[pP][wW][dD]\\s*=.*";
    private static final String ORACLE_PWD_REGEX = "\\s*[oO][rR][aA][cC][lL][eE][pP][wW][dD]\\s*=.*";
    public static final String ORACLE_PWD = "oraclePassword";
    public static final String TIMESTEN_CONNECTION_PANEL_TYPE = "TimesTenConnectionType";
    private static final String TIMESTEN_DRIVERS_REGEX = TimesTenUtil.getRegExForSupportedDrivers();
    private static final Pattern TIMESTEN_DRIVERS_REGEX_PATTERN = Pattern.compile(TIMESTEN_DRIVERS_REGEX, 2);
    public static final String DIRECT_DRIVER_CLASSNAME = "com.timesten.jdbc.TimesTenDriver";
    private JComboBox theConnTypeJCB = new JComboBox<TimesTenConnectionType>(TimesTenConnectionType.values());
    private JLabel theConnTypeLabel = new JLabel();
    private JCheckBox theAutoCommitJChB = new JCheckBox();
    private JLabel theAutoCommitLabel = new JLabel();
    private static Logger theLogger = Logger.getLogger(TTConnectionPanel.class.getPackage().getName());
    private TTInstanceInformation theInstance = TTInstanceInformation.getInstance();
    private JPanel thePanel;
    private CardLayout theCLayout;
    private TTBasicPanel theTTBasicPanel;
    private TTCSPanel theTTCSPanel;
    private TTAdvancedPanel theTTAdvacedPanel;
    private JPanel theTopPanel;
    private JPanel theBottomPanel;
    public static final String AUTOCOMMIT = "AUTOCOMMIT";
    public static final String CACHE_LOAD_ORACLE = "ENABLECACHE";
    public static final String TTORANETSERVICENAME = "ORANETSERVICENAME";

    public TTConnectionPanel() {
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                TTConnectionPanel.this.theInstance.validate((Component)((Object)TTConnectionPanel.this));
                super.componentShown(componentEvent);
            }
        };
        this.addComponentListener(componentAdapter);
        this.init();
    }

    private void init() {
        this.theAutoCommitJChB.setSelected(true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.theCLayout = new CardLayout(0, 0);
        this.thePanel = new JPanel(this.theCLayout);
        this.theTTBasicPanel = new TTBasicPanel(this, this.theInstance);
        this.theTTCSPanel = new TTCSPanel(this);
        this.theTTAdvacedPanel = new TTAdvancedPanel(this);
        this.theTopPanel = new JPanel(new GridBagLayout());
        this.theBottomPanel = new JPanel(new GridBagLayout());
        this.theTopPanel.add((Component)this.theConnTypeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.theTopPanel.add((Component)this.theConnTypeJCB, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.theTopPanel.add((Component)this.theAutoCommitLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.theTopPanel.add((Component)this.theAutoCommitJChB, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        ResourceUtils.resLabel((JLabel)this.theAutoCommitLabel, (Component)this.theAutoCommitJChB, (String)Messages.getString("TTConnectionPanel.autocommit"));
        ResourceUtils.resLabel((JLabel)this.theConnTypeLabel, (Component)this.theConnTypeJCB, (String)ConnectionDialogArb.getString((String)"CONNECTION_TYPE"));
        this.add(this.theTopPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.thePanel.add((Component)this.theTTBasicPanel, TimesTenConnectionType.DIRECT.name());
        this.thePanel.add((Component)this.theTTCSPanel, TimesTenConnectionType.CLIENTSERVER.name());
        this.thePanel.add((Component)this.theTTAdvacedPanel, TimesTenConnectionType.ADVANCED.name());
        this.add(this.thePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 5, 15), 0, 0));
        this.theConnTypeJCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                TTConnectionPanel.this.togglePanels();
            }
        });
    }

    public void clear() {
        this._cd.usePassword(true);
        this._cd.useUserName(true);
    }

    public Properties getConnectionProperties(boolean bl) throws ConnectionException {
        theLogger.info("Include OraclePWD" + bl);
        Properties properties = this.m_props;
        properties.put("RaptorConnectionType", "TimesTen");
        properties.put("driver", DIRECT_DRIVER_CLASSNAME);
        properties.put("subtype", "TimesTen");
        properties.put("user", this.getUserName());
        properties.put("password", this.getPassword());
        properties.put(AUTOCOMMIT, Boolean.toString(this.theAutoCommitJChB.isSelected()));
        TTComponentView tTComponentView = this.getPanel();
        tTComponentView.populateComponent(properties);
        return properties;
    }

    private void togglePanels() {
        if (this.theConnTypeJCB.getSelectedItem().equals((Object)TimesTenConnectionType.DIRECT)) {
            this.theCLayout.show(this.thePanel, TimesTenConnectionType.DIRECT.name());
        } else if (this.theConnTypeJCB.getSelectedItem().equals((Object)TimesTenConnectionType.CLIENTSERVER)) {
            this.theCLayout.show(this.thePanel, TimesTenConnectionType.CLIENTSERVER.name());
        } else if (this.theConnTypeJCB.getSelectedItem().equals((Object)TimesTenConnectionType.ADVANCED)) {
            this.theCLayout.show(this.thePanel, TimesTenConnectionType.ADVANCED.name());
        }
    }

    private TTComponentView getPanel() {
        if (this.theConnTypeJCB.getSelectedItem().equals((Object)TimesTenConnectionType.DIRECT)) {
            return this.theTTBasicPanel;
        }
        if (this.theConnTypeJCB.getSelectedItem().equals((Object)TimesTenConnectionType.CLIENTSERVER)) {
            return this.theTTCSPanel;
        }
        if (this.theConnTypeJCB.getSelectedItem().equals((Object)TimesTenConnectionType.ADVANCED)) {
            return this.theTTAdvacedPanel;
        }
        return null;
    }

    public void testConnection(Properties properties) throws ConnectionException {
        Properties properties2 = this.getConnectionProperties(true);
        String string = properties2.get("URL").toString();
        Connection connection = null;
        if (TimesTenConnectionCreator.shouldPromptForPasswordImpl(properties)) {
            this.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + ERROR_STRINGS[4]);
            theLogger.log(Level.SEVERE, ERROR_STRINGS[4]);
            throw new ConnectionException(ERROR_STRINGS[4]);
        }
        if (!string.toLowerCase().contains("dsn=")) {
            theLogger.log(Level.SEVERE, ERROR_STRINGS[1]);
            throw new ConnectionException(ERROR_STRINGS[1]);
        }
        theLogger.log(Level.INFO, "Testing TimesTen connection " + this.getConnectionName());
        try {
            theLogger.log(Level.INFO, "Start testing TimesTen connection " + this.getConnectionName());
            connection = DatabaseConnections.getInstance().getConnection(properties2);
            for (SQLWarning sQLWarning = connection.getWarnings(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
                theLogger.log(Level.WARNING, sQLWarning.getLocalizedMessage());
            }
            this.getDialog().setPassword(properties2.getProperty("password"));
            if (this.isCache(properties2)) {
                this.testCacheConnection(connection);
            }
            theLogger.log(Level.INFO, "TimesTen connection to " + this.getConnectionName() + " succeeded");
            this.setStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_SUCCESS"));
        }
        catch (Exception exception) {
            theLogger.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            String string2 = exception.getLocalizedMessage();
            int n = string2.indexOf("[TimesTen");
            while (n != -1) {
                int n2 = string2.indexOf("]");
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n2 + 1, string2.length());
                string2 = string3 + string4;
                n = string2.indexOf("[TimesTen");
            }
            this.setErrorStatus(ConnectionDialogArb.getString((String)"CONNECTION_DIALOG_STATUS_FAILURE") + string2);
            theLogger.log(Level.SEVERE, exception.getLocalizedMessage());
            throw new ConnectionException(string2);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    theLogger.log(Level.SEVERE, "Can't close connection when test");
                }
            }
        }
    }

    public static boolean isCSUrl(String string) {
        return string.indexOf(":client:") != -1;
    }

    protected void suppressPasswordAndUserName(Properties properties, boolean bl) {
        boolean bl2 = this.theInstance.accessControlEnabled();
        if (bl2 && properties != null && (this.getUserName() == null || this.getUserName().equals(this.getCurrentUserName()))) {
            theLogger.log(Level.INFO, "Access control enabled, suppress password for external user");
            properties.remove("password");
        }
    }

    private String getCurrentUserName() {
        String string = "";
        try {
            string = System.getProperty("user.name");
            theLogger.info("Current user name" + string);
        }
        catch (Exception exception) {
            theLogger.log(Level.WARNING, "Cannot get login name", exception);
        }
        return string;
    }

    public void updatePrompts(Properties properties) {
        int n;
        int n2;
        TimesTenConnectionType timesTenConnectionType = this.getTimesTenType(properties);
        String string = properties.getProperty("URL");
        String string2 = properties.getProperty(AUTOCOMMIT);
        if (string2 != null) {
            this.theAutoCommitJChB.setSelected(Boolean.parseBoolean(string2));
        }
        if ((n2 = string.indexOf("jdbc:timesten:")) == -1) {
            theLogger.log(Level.SEVERE, "Poorly formed URL " + string);
        }
        String string3 = properties.getProperty(CACHE_LOAD_ORACLE);
        String string4 = string.substring("jdbc:timesten:".length());
        if (timesTenConnectionType == TimesTenConnectionType.DIRECT) {
            this.theConnTypeJCB.setSelectedItem((Object)TimesTenConnectionType.DIRECT);
            n = string4.indexOf(":");
            int n3 = string4.indexOf("ConnectionName=");
            if (n == -1) {
                theLogger.log(Level.SEVERE, "Poorly formed URL " + string);
            }
            String string5 = string4.substring(n + 1, n3);
            String[] stringArray = string5.split(";");
            StringBuffer stringBuffer = new StringBuffer(32);
            for (String string6 : stringArray) {
                String[] stringArray2;
                if (string6.length() == 0 || (stringArray2 = string6.split("=")).length == 0) continue;
                if (stringArray2[0].equalsIgnoreCase("DSN") && this.theTTBasicPanel.theCompleteDSNList.contains(stringArray2[1])) {
                    this.theTTBasicPanel.theDsnListJCB.setSelectedItem(stringArray2[1]);
                    continue;
                }
                if (stringArray2[0].equalsIgnoreCase("OracleNetServiceName")) continue;
                stringBuffer.append(string6 + ";");
            }
            this.theTTBasicPanel.theConnectionAttribJTF.setText(stringBuffer.toString());
            if (string3 != null) {
                this.theTTBasicPanel.theEnableOraclePwdJCB.setSelected(Boolean.parseBoolean(string3));
                if (Boolean.parseBoolean(string3)) {
                    this.theTTBasicPanel.theOraServiceNameJTF.setText(properties.getProperty(TTORANETSERVICENAME));
                }
            }
        } else if (timesTenConnectionType == TimesTenConnectionType.CLIENTSERVER) {
            String[] stringArray;
            this.theConnTypeJCB.setSelectedItem((Object)TimesTenConnectionType.CLIENTSERVER);
            this.theTTCSPanel.theTimeoutJTF.setText("");
            n = string4.indexOf(":");
            int n4 = string4.indexOf("ConnectionName=");
            if (n == -1) {
                theLogger.log(Level.SEVERE, "Poorly formed URL " + string);
            }
            String string7 = string4.substring(n + 1, n4);
            for (String string8 : stringArray = string7.split(";")) {
                String[] stringArray3;
                if (string8.length() == 0 || (stringArray3 = string8.split("=")).length == 0) continue;
                if (stringArray3[0].equalsIgnoreCase("ttc_server_dsn")) {
                    this.theTTCSPanel.theDSNJTF.setText(stringArray3[1]);
                    continue;
                }
                if (stringArray3[0].equalsIgnoreCase("ttc_server")) {
                    this.theTTCSPanel.theServerJTF.setText(stringArray3[1]);
                    continue;
                }
                if (stringArray3[0].equalsIgnoreCase("tcp_port")) {
                    this.theTTCSPanel.thePortJTF.setText(stringArray3[1]);
                    continue;
                }
                if (stringArray3[0].equalsIgnoreCase("OracleNetServiceName")) {
                    this.theTTCSPanel.theOraServiceNameJTF.setText(stringArray3[1]);
                    continue;
                }
                if (!stringArray3[0].equalsIgnoreCase("ttc_timeout")) continue;
                this.theTTCSPanel.theTimeoutJTF.setText(stringArray3[1]);
            }
            if (string3 != null) {
                this.theTTCSPanel.theEnableOraclePwdJCB.setSelected(Boolean.parseBoolean(string3));
                if (Boolean.parseBoolean(string3)) {
                    this.theTTCSPanel.theOraServiceNameJTF.setText(properties.getProperty(TTORANETSERVICENAME));
                }
            }
        } else if (timesTenConnectionType == TimesTenConnectionType.ADVANCED) {
            this.theConnTypeJCB.setSelectedItem((Object)TimesTenConnectionType.ADVANCED);
            n = string4.indexOf(":");
            int n5 = string4.indexOf("ConnectionName=");
            if (n == -1) {
                theLogger.log(Level.SEVERE, "Poorly formed URL " + string);
            }
            String string9 = string4.substring(0, n);
            String string10 = "";
            String string11 = string4.substring(n + 1, n5);
            if (Boolean.parseBoolean(string3)) {
                int n6 = string11.indexOf(";OracleNetServiceName=");
                string10 = string11.substring(0, n6);
            } else {
                string10 = string11;
            }
            string10 = this.deleteExtraSemicolons(string10);
            if (string9.equalsIgnoreCase("CLIENT")) {
                this.theTTAdvacedPanel.theCSButton.setSelected(true);
            } else {
                this.theTTAdvacedPanel.theDirectButton.setSelected(true);
            }
            this.theTTAdvacedPanel.theConnStrField.setText(string10);
            if (string3 != null) {
                this.theTTAdvacedPanel.theEnableOraclePwdJCB.setSelected(Boolean.parseBoolean(string3));
                if (Boolean.parseBoolean(string3)) {
                    this.theTTAdvacedPanel.theOraServiceNameJTF.setText(properties.getProperty(TTORANETSERVICENAME));
                }
            }
        } else {
            this.theConnTypeJCB.setSelectedItem((Object)TimesTenConnectionType.ADVANCED);
            n = string4.indexOf(":");
            int n7 = string4.indexOf("ConnectionName=");
            if (n == -1) {
                theLogger.log(Level.SEVERE, "Poorly formed URL " + string);
            }
            String string12 = string4.substring(0, n);
            String string13 = string4.substring(n + 1, n7);
            string13 = this.deleteExtraSemicolons(string13);
            if (string12.equalsIgnoreCase("CLIENT")) {
                this.theTTAdvacedPanel.theCSButton.setSelected(true);
            } else {
                this.theTTAdvacedPanel.theDirectButton.setSelected(true);
            }
            this.theTTAdvacedPanel.theConnStrField.setText(string13);
            if (string3 != null) {
                this.theTTAdvacedPanel.theEnableOraclePwdJCB.setSelected(Boolean.parseBoolean(string3));
            }
        }
        String string14 = properties.getProperty(ORACLE_PWD);
        if (string14 != null) {
            if (timesTenConnectionType == TimesTenConnectionType.DIRECT) {
                this.theTTBasicPanel.theEnableOraclePwdJCB.setSelected(true);
                this.theTTBasicPanel.theCachePWDField.setText(string14);
            } else if (timesTenConnectionType == TimesTenConnectionType.CLIENTSERVER) {
                this.theTTCSPanel.theEnableOraclePwdJCB.setSelected(true);
                this.theTTCSPanel.theCachePWDField.setText(string14);
            } else if (timesTenConnectionType == TimesTenConnectionType.ADVANCED) {
                this.theTTAdvacedPanel.theEnableOraclePwdJCB.setSelected(true);
                this.theTTAdvacedPanel.theCachePWDField.setText(string14);
            } else {
                this.theTTAdvacedPanel.theEnableOraclePwdJCB.setSelected(true);
                this.theTTAdvacedPanel.theCachePWDField.setText(string14);
            }
        }
    }

    private String deleteExtraSemicolons(String string) {
        String[] stringArray = string.split(";");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray) {
            if (string2.length() == 0) continue;
            stringBuilder.append(string2);
            stringBuilder.append(";");
        }
        return stringBuilder.toString();
    }

    public String getDriver() {
        return DIRECT_DRIVER_CLASSNAME;
    }

    protected boolean hasPassword(String string) {
        String[] stringArray = string.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].matches(PWD_REGEX) && !stringArray[i].matches(ORACLE_PWD_REGEX)) continue;
            return true;
        }
        return false;
    }

    private boolean isCache(Properties properties) {
        return properties.getProperty(ORACLE_PWD) != null;
    }

    private boolean testCacheConnection(Connection connection) throws ConnectionException {
        Statement statement = null;
        PreparedStatement preparedStatement = null;
        try {
            theLogger.info("Testing end-to-end Oracle connectivity for Cache connection");
            connection.setAutoCommit(false);
            preparedStatement = connection.prepareStatement("call ttOptSetFlag('Passthrough',3)");
            preparedStatement.execute();
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("select * from v$version");
            resultSet.next();
            resultSet.close();
            theLogger.info("End-to-end Oracle connectivity for Cache connection succeeded.");
            boolean bl = true;
            return bl;
        }
        catch (SQLException sQLException) {
            this.setErrorStatus(Messages.getString("TTConnectionPanel.CannotConnectToOracle") + sQLException.getMessage());
            theLogger.log(Level.SEVERE, "Cannot connect to Oracle " + sQLException.getMessage());
            throw new ConnectionException(Messages.getString("TTConnectionPanel.CannotConnectToOracle") + sQLException.getMessage());
        }
        finally {
            try {
                connection.rollback();
                if (statement != null) {
                    statement.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void setDefaultPrompts() {
    }

    public Properties getConnectionProperties() {
        try {
            return this.getConnectionProperties(false);
        }
        catch (ConnectionException connectionException) {
            return null;
        }
    }

    public String getConnectionType() {
        return "TimesTen";
    }

    private TimesTenConnectionType getTimesTenType(Properties properties) {
        String string = properties.getProperty(TIMESTEN_CONNECTION_PANEL_TYPE);
        if (string != null) {
            try {
                return TimesTenConnectionType.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return TimesTenConnectionType.ADVANCED;
    }
}

