/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;

public class TimesTenPassthrough {
    private static int PASSTHROUGH_TIMESTEN = 0;
    private static int PASSTHROUGH_ORACLE = 3;
    private static String ORACLE_PASSTHROUGH_CALL = "call ttOptSetFlag('PassThrough', 3);";
    private static String PASSTHROUGH_CALL = "call ttOptSetFlag('PassThrough', #level#);";
    private static String GET_PASSTHROUGH = "call ttOptGetFlag('PassThrough');";
    private Connection connection;
    private int currentPassthrough;
    private boolean defaultAutocommit;
    private String lastError;
    private static Logger _logger = Logger.getLogger(TimesTenPassthrough.class.getPackage().getName());

    public TimesTenPassthrough(DBObject dBObject) {
        try {
            this.connection = Connections.getInstance().getUniqueConnection(dBObject.getConnectionName());
            this.defaultAutocommit = this.connection.getAutoCommit();
        }
        catch (SQLException sQLException) {
            _logger.log(Level.SEVERE, "Can't get autocommit configuration", sQLException);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executePasswthrough(int n) throws SQLException {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            statement.execute(PASSTHROUGH_CALL.replace("#level#", Integer.toString(n)));
            this.currentPassthrough = n;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    _logger.log(Level.SEVERE, "Can't close statement", sQLException);
                }
            }
        }
    }

    private void doOraclePassthrough() {
        try {
            this.connection.setAutoCommit(false);
            this.executePasswthrough(PASSTHROUGH_ORACLE);
        }
        catch (SQLException sQLException) {
            _logger.log(Level.SEVERE, "Can't passthrough to oracle", sQLException);
        }
    }

    private void doTimestenPassthrough() {
        try {
            this.connection.setAutoCommit(this.defaultAutocommit);
            this.executePasswthrough(PASSTHROUGH_TIMESTEN);
        }
        catch (SQLException sQLException) {
            _logger.log(Level.SEVERE, "Can't passthrough to timesten", sQLException);
        }
    }

    public List<Object[]> executeQueryOnOracle(String string) throws SQLException {
        Statement statement = null;
        this.connection.setAutoCommit(false);
        LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
        this.connection.setAutoCommit(false);
        statement = this.connection.createStatement();
        statement.execute(ORACLE_PASSTHROUGH_CALL);
        Connections.getInstance().lock(this.connection);
        ResultSet resultSet = statement.executeQuery(string);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        Object[] objectArray = null;
        while (resultSet.next()) {
            objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = resultSet.getObject(i + 1);
            }
            linkedList.add(objectArray);
        }
        this.connection.setAutoCommit(this.defaultAutocommit);
        if (statement != null) {
            statement.close();
        }
        Connections.getInstance().unlock(this.connection);
        return linkedList;
    }

    public Integer executeTableCountOnOracle(String string) throws SQLException {
        List<Object[]> list = this.executeQueryOnOracle(string);
        if (list.size() > 0) {
            if (list.get(0)[0] instanceof Integer) {
                return (Integer)list.get(0)[0];
            }
            if (list.get(0)[0] instanceof BigDecimal) {
                return ((BigDecimal)list.get(0)[0]).intValue();
            }
        }
        return null;
    }

    public Integer executeTableCountOnOracleFromAllTables(String string, String string2) throws SQLException {
        String string3 = "SELECT NUM_ROWS FROM ALL_TABLES WHERE TABLE_NAME='" + string2 + "' AND OWNER ='" + string.toUpperCase() + "'";
        List<Object[]> list = this.executeQueryOnOracle(string3);
        if (list.size() > 0) {
            if (list.get(0)[0] instanceof Integer) {
                return (Integer)list.get(0)[0];
            }
            if (list.get(0)[0] instanceof BigDecimal) {
                return ((BigDecimal)list.get(0)[0]).intValue();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getPassthrough() {
        Statement statement = null;
        try {
            statement = this.connection.createStatement();
            Connections.getInstance().lock(this.connection);
            ResultSet resultSet = statement.executeQuery(GET_PASSTHROUGH);
            if (resultSet.next()) {
                int n = resultSet.getInt(2);
                return n;
            }
            int n = -1;
            return n;
        }
        catch (SQLException sQLException) {
            _logger.log(Level.SEVERE, "Can't get passthrough", sQLException);
            int n = -1;
            return n;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    _logger.log(Level.SEVERE, "Can't close statement", sQLException);
                }
            }
            Connections.getInstance().unlock(this.connection);
        }
    }

    public void resetPassthrough() {
        this.doTimestenPassthrough();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public synchronized String getLastError() {
        String string = this.lastError;
        this.lastError = null;
        return string;
    }
}

