/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.timesten.SimpleQuery;
import oracle.dbtools.raptor.timesten.dialogs.cache.CGCPanel;
import oracle.dbtools.raptor.utils.DBObject;

public class PassThrough3Manager {
    int _passThroughFlag;
    boolean _autoCommitChanged;
    DBObject _dbObject;

    public PassThrough3Manager(DBObject dBObject) {
        if (CGCPanel.inhibitIdleInit) {
            this._dbObject = dBObject;
        }
    }

    public void setup() {
        if (CGCPanel.inhibitIdleInit) {
            Connection connection = this._dbObject.getConnection();
            try {
                if (connection.getAutoCommit()) {
                    this._autoCommitChanged = true;
                    connection.setAutoCommit(false);
                }
                this._passThroughFlag = SimpleQuery.ttOptGetFlag(this._dbObject, "PassThrough");
                SimpleQuery.ttOptSetFlag(this._dbObject, "PassThrough", 3);
            }
            catch (Exception exception) {
                Logger.getLogger("PassThrough3Manager").log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    public void restore() {
        if (CGCPanel.inhibitIdleInit) {
            if (this._passThroughFlag != -1) {
                SimpleQuery.ttOptSetFlag(this._dbObject, "PassThrough", this._passThroughFlag);
            }
            if (this._autoCommitChanged) {
                Connection connection = this._dbObject.getConnection();
                try {
                    connection.setAutoCommit(true);
                }
                catch (Exception exception) {
                    Logger.getLogger("PassThrough3Manager").log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }
        }
    }
}

