/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.timesten;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.raptor.timesten.TimesTenUtil;
import oracle.dbtools.raptor.timesten.commands.TTInstanceInformation;
import oracle.dbtools.raptor.utils.DBObject;

public class DataSheet {
    private Map<Connection, Version> theVersionMap = Collections.synchronizedMap(new WeakHashMap());
    public final String theDataSheet = "DataSheet.properties";
    private Properties theCapabilityMatrix;
    private static Logger theLogger = Logger.getLogger(DataSheet.class.getPackage().getName());
    private static DataSheet theInstance;
    static Version myVersion;

    private DataSheet() {
        try {
            this.theCapabilityMatrix = new Properties();
            InputStream inputStream = this.getClass().getResourceAsStream("DataSheet.properties");
            if (inputStream == null) {
                throw new RuntimeException("Cannot load the DataSheet.properties");
            }
            this.theCapabilityMatrix.load(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            theLogger.log(Level.SEVERE, "Cannot load properties file", iOException);
        }
    }

    public static synchronized DataSheet getInstance() {
        if (theInstance == null) {
            theInstance = new DataSheet();
        }
        return theInstance;
    }

    public boolean isCapable(DBObject dBObject, FeatureType featureType) {
        Connection connection = dBObject.getConnection();
        return this.isCapable(connection, featureType);
    }

    public boolean isCapable(Connection connection, FeatureType featureType) {
        Version version = this.theVersionMap.get(connection);
        if (version == null || featureType == FeatureType.HashInCacheGroup) {
            String string = TimesTenUtil.ttFullDotVersion(connection);
            if (featureType == FeatureType.HashInCacheGroup) {
                string = TTInstanceInformation.getInstance().getInstanceVersion();
            }
            if (string == null) {
                theLogger.log(Level.SEVERE, "Cannot assess database version");
                return false;
            }
            version = new Version(string);
            this.theVersionMap.put(connection, version);
        }
        return this.isFeatureCapable(featureType, version);
    }

    public boolean isClientCapable(FeatureType featureType) {
        Version version = new Version(TTInstanceInformation.getInstance().getInstanceVersion());
        return this.isFeatureCapable(featureType, version);
    }

    private void SAY(String string) {
    }

    private boolean isFeatureCapable(FeatureType featureType, Version version) {
        String string = this.theCapabilityMatrix.getProperty(featureType.getTag());
        int n = string.indexOf(35);
        if (n > -1) {
            string = string.substring(0, n);
        }
        try {
            String[] stringArray = string.split(",");
            this.SAY("Feature <" + featureType.getTag() + ">, \n");
            this.SAY("  My    version <" + version + ">, \n");
            this.SAY("  First version <" + stringArray[0] + ">: ");
            if (version.compareTo(new Version(stringArray[0])) >= 0) {
                this.SAY("Implemented\n");
                return true;
            }
            this.SAY("DARK\n");
            int n2 = version.toIntArray()[0];
            for (int i = 1; i < stringArray.length; ++i) {
                try {
                    Version version2 = new Version(stringArray[i]);
                    this.SAY("  Back port     <" + version2 + ">: ");
                    int n3 = version2.toIntArray()[0];
                    if (n2 == n3) {
                        if (version.compareTo(version2) >= 0) {
                            this.SAY("Implemented\n");
                            return true;
                        }
                        this.SAY("DARK\n");
                        continue;
                    }
                    this.SAY("Irrelevent\n");
                    continue;
                }
                catch (Exception exception) {
                    Logger.getLogger("AgingInfo").log(Level.WARNING, "Failed to check minor version for feature " + (Object)((Object)featureType), exception);
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger("AgingInfo").log(Level.WARNING, "Failed to check major version for feature " + (Object)((Object)featureType), exception);
        }
        return false;
    }

    public static enum FeatureType {
        ObjectLevelPrivilege("ObjectLevelPrivilege"),
        GlobalDynamicCG("GlobalDynamicCG"),
        BitMapIndex("BitMapIndex"),
        SecondsPrecisionTimeBasedAging("SecondsPrecisionTimeBasedAging"),
        TTSchemaSqlDeveloperArg("TTSchemaSqlDeveloperArg"),
        AllObjects("AllObjects"),
        TypeMapLOB("TypeMapLOB"),
        NonDynamicGlobalCG("NonDynamicGlobalCG"),
        TTSchemaSynonym("TTSchemaSynonym"),
        MVLogs("MVLogs"),
        LobSupport("LobSupport"),
        HashInCacheGroup("HashInCacheGroup"),
        UNDEFINED("UNDEFINED");

        private String _tag;

        protected String getTag() {
            return this._tag;
        }

        private FeatureType(String string2) {
            this._tag = string2;
        }
    }
}

