/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.swing.date;

import ilog.views.util.swing.date.DateCellEditorPopupMenu;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.basic.BasicArrowButton;

class DateEditorDropDown
extends JComponent {
    static final String a = "StopEdition";
    static final String b = "CancelEdition";
    protected JTextField dateField;
    protected JButton arrowButton;
    protected DateCellEditorPopupMenu popup;
    protected FormattedDatePropertyEditor propertyEditor = new FormattedDatePropertyEditor();
    protected Object currentDate;
    protected FocusListener focusListener;
    static String c = "DateProperty";

    public DateEditorDropDown() {
        this.installComponents();
        this.installListeners();
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.propertyEditor.setFormat(dateFormat);
    }

    public void setTimeFormat(DateFormat dateFormat) {
        this.popup.setTimeFormat(dateFormat);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.dateField.setEnabled(bl);
        this.arrowButton.setVisible(bl);
    }

    public JComponent getEditorComponent() {
        return this.dateField;
    }

    protected void installComponents() {
        this.setLayout(new BorderLayout());
        this.popup = new DateCellEditorPopupMenu(this);
        this.dateField = new JTextField();
        this.dateField.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.dateField, "Center");
        this.arrowButton = new BasicArrowButton(5);
        if (this.getComponentOrientation().isLeftToRight()) {
            this.add((Component)this.arrowButton, "East");
        } else {
            this.add((Component)this.arrowButton, "West");
        }
        this.a();
    }

    protected void installListeners() {
        this.installFocusListener();
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && DateEditorDropDown.this.isEnabled()) {
                    DateEditorDropDown.this.a(mouseEvent);
                    DateEditorDropDown.this.b();
                }
            }
        };
        this.arrowButton.addMouseListener(mouseAdapter);
        this.propertyEditor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object = DateEditorDropDown.this.propertyEditor.getValue();
                if (DateEditorDropDown.this.currentDate != null && DateEditorDropDown.this.currentDate.equals(object)) {
                    return;
                }
                DateEditorDropDown.this.currentDate = object;
                DateEditorDropDown.this.e();
            }
        });
        this.installActionListener();
        this.installAncestorListener();
    }

    protected void installActionListener() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = DateEditorDropDown.this.dateField.getText();
                try {
                    Object object = DateEditorDropDown.this.propertyEditor.getFormat().parseObject(string);
                    DateEditorDropDown.this.propertyEditor.setValue(object);
                    ActionEvent actionEvent2 = new ActionEvent(actionEvent.getSource(), actionEvent.getID(), DateEditorDropDown.a);
                    DateEditorDropDown.this.a(actionEvent2);
                }
                catch (ParseException parseException) {
                    DateEditorDropDown.this.dateField.setBorder(new LineBorder(Color.red));
                }
            }
        };
        this.dateField.addActionListener(actionListener);
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DateEditorDropDown.this.a(actionEvent);
            }
        };
        this.popup.addActionListener(actionListener);
    }

    protected void installFocusListener() {
        this.focusListener = new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary() && !DateEditorDropDown.this.dateField.hasFocus()) {
                    DateEditorDropDown.this.d();
                }
                DateEditorDropDown.this.repaint();
            }
        };
        this.addFocusListener(this.focusListener);
    }

    protected void installAncestorListener() {
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                DateEditorDropDown.this.validate();
                DateEditorDropDown.this.repaint();
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                DateEditorDropDown.this.d();
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
                if (ancestorEvent.getSource() != DateEditorDropDown.this) {
                    DateEditorDropDown.this.c();
                } else {
                    DateEditorDropDown.this.d();
                }
            }
        });
    }

    private void a() {
        this.arrowButton.setEnabled(this.isEnabled());
        this.arrowButton.resetKeyboardActions();
    }

    private void a(MouseEvent mouseEvent) {
        if (this.getEditorComponent().isRequestFocusEnabled()) {
            this.getEditorComponent().requestFocusInWindow();
        } else if (this.isRequestFocusEnabled()) {
            this.requestFocusInWindow();
        }
    }

    private void b() {
        if (this.popup.isVisible()) {
            this.popup.b();
        } else {
            this.popup.a();
        }
    }

    private void c() {
        this.popup.a();
        this.popup.requestFocusInWindow();
    }

    private void d() {
        this.popup.b();
    }

    public void setDate(Object object) {
        Object object2 = this.currentDate;
        if (object instanceof Date) {
            this.currentDate = (Date)object;
            this.propertyEditor.setValue(this.currentDate);
        } else if (object instanceof String) {
            try {
                this.propertyEditor.setAsText((String)object);
                this.currentDate = this.propertyEditor.getValue();
            }
            catch (Exception exception) {
                this.currentDate = null;
            }
        }
        this.e();
    }

    public Object getDate() {
        return this.currentDate;
    }

    private void e() {
        if (this.dateField != null) {
            if (this.currentDate != null) {
                this.dateField.setText(this.propertyEditor.getAsText());
                this.dateField.setCaretPosition(0);
                this.dateField.setBorder(new LineBorder(Color.black));
            } else {
                this.dateField.setText("");
                this.dateField.setBorder(new LineBorder(Color.red));
            }
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(ActionListener.class, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList.remove(ActionListener.class, actionListener);
    }

    private void a(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != ActionListener.class) continue;
            ((ActionListener)objectArray[i2 + 1]).actionPerformed(actionEvent);
        }
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    protected class FormattedDatePropertyEditor
    extends PropertyEditorSupport {
        private DateFormat a = DateFormat.getDateInstance();

        protected FormattedDatePropertyEditor() {
        }

        public void setFormat(DateFormat dateFormat) {
            this.a = dateFormat;
        }

        public DateFormat getFormat() {
            return this.a;
        }

        public void setAsText(String string) {
            if (string == null) {
                this.setValue(null);
            }
            if (string.equals("")) {
                this.setValue(null);
            }
            Object object = null;
            try {
                object = this.getFormat().parseObject(string);
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException("could not parse: " + string);
            }
            this.setValue(object);
        }

        public String getAsText() {
            try {
                Object object = this.getValue();
                if (object != null) {
                    return this.getFormat().format(object);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            return "";
        }
    }
}

