/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.collections.internal;

import java.util.ArrayList;

public class IlvBalancedBinaryTreeWithShift {
    private Node a = null;

    public Node getRoot() {
        return this.a;
    }

    public int getSize() {
        return this.a != null ? this.a.getBranchSize() : 0;
    }

    public Entry getEntryAt(int n2) {
        if (this.a != null) {
            return this.a.getEntry(n2);
        }
        throw new IndexOutOfBoundsException();
    }

    public int getIndexOfEntry(Entry entry) {
        if (this.a != null) {
            return this.a.a.indexOf(entry);
        }
        return -1;
    }

    public Node getPredecessor(Node node) {
        return null;
    }

    public Node getSuccessor(Node node) {
        return null;
    }

    public void deleteEntry(Entry entry) {
        if (this.a != null) {
            this.a.a.remove(entry);
            if (this.a.getEntriesCount() == 0) {
                this.a = null;
            }
        }
    }

    public void deleteAll() {
        this.a = null;
    }

    public void init(Entry[] entryArray) {
        if (entryArray.length == 0) {
            this.a = null;
        } else {
            if (this.a == null) {
                this.a = new Node();
            }
            this.a.a.clear();
            for (Entry entry : entryArray) {
                this.a.a.add(entry);
                entry.a = this.a;
            }
        }
    }

    public void insertEntryAtRoot(Entry entry) {
        if (this.a != null) {
            throw new IllegalStateException();
        }
        this.a = new Node();
        this.a.a.add(entry);
        entry.a = this.a;
        entry.valuePart -= this.a.getShiftSum();
    }

    public void insertEntryBefore(Node node, Entry entry) {
        if (node != this.a) {
            throw new IllegalArgumentException();
        }
        node.a.add(0, entry);
        entry.a = node;
        entry.valuePart -= node.getShiftSum();
    }

    public void insertEntryAfter(Node node, Entry entry) {
        if (node != this.a) {
            throw new IllegalArgumentException();
        }
        node.a.add(entry);
        entry.a = node;
        entry.valuePart -= node.getShiftSum();
    }

    public void insertEntryInto(Node node, int n2, Entry entry) {
        if (node != this.a) {
            throw new IllegalArgumentException();
        }
        if (n2 <= 0 || n2 >= this.getSize()) {
            throw new IllegalArgumentException();
        }
        node.a.add(n2, entry);
        entry.a = node;
        entry.valuePart -= node.getShiftSum();
    }

    public static class Node {
        private ArrayList<Entry> a = new ArrayList();
        public int shift;

        public int getEntriesCount() {
            return this.a.size();
        }

        public Entry getEntry(int n2) {
            return this.a.get(n2);
        }

        public Node getLeftBranch() {
            return null;
        }

        public Node getRightBranch() {
            return null;
        }

        public int getBranchSize() {
            return this.getEntriesCount();
        }

        public Node getParent() {
            return null;
        }

        public int getShiftSum() {
            return this.shift;
        }
    }

    public static abstract class Entry {
        Node a;
        public int valuePart;

        public Node getHoldingNode() {
            return this.a;
        }

        public int getValue() {
            return this.valuePart + (this.a != null ? this.a.getShiftSum() : 0);
        }
    }
}

