/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.util.beans;

import ilog.views.util.beans.IlvPropertyEditorManager;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;

public final class IlvBeanUtil {
    private IlvBeanUtil() {
    }

    public static PropertyEditor createPropertyEditor(Class clazz, String string) {
        PropertyDescriptor propertyDescriptor = IlvBeanUtil.findPropertyDescriptor(clazz, string);
        return propertyDescriptor != null ? IlvBeanUtil.createPropertyEditor(propertyDescriptor) : null;
    }

    public static PropertyDescriptor findPropertyDescriptor(Class clazz, String string) {
        BeanInfo beanInfo;
        if (clazz == null) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("propertyName shouldn't be null or empty");
        }
        try {
            Class clazz2 = clazz;
            while (true) {
                try {
                    beanInfo = Introspector.getBeanInfo(clazz);
                }
                catch (ClassFormatError classFormatError) {
                    clazz2 = clazz2.getSuperclass();
                    if (clazz2 != null) continue;
                    return null;
                }
                break;
            }
        }
        catch (IntrospectionException introspectionException) {
            RuntimeException runtimeException = new RuntimeException(introspectionException.getMessage());
            runtimeException.initCause(introspectionException);
            throw runtimeException;
        }
        return IlvBeanUtil.findPropertyDescriptor(beanInfo, string);
    }

    public static PropertyDescriptor findPropertyDescriptor(BeanInfo beanInfo, String string) {
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        int n2 = propertyDescriptorArray != null ? propertyDescriptorArray.length : 0;
        PropertyDescriptor propertyDescriptor = null;
        String string2 = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            propertyDescriptor = propertyDescriptorArray[i2];
            string2 = propertyDescriptor.getName();
            if (!string2.equals(string)) continue;
            return propertyDescriptor;
        }
        return null;
    }

    public static PropertyEditor createPropertyEditor(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException("propDescriptor cannot be null");
        }
        PropertyEditor propertyEditor = null;
        Class<?> clazz = propertyDescriptor.getPropertyEditorClass();
        if (clazz != null) {
            try {
                propertyEditor = (PropertyEditor)clazz.newInstance();
            }
            catch (Exception exception) {
                propertyEditor = null;
            }
        } else {
            Class<?> clazz2 = propertyDescriptor.getPropertyType();
            propertyEditor = IlvPropertyEditorManager.findEditor(clazz2);
        }
        return propertyEditor;
    }
}

