/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.internal;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvManager;
import ilog.views.internal.impl.IlvUtility2D;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import ilog.views.java2d.IlvBlinkingAction;
import ilog.views.util.java2d.IlvBlinkingMultiPaint;
import ilog.views.util.java2d.IlvBlinkingPaint;
import ilog.views.util.java2d.IlvLinearGradientPaint;
import ilog.views.util.java2d.IlvRadialGradientPaint;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.io.IOException;

public class IlvBlinkingUtil {
    public static long ToggleVisibilityBlinkingOnPeriod = 1000L;
    public static long ToggleVisibilityBlinkingOffPeriod = 1000L;
    public static final RenderingHints.Key KEY_BLINKING = BlinkingKey.c;
    public static final Object VALUE_BLINKING_ON = BlinkingKey.a;
    public static final Object VALUE_BLINKING_OFF = BlinkingKey.b;

    public static boolean setBlinkingActionDisabled(IlvManager ilvManager, boolean bl) {
        if (ilvManager == null) {
            return false;
        }
        boolean bl2 = false;
        IlvBlinkingAction ilvBlinkingAction = ilvManager.getBlinkingAction();
        if (ilvBlinkingAction != null) {
            ilvBlinkingAction.setTemporarilyDisabled(bl);
            bl2 = true;
        }
        if (IlvBlinkingUtil.a(ilvManager, bl)) {
            bl2 = true;
        }
        return bl2;
    }

    private static boolean a(IlvGraphicBag ilvGraphicBag, boolean bl) {
        if (ilvGraphicBag == null) {
            return false;
        }
        boolean bl2 = false;
        IlvGraphicEnumeration ilvGraphicEnumeration = ilvGraphicBag.getObjects();
        if (ilvGraphicEnumeration != null) {
            while (ilvGraphicEnumeration.hasMoreElements()) {
                IlvGraphic ilvGraphic = ilvGraphicEnumeration.nextElement();
                IlvBlinkingAction ilvBlinkingAction = ilvGraphic.getBlinkingAction();
                if (ilvBlinkingAction != null) {
                    ilvBlinkingAction.setTemporarilyDisabled(bl);
                    bl2 = true;
                }
                if (!(ilvGraphic instanceof IlvGraphicBag) || !IlvBlinkingUtil.a((IlvGraphicBag)((Object)ilvGraphic), bl)) continue;
                bl2 = true;
            }
        }
        return bl2;
    }

    public static final void setToggleVisibility(IlvGraphic ilvGraphic, boolean bl) {
        if (bl) {
            ilvGraphic.setBlinkingOnPeriod(ToggleVisibilityBlinkingOnPeriod);
            ilvGraphic.setBlinkingOffPeriod(ToggleVisibilityBlinkingOffPeriod);
        } else {
            ilvGraphic.setBlinkingOnPeriod(0L);
            ilvGraphic.setBlinkingOffPeriod(0L);
        }
    }

    public static final boolean getToggleVisibility(IlvGraphic ilvGraphic) {
        return ilvGraphic.getBlinkingOnPeriod() > 0L && ilvGraphic.getBlinkingOffPeriod() > 0L;
    }

    public static void setBlinkingAllowed(Graphics graphics, boolean bl) {
        if (bl == IlvBlinkingUtil.isBlinkingAllowed(graphics)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(KEY_BLINKING, bl ? VALUE_BLINKING_ON : VALUE_BLINKING_OFF);
    }

    public static boolean isBlinkingAllowed(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        return !IlvGraphicUtil.isPrinting(graphics2D) && graphics2D.getRenderingHint(KEY_BLINKING) != VALUE_BLINKING_OFF;
    }

    public static IlvPersistentObject getProxyFromPaint(Paint paint) {
        if (paint instanceof IlvBlinkingPaint) {
            return new IPaint((IlvBlinkingPaint)paint);
        }
        if (paint instanceof IlvBlinkingMultiPaint) {
            return new IMultiPaint((IlvBlinkingMultiPaint)paint);
        }
        if (paint instanceof IlvLinearGradientPaint) {
            IlvLinearGradientPaint ilvLinearGradientPaint = (IlvLinearGradientPaint)paint;
            return new ilog.views.java2d.IlvLinearGradientPaint(ilvLinearGradientPaint);
        }
        if (paint instanceof IlvRadialGradientPaint) {
            IlvRadialGradientPaint ilvRadialGradientPaint = (IlvRadialGradientPaint)paint;
            return new ilog.views.java2d.IlvRadialGradientPaint(ilvRadialGradientPaint);
        }
        return null;
    }

    public static Paint getPaintFromProxy(Object object) {
        if (object instanceof PaintFactory) {
            return ((PaintFactory)object).getPaint();
        }
        return null;
    }

    public static class IMultiPaint
    implements IlvPersistentObject,
    PaintFactory {
        private Paint[] a;
        private long b;

        public IMultiPaint(IlvBlinkingMultiPaint ilvBlinkingMultiPaint) {
            this.a = ilvBlinkingMultiPaint.getPaints();
            this.b = ilvBlinkingMultiPaint.getOnPeriod();
        }

        public IMultiPaint(IlvInputStream ilvInputStream) throws IlvReadFileException {
            this.b = ilvInputStream.readLong("period");
            int n2 = ilvInputStream.readInt("numPaints");
            this.a = new Paint[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = "paint" + i2;
                String string2 = "p" + i2;
                this.a[i2] = IlvUtility2D.readPaint(ilvInputStream, string, string2);
            }
        }

        public void write(IlvOutputStream ilvOutputStream) throws IOException {
            ilvOutputStream.write("period", this.b);
            Paint[] paintArray = this.a;
            ilvOutputStream.write("numPaints", paintArray.length);
            for (int i2 = 0; i2 < paintArray.length; ++i2) {
                String string = "paint" + i2;
                String string2 = "p" + i2;
                IlvUtility2D.writePaint(ilvOutputStream, paintArray[i2], string, string2, Color.black);
            }
        }

        public Paint getPaint() {
            return new IlvBlinkingMultiPaint(this.b, this.a);
        }
    }

    public static class IPaint
    implements IlvPersistentObject,
    PaintFactory {
        private Paint a;
        private Paint b;
        private long c;
        private long d;

        public IPaint(IlvBlinkingPaint ilvBlinkingPaint) {
            this.a = ilvBlinkingPaint.getOnPaint();
            this.b = ilvBlinkingPaint.getOffPaint();
            this.c = ilvBlinkingPaint.getOnPeriod();
            this.d = ilvBlinkingPaint.getOffPeriod();
        }

        public IPaint(IlvInputStream ilvInputStream) throws IlvReadFileException {
            this.c = ilvInputStream.readLong("onPeriod");
            this.d = ilvInputStream.readLong("offPeriod");
            this.a = IlvUtility2D.readPaint(ilvInputStream, "onPaint", "on");
            this.b = IlvUtility2D.readPaint(ilvInputStream, "offPaint", "off");
        }

        public void write(IlvOutputStream ilvOutputStream) throws IOException {
            ilvOutputStream.write("onPeriod", this.c);
            ilvOutputStream.write("offPeriod", this.d);
            IlvUtility2D.writePaint(ilvOutputStream, this.a, "onPaint", "on", Color.black);
            IlvUtility2D.writePaint(ilvOutputStream, this.b, "offPaint", "off", Color.black);
        }

        public Paint getPaint() {
            return new IlvBlinkingPaint(this.a, this.b, this.c, this.d);
        }
    }

    public static interface PaintFactory {
        public Paint getPaint();
    }

    private static final class BlinkingKey
    extends RenderingHints.Key {
        static final Object a = Boolean.TRUE;
        static final Object b = Boolean.FALSE;
        static BlinkingKey c = new BlinkingKey(20081205);

        private BlinkingKey(int n2) {
            super(n2);
        }

        public boolean isCompatibleValue(Object object) {
            return object == null || object == a || object == b;
        }
    }
}

