/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvDefinitionRectInterface;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvScale;
import ilog.views.internal.IlvUtility;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.io.IOException;

public class IlvRectangularScale
extends IlvScale
implements IlvDefinitionRectInterface {
    private int a;
    private int b;
    private int c = 1;
    private boolean d = false;
    private boolean e = false;
    private static final int f = 2;

    public IlvRectangularScale(IlvPoint ilvPoint, float f2, String string, float f3, float f4, int n2, int n3, int n4, int n5, float f5, float f6) {
        super(new IlvRect(), n2, n3, f5, f6, f3, f4, string);
        if (n4 != 4 && n4 != 1 && n4 != 2 && n4 != 8) {
            throw new IllegalArgumentException("bad origin position");
        }
        this.b = n4;
        this.setLabelsPosition(n5);
        this.a(ilvPoint, f2);
    }

    public IlvRectangularScale(IlvPoint ilvPoint, float f2, String[] stringArray, int n2, int n3, int n4, float f3, float f4) {
        super(new IlvRect(), stringArray, n2, f3, f4);
        if (n3 != 4 && n3 != 1 && n3 != 2 && n3 != 8) {
            throw new IllegalArgumentException("bad origin position");
        }
        this.b = n3;
        this.setLabelsPosition(n4);
        this.a(ilvPoint, f2);
    }

    public IlvRectangularScale() {
        this(new IlvPoint(), 100.0f, "###", 0.0f, 100.0f, 5, 2, 1, 4, 5.0f, 2.0f);
    }

    public IlvRectangularScale(IlvRectangularScale ilvRectangularScale) {
        super(ilvRectangularScale);
        this.a = ilvRectangularScale.a;
        this.b = ilvRectangularScale.b;
        this.e = ilvRectangularScale.e;
        this.d = ilvRectangularScale.d;
        this.c = ilvRectangularScale.c;
    }

    public IlvRectangularScale(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.b = ilvInputStream.readInt("originPosition");
        this.a = ilvInputStream.readInt("labelsPosition");
        try {
            this.e = ilvInputStream.readBoolean("labelsCentered");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public IlvGraphic copy() {
        return new IlvRectangularScale(this);
    }

    public final int getOriginPosition() {
        return this.b;
    }

    public final void setOriginPosition(int n2) {
        float f2;
        IlvPoint ilvPoint;
        if (n2 == 4 || n2 == 1 || n2 == 2 || n2 == 8) {
            ilvPoint = new IlvPoint();
            f2 = this.a(ilvPoint);
            this.b = n2;
            if (this.d()) {
                if (this.a == 1) {
                    this.a = 8;
                } else if (this.a == 2) {
                    this.a = 4;
                }
            } else if (this.a == 4) {
                this.a = 2;
            } else if (this.a == 8) {
                this.a = 1;
            }
        } else {
            throw new IllegalArgumentException("orientation should be top, left, right or botton");
        }
        this.a(ilvPoint, f2);
    }

    public final int getLabelsPosition() {
        return this.a;
    }

    public final void setLabelsPosition(int n2) {
        if (n2 != 4 && n2 != 8 && n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Unsupported position for labels: " + n2);
        }
        if (this.d()) {
            if (n2 == 1) {
                n2 = 8;
            } else if (n2 == 2) {
                n2 = 4;
            }
        } else if (n2 == 4) {
            n2 = 2;
        } else if (n2 == 8) {
            n2 = 1;
        }
        this.a = n2;
    }

    private final boolean d() {
        return (this.b & 3) != 0;
    }

    public final void setSize(float f2) {
        if (this.d()) {
            ((IlvScale)this).a.width = f2;
        } else {
            ((IlvScale)this).a.height = f2;
        }
    }

    public final float getSize() {
        return this.d() ? ((IlvScale)this).a.width : ((IlvScale)this).a.height;
    }

    public final boolean getLabelsCentered() {
        return this.e;
    }

    public final void setLabelsCentered(boolean bl) {
        this.e = bl;
    }

    public IlvRect getDefinitionRect() {
        return new IlvRect(((IlvScale)this).a);
    }

    public void setDefinitionRect(IlvRect ilvRect) {
        float f2;
        IlvPoint ilvPoint = new IlvPoint(ilvRect.x, ilvRect.y);
        float f3 = Math.max(this.getStepSize(), this.getSubStepSize());
        if (this.d()) {
            f2 = ilvRect.width;
            if (this.b == 2) {
                ilvPoint.x += f2;
            }
            if (this.a == 4) {
                ilvPoint.y += f3;
            }
        } else {
            f2 = ilvRect.height;
            if (this.b == 8) {
                ilvPoint.y += f2;
            }
            if (this.a == 1) {
                ilvPoint.x += f3;
            }
        }
        this.a(ilvPoint, f2);
    }

    public IlvTransformer getDefinitionTransformer() {
        return null;
    }

    public final IlvPoint getOrigin() {
        IlvPoint ilvPoint = new IlvPoint();
        this.a(ilvPoint);
        return ilvPoint;
    }

    public final void setOrigin(IlvPoint ilvPoint) {
        IlvPoint ilvPoint2 = new IlvPoint();
        float f2 = this.a(ilvPoint2);
        this.a(ilvPoint, f2);
    }

    private void a(IlvPoint ilvPoint, float f2) {
        if (f2 < 1.0E-20f) {
            f2 = 1.0E-20f;
        }
        ((IlvScale)this).a.move(ilvPoint.x, ilvPoint.y);
        float f3 = Math.max(this.getStepSize(), this.getSubStepSize());
        if (this.d()) {
            ((IlvScale)this).a.resize(f2, f3);
            if (this.b == 2) {
                ((IlvScale)this).a.translate(-f2, 0.0f);
            }
            if (this.a == 4) {
                ((IlvScale)this).a.translate(0.0f, -f3);
            }
        } else {
            ((IlvScale)this).a.resize(f3, f2);
            if (this.b == 8) {
                ((IlvScale)this).a.translate(0.0f, -f2);
            }
            if (this.a == 1) {
                ((IlvScale)this).a.translate(-f3, 0.0f);
            }
        }
    }

    private float a(IlvPoint ilvPoint) {
        float f2;
        float f3 = Math.max(this.getStepSize(), this.getSubStepSize());
        ilvPoint.x = ((IlvScale)this).a.x;
        ilvPoint.y = ((IlvScale)this).a.y;
        if (this.d()) {
            f2 = ((IlvScale)this).a.width;
            if (this.b == 2) {
                ilvPoint.x += f2;
            }
            if (this.a == 4) {
                ilvPoint.y += f3;
            }
        } else {
            f2 = ((IlvScale)this).a.height;
            if (this.b == 8) {
                ilvPoint.y += f2;
            }
            if (this.a == 1) {
                ilvPoint.x += f3;
            }
        }
        return f2;
    }

    private void a(Graphics graphics, IlvTransformer ilvTransformer) {
        float f2;
        IlvPoint ilvPoint = new IlvPoint();
        float f3 = this.a(ilvPoint);
        int n2 = this.getNumberOfSteps() - 1;
        float f4 = f2 = n2 != 0 ? f3 / (float)n2 : f3;
        if ((this.b & 0xA) != 0) {
            f2 *= -1.0f;
        }
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (this.d()) {
            f5 = this.d ? f2 * (float)n2 : f2 * (float)n2;
        } else {
            f6 = this.d ? f2 * (float)n2 : f2 * (float)n2;
        }
        IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
        IlvPoint ilvPoint3 = new IlvPoint(ilvPoint);
        ilvPoint3.translate(f5, f6);
        if (ilvTransformer != null) {
            ilvTransformer.applyFloor(ilvPoint2);
            ilvTransformer.applyFloor(ilvPoint3);
        } else {
            ilvPoint2.floor();
            ilvPoint3.floor();
        }
        graphics.drawLine((int)ilvPoint2.x, (int)ilvPoint2.y, (int)ilvPoint3.x, (int)ilvPoint3.y);
    }

    private int e() {
        return this.c;
    }

    private boolean a(Graphics graphics, IlvPoint ilvPoint) {
        return true;
    }

    private IlvRect b(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvRect ilvRect = new IlvRect(((IlvScale)this).a);
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvRect);
        }
        IlvPoint ilvPoint3 = new IlvPoint();
        float f2 = this.a(ilvPoint3);
        IlvPoint ilvPoint4 = new IlvPoint(ilvPoint3);
        IlvPoint ilvPoint5 = new IlvPoint(ilvPoint3);
        int n2 = this.getNumberOfSteps() - 1;
        this.c = this.e();
        for (int i2 = 0; i2 <= n2; i2 += this.c) {
            ilvPoint5.move(ilvPoint4.x, ilvPoint4.y);
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvPoint5);
            }
            ilvRect.add(ilvPoint5.x, ilvPoint5.y);
            ilvPoint5.move(ilvPoint4.x, ilvPoint4.y);
            ilvPoint5.translate(ilvPoint2.x, ilvPoint2.y);
            if (ilvTransformer != null) {
                ilvTransformer.apply(ilvPoint5);
            }
            ilvRect.add(ilvPoint5.x, ilvPoint5.y);
            ilvPoint4.translate(this.d ? ilvPoint.x : ilvPoint.x, this.d ? ilvPoint.y : ilvPoint.y);
        }
        return ilvRect;
    }

    private void a(IlvRect ilvRect, int n2, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint4 = new IlvPoint(ilvPoint.x + (float)n2 * (this.d ? ilvPoint2.x : ilvPoint2.x), ilvPoint.y + (float)n2 * (this.d ? ilvPoint2.y : ilvPoint2.y));
        IlvPoint ilvPoint5 = new IlvPoint(ilvPoint4);
        ilvPoint5.translate(ilvPoint3.x, ilvPoint3.y);
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvPoint5);
        }
        if (this.getLabels()[n2] == null) {
            ilvRect.reshape(ilvPoint5.x, ilvPoint5.y, 1.0E-20f, 1.0E-20f);
        }
        float f2 = this.a(n2);
        float f3 = this.b(n2);
        float f4 = this.c(n2);
        int n3 = (this.a & 5) != 0 ? -1 : 1;
        ilvRect.move(ilvPoint5.x, ilvPoint5.y);
        ilvRect.resize(f2, f3);
        if (!this.d()) {
            ilvRect.translate(n3 == 1 ? 2.0f : -(f2 + 2.0f), -f3 / 2.0f);
        } else {
            ilvRect.translate(-f2 / 2.0f, n3 == 1 ? 2.0f : -(f3 + 2.0f));
        }
    }

    IlvRect a(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        IlvRect ilvRect = null;
        String[] stringArray = this.getLabels();
        if (stringArray != null) {
            IlvPoint ilvPoint3 = new IlvPoint();
            float f2 = this.a(ilvPoint3);
            int n2 = this.getNumberOfSteps() - 1;
            if (this.e) {
                float f3;
                if (n2 == 0) {
                    return new IlvRect();
                }
                float f4 = f3 = n2 != 0 ? f2 / (float)n2 : f2;
                if ((this.b & 0xA) != 0) {
                    f3 *= -1.0f;
                }
                if (this.d()) {
                    ilvPoint3.translate(f3 / 2.0f, 0.0f);
                } else {
                    ilvPoint3.translate(0.0f, f3 / 2.0f);
                }
                --n2;
            }
            IlvRect ilvRect2 = new IlvRect();
            this.c = this.e();
            for (int i2 = 0; i2 <= n2; i2 += this.c) {
                this.a(ilvRect2, i2, ilvPoint3, ilvPoint, ilvPoint2, ilvTransformer);
                if (i2 == 0) {
                    ilvRect = new IlvRect(ilvRect2);
                    continue;
                }
                ilvRect.add(ilvRect2);
            }
        }
        return ilvRect;
    }

    public boolean zoomable() {
        return false;
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        float f2;
        IlvRect ilvRect = new IlvRect(((IlvScale)this).a);
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvRect);
        }
        if (this.getNumberOfSteps() < 2) {
            return ilvRect;
        }
        int n2 = this.getNumberOfSteps() - 1;
        IlvPoint ilvPoint = new IlvPoint();
        float f3 = this.a(ilvPoint);
        float f4 = f2 = n2 != 0 ? f3 / (float)n2 : f3;
        if ((this.b & 0xA) != 0) {
            f2 *= -1.0f;
        }
        IlvPoint ilvPoint2 = new IlvPoint();
        if (this.d()) {
            ilvPoint2.x = f2;
        } else {
            ilvPoint2.y = f2;
        }
        int n3 = (this.a & 5) != 0 ? -1 : 1;
        IlvPoint ilvPoint3 = new IlvPoint();
        float f5 = Math.max(this.getStepSize(), this.getSubStepSize());
        if (this.d()) {
            ilvPoint3.y = (float)n3 * f5;
        } else {
            ilvPoint3.x = (float)n3 * f5;
        }
        IlvRect ilvRect2 = this.b(ilvPoint2, ilvPoint3, ilvTransformer);
        ilvRect.add(ilvRect2);
        IlvRect ilvRect3 = this.a(ilvPoint2, ilvPoint3, ilvTransformer);
        ilvRect.add(ilvRect3);
        return ilvRect;
    }

    private void a(Graphics graphics, int n2, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvPoint ilvPoint4, IlvPoint ilvPoint5, IlvTransformer ilvTransformer) {
        float f2 = ilvPoint.x + (float)n2 * (this.d ? ilvPoint2.x : ilvPoint2.x);
        float f3 = ilvPoint.y + (float)n2 * (this.d ? ilvPoint2.y : ilvPoint2.y);
        IlvPoint ilvPoint6 = new IlvPoint(f2, f3);
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvPoint6);
        }
        IlvPoint ilvPoint7 = new IlvPoint(ilvPoint6);
        ilvPoint7.translate(ilvPoint4.x, ilvPoint4.y);
        if (this.a(graphics, ilvPoint7)) {
            ilvPoint6.floor();
            ilvPoint7.floor();
            graphics.drawLine((int)ilvPoint6.x, (int)ilvPoint6.y, (int)ilvPoint7.x, (int)ilvPoint7.y);
        }
        if (n2 != this.getNumberOfSteps() - 1 && this.c <= 1) {
            float f4 = f2 + ilvPoint3.x;
            float f5 = f3 + ilvPoint3.y;
            for (int i2 = 1; i2 < this.getNumberOfSubSteps(); ++i2) {
                ilvPoint6.move(f4, f5);
                if (ilvTransformer != null) {
                    ilvTransformer.apply(ilvPoint6);
                }
                ilvPoint7.x = ilvPoint6.x;
                ilvPoint7.y = ilvPoint6.y;
                ilvPoint7.translate(ilvPoint5.x, ilvPoint5.y);
                if (this.a(graphics, ilvPoint7)) {
                    ilvPoint6.floor();
                    ilvPoint7.floor();
                    graphics.drawLine((int)ilvPoint6.x, (int)ilvPoint6.y, (int)ilvPoint7.x, (int)ilvPoint7.y);
                }
                f4 += ilvPoint3.x;
                f5 += ilvPoint3.y;
            }
        }
    }

    private void b(Graphics graphics, IlvTransformer ilvTransformer) {
        float f2;
        IlvPoint ilvPoint = new IlvPoint();
        float f3 = this.a(ilvPoint);
        int n2 = this.getNumberOfSteps() - 1;
        float f4 = n2 != 0 ? f3 / (float)n2 : f3;
        float f5 = f2 = n2 != 0 && this.getNumberOfSubSteps() > 1 ? f4 / (float)this.getNumberOfSubSteps() : 0.0f;
        if ((this.b & 0xA) != 0) {
            f4 *= -1.0f;
            f2 *= -1.0f;
        }
        IlvPoint ilvPoint2 = new IlvPoint();
        IlvPoint ilvPoint3 = new IlvPoint();
        if (this.d()) {
            ilvPoint2.x = f4;
            ilvPoint2.y = 0.0f;
            ilvPoint3.x = f2;
            ilvPoint3.y = 0.0f;
        } else {
            ilvPoint2.x = 0.0f;
            ilvPoint2.y = f4;
            ilvPoint3.x = 0.0f;
            ilvPoint3.y = f2;
        }
        int n3 = (this.a & 5) != 0 ? -1 : 1;
        IlvPoint ilvPoint4 = new IlvPoint();
        IlvPoint ilvPoint5 = new IlvPoint();
        if (this.d()) {
            ilvPoint4.move(0.0f, (float)n3 * this.getStepSize());
            ilvPoint5.move(0.0f, (float)n3 * this.getSubStepSize());
        } else {
            ilvPoint4.move((float)n3 * this.getStepSize(), 0.0f);
            ilvPoint5.move((float)n3 * this.getSubStepSize(), 0.0f);
        }
        this.c = this.e();
        for (int i2 = 0; i2 <= n2; i2 += this.c) {
            this.a(graphics, i2, ilvPoint, ilvPoint2, ilvPoint3, ilvPoint4, ilvPoint5, ilvTransformer);
        }
    }

    private void c(Graphics graphics, IlvTransformer ilvTransformer) {
        float f2;
        if (this.getLabels() == null) {
            return;
        }
        boolean bl = this.getLabelsCentered();
        IlvPoint ilvPoint = new IlvPoint();
        float f3 = this.a(ilvPoint);
        int n2 = this.getNumberOfSteps() - 1;
        float f4 = f2 = n2 != 0 ? f3 / (float)n2 : f3;
        if ((this.b & 0xA) != 0) {
            f2 *= -1.0f;
        }
        IlvPoint ilvPoint2 = new IlvPoint();
        if (this.d()) {
            ilvPoint2.move(f2, 0.0f);
            if (bl) {
                ilvPoint.translate(f2 / 2.0f, 0.0f);
            }
        } else {
            ilvPoint2.move(0.0f, f2);
            if (bl) {
                ilvPoint.translate(0.0f, f2 / 2.0f);
            }
        }
        int n3 = (this.a & 5) != 0 ? -1 : 1;
        IlvPoint ilvPoint3 = new IlvPoint();
        if (this.d()) {
            ilvPoint3.move(0.0f, (float)n3 * this.getStepSize());
        } else {
            ilvPoint3.move((float)n3 * this.getStepSize(), 0.0f);
        }
        if (bl) {
            if (n2 == 0) {
                return;
            }
            --n2;
        }
        this.c = this.e();
        boolean bl2 = this.isAntialiasing();
        for (int i2 = 0; i2 <= n2; i2 += this.c) {
            this.a(graphics, i2, ilvPoint, ilvPoint2, ilvPoint3, ilvTransformer, bl2);
        }
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        if (this.getNumberOfSteps() < 1) {
            return;
        }
        graphics.setColor(this.getForeground());
        this.a(graphics, ilvTransformer);
        if (this.getNumberOfSteps() > 1) {
            this.b(graphics, ilvTransformer);
            this.c(graphics, ilvTransformer);
        }
    }

    private void a(Graphics graphics, int n2, IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvPoint ilvPoint3, IlvTransformer ilvTransformer, boolean bl) {
        int n3;
        String[] stringArray = this.getLabels();
        if (stringArray == null || stringArray[n2] == null) {
            return;
        }
        IlvPoint ilvPoint4 = new IlvPoint(ilvPoint.x + (float)n2 * (this.d ? ilvPoint2.x : ilvPoint2.x), ilvPoint.y + (float)n2 * (this.d ? ilvPoint2.y : ilvPoint2.y));
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvPoint4);
        }
        IlvPoint ilvPoint5 = new IlvPoint(ilvPoint4);
        ilvPoint5.translate(ilvPoint3.x, ilvPoint3.y);
        int n4 = n3 = (this.a & 5) != 0 ? -1 : 1;
        if (this.a(graphics, ilvPoint5)) {
            float f2 = this.a(n2);
            float f3 = this.b(n2);
            if ((this.b & 0xC) != 0) {
                ilvPoint5.translate(n3 == 1 ? 2.0f : -(f2 + 2.0f), f3 / 2.0f);
            } else {
                ilvPoint5.translate(-f2 / 2.0f, n3 == 1 ? f3 + 2.0f : -2.0f);
            }
            if (this.a(graphics, ilvPoint5)) {
                ilvPoint5.floor();
                graphics.setFont(this.getFont());
                IlvGraphicUtil.DrawString(graphics, stringArray[n2], (int)ilvPoint5.x, (int)ilvPoint5.y, bl);
            }
        }
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        IlvPoint ilvPoint = new IlvPoint();
        this.a(ilvPoint);
        IlvRect ilvRect = new IlvRect(((IlvScale)this).a);
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvRect);
            ilvTransformer.apply(ilvPoint);
        }
        float f2 = this.d() ? ilvRect.width : ilvRect.height;
        this.a(ilvPoint, f2);
    }

    public void moveResize(IlvRect ilvRect) {
        super.moveResize(ilvRect);
        IlvUtility.correctMoveResizeNonzoomableGraphic(this, ilvRect, this.d(), !this.d());
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("originPosition", this.b);
        ilvOutputStream.write("labelsPosition", this.a);
        ilvOutputStream.write("labelsCentered", this.e);
    }
}

