/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphicUtil;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.IlvUtil;
import ilog.views.internal.IlvUtility;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvPersistentObject;
import ilog.views.io.IlvReadFileException;
import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;
import java.io.Serializable;

public class IlvPointArray
implements Serializable,
IlvPersistentObject {
    private IlvPoint[] a;
    private boolean b;
    private final IlvRect c = new IlvRect();
    static Boolean d = new Boolean(true);
    static IlvPoint[] e = null;

    public IlvPointArray() {
        this(null, false);
    }

    public IlvPointArray(IlvPoint[] ilvPointArray, boolean bl) {
        this.setPoints(ilvPointArray, bl);
    }

    public IlvPointArray(IlvInputStream ilvInputStream) throws IlvReadFileException {
        this.setPoints(ilvInputStream.readPointArray("points"), false);
    }

    public IlvPointArray(IlvPointArray ilvPointArray) {
        this.setPoints(ilvPointArray.getPoints(), true);
    }

    public int getNumberOfPoints() {
        return this.a != null ? this.a.length : 0;
    }

    public IlvPoint[] getPoints() {
        return this.a;
    }

    public IlvPoint getPoint(int n2) {
        return this.a[n2];
    }

    public void movePoint(int n2, float f2, float f3) {
        this.a[n2].move(f2, f3);
        this.b = false;
    }

    public void addPoints(IlvPoint[] ilvPointArray, int n2) {
        if (ilvPointArray == null) {
            throw new IllegalArgumentException("pts is null");
        }
        int n3 = this.a.length;
        if (n2 > n3) {
            n2 = n3;
        }
        IlvPoint[] ilvPointArray2 = this.a;
        this.a = new IlvPoint[n3 + ilvPointArray.length];
        if (n2 != 0) {
            System.arraycopy(ilvPointArray2, 0, this.a, 0, n2);
        }
        System.arraycopy(ilvPointArray, 0, this.a, n2, ilvPointArray.length);
        if (n2 < n3) {
            System.arraycopy(ilvPointArray2, n2, this.a, n2 + ilvPointArray.length, n3 - n2);
        }
        this.b = false;
    }

    public void removePoints(int n2, int n3) {
        if (n3 == 0 || n2 == 0 && n3 >= this.getNumberOfPoints() || n2 != 0 && n3 + n2 > this.getNumberOfPoints()) {
            throw new IllegalArgumentException("bad parameters");
        }
        IlvPoint[] ilvPointArray = this.a;
        int n4 = this.getNumberOfPoints();
        this.a = new IlvPoint[n4 - n3];
        if (n2 != 0) {
            System.arraycopy(ilvPointArray, 0, this.a, 0, n2);
        }
        if (n2 + n3 < n4) {
            System.arraycopy(ilvPointArray, n2 + n3, this.a, n2, n4 - n2 - n3);
        }
        this.b = false;
    }

    public void boundingBox(IlvRect ilvRect, IlvTransformer ilvTransformer) {
        this.a(ilvRect);
        if (ilvTransformer != null) {
            ilvTransformer.boundingBox(ilvRect, false);
        }
        if (ilvRect.width < 1.0E-20f) {
            ilvRect.width = 1.0E-20f;
        }
        if (ilvRect.height < 1.0E-20f) {
            ilvRect.height = 1.0E-20f;
        }
    }

    public void setPoints(IlvPoint[] ilvPointArray, boolean bl) {
        if (ilvPointArray == null) {
            this.a = null;
        } else if (bl) {
            int n2 = ilvPointArray.length;
            this.a = new IlvPoint[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.a[i2] = new IlvPoint(ilvPointArray[i2].x, ilvPointArray[i2].y);
            }
        } else {
            this.a = ilvPointArray;
        }
        this.b = false;
    }

    public boolean outlineContains(IlvPoint ilvPoint) {
        if (this.a == null) {
            return false;
        }
        switch (this.a.length) {
            case 0: {
                return false;
            }
            case 1: {
                return ilvPoint.x == this.a[0].x && ilvPoint.y == this.a[0].y;
            }
        }
        IlvRect ilvRect = new IlvRect();
        this.a(ilvRect);
        ilvRect.expand(IlvUtil.GetDeltaLine());
        if (!ilvRect.inside(ilvPoint.x, ilvPoint.y)) {
            return false;
        }
        for (int i2 = 1; i2 < this.a.length; ++i2) {
            if (!IlvUtil.PointInLine(ilvPoint, this.a[i2 - 1], this.a[i2])) continue;
            return true;
        }
        return this.a.length > 2 && IlvUtil.PointInLine(ilvPoint, this.a[this.a.length - 1], this.a[0]);
    }

    public int nbHorizontalIntersection(IlvPoint ilvPoint) {
        if (this.a == null || this.a.length <= 1) {
            return 0;
        }
        int n2 = 0;
        for (int i2 = 1; i2 < this.a.length; ++i2) {
            if (!IlvUtility.IntersectHorizontal(ilvPoint, this.a[i2 - 1], this.a[i2])) continue;
            ++n2;
        }
        if (this.a.length == 2) {
            return n2 * 2;
        }
        if (IlvUtility.IntersectHorizontal(ilvPoint, this.a[this.a.length - 1], this.a[0])) {
            ++n2;
        }
        return n2;
    }

    private void a(IlvRect ilvRect) {
        if (!this.b) {
            if (this.a != null) {
                IlvUtil.BoundingBox(this.c, this.a, this.a.length);
            } else {
                this.c.reshape(0.0f, 0.0f, 0.0f, 0.0f);
            }
            this.b = true;
        }
        ilvRect.reshape(this.c.x, this.c.y, this.c.width, this.c.height);
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        if (this.a != null) {
            int n2 = this.a.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                ilvTransformer.apply(this.a[i2]);
            }
            this.b = false;
        }
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        ilvOutputStream.write("points", this.a);
    }

    public static void FillPaths(Graphics graphics, Color color, IlvPointArray[] ilvPointArrayArray) {
        int n2;
        int n3 = ilvPointArrayArray.length;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n4 += ilvPointArrayArray[n2].getNumberOfPoints();
        }
        if (n4 == 0) {
            return;
        }
        IlvPoint ilvPoint = ilvPointArrayArray[0].getPoint(0);
        IlvPoint[] ilvPointArray = IlvPointArray.a(n4 += 2 * n3 - 1);
        ilvPointArray[0].move(ilvPoint.x, ilvPoint.y);
        int n5 = 1;
        for (n2 = 0; n2 < n3; ++n2) {
            IlvPoint ilvPoint2;
            IlvPointArray ilvPointArray2 = ilvPointArrayArray[n2];
            for (int i2 = 0; i2 < ilvPointArray2.getNumberOfPoints(); ++i2) {
                ilvPoint2 = ilvPointArray2.getPoint(i2);
                if (ilvPoint2.x == ilvPointArray[n5 - 1].x && ilvPoint2.y == ilvPointArray[n5 - 1].y) continue;
                ilvPointArray[n5].move(ilvPoint2.x, ilvPoint2.y);
                ++n5;
            }
            IlvPoint ilvPoint3 = ilvPointArray2.getPoint(0);
            ilvPoint2 = ilvPointArray2.getPoint(ilvPointArray2.getNumberOfPoints() - 1);
            if (!(ilvPoint3.x == ilvPoint2.x && ilvPoint3.y == ilvPoint2.y || ilvPoint3.x == ilvPointArray[n5 - 1].x && ilvPoint3.y == ilvPointArray[n5 - 1].y)) {
                ilvPointArray[n5].move(ilvPoint3.x, ilvPoint3.y);
                ++n5;
            }
            if (n2 == 0 || ilvPoint.x == ilvPointArray[n5 - 1].x && ilvPoint.y == ilvPointArray[n5 - 1].y) continue;
            ilvPointArray[n5].move(ilvPoint.x, ilvPoint.y);
            ++n5;
        }
        if (n5 < 3) {
            return;
        }
        IlvPointArray.a(graphics, color, n5 - 1, ilvPointArray, true);
    }

    private static void a(Graphics graphics, Color color, int n2, IlvPoint[] ilvPointArray, boolean bl) {
        graphics.setColor(color);
        if (bl) {
            IlvGraphicUtil.FillPolygon(graphics, ilvPointArray, n2, null);
        } else {
            IlvGraphicUtil.DrawPolyline(graphics, ilvPointArray, n2, 0.0f, 1, 0, null, null);
        }
    }

    public static void DrawPaths(Graphics graphics, Color color, IlvPointArray[] ilvPointArrayArray) {
        int n2 = ilvPointArrayArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvPointArray.a(graphics, color, ilvPointArrayArray[i2].getNumberOfPoints(), ilvPointArrayArray[i2].getPoints(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final IlvPoint[] a(int n2) {
        Boolean bl = d;
        synchronized (bl) {
            int n3;
            if (e != null && e.length >= n2) {
                return e;
            }
            IlvPoint[] ilvPointArray = e;
            e = new IlvPoint[n2];
            if (ilvPointArray != null) {
                System.arraycopy(ilvPointArray, 0, e, 0, ilvPointArray.length);
            }
            int n4 = n3 = ilvPointArray == null ? 0 : ilvPointArray.length;
            while (n3 < n2) {
                IlvPointArray.e[n3] = new IlvPoint();
                ++n3;
            }
            return e;
        }
    }
}

