/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphic;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvManagerView;
import ilog.views.IlvObjectInteractor;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvSelection;
import ilog.views.IlvTransformer;
import ilog.views.graphic.IlvFixedSizeGraphic;
import ilog.views.graphic.IlvGraphicHandleInteractor;
import ilog.views.graphic.IlvGraphicHandleSelection;
import ilog.views.internal.IlvDrawWithBufferedImage;
import ilog.views.internal.impl.IlvUtility2D;
import ilog.views.io.IlvFieldNotFoundException;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvClippingUtil;
import ilog.views.swing.IlvPopupMenuManager;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import javax.swing.JPopupMenu;

public class IlvHalfZoomingGraphic
extends IlvFixedSizeGraphic {
    private double a;
    private double b;
    private double c;
    private Color d;
    private Color e;
    private boolean f = true;
    private float g = 1.0f;
    private boolean h = true;
    private boolean i = true;
    public static final IlvObjectInteractor DELEGATE_INTERACTOR = new DelegateObjectInteractor();
    private IlvTransformer[] j = new IlvTransformer[3];
    private IlvTransformer[] k = new IlvTransformer[3];

    public IlvHalfZoomingGraphic(IlvGraphic ilvGraphic, int n2, IlvPoint ilvPoint, double d2, double d3, double d4) {
        super(ilvGraphic, n2, ilvPoint);
        this.a = d2;
        this.b = d3;
        this.c = d4;
        this.d = Color.black;
        this.e = Color.gray;
        this.setObjectInteractor(DELEGATE_INTERACTOR);
    }

    public IlvHalfZoomingGraphic(IlvGraphic ilvGraphic, IlvPoint ilvPoint, double d2, double d3, double d4) {
        this(ilvGraphic, 0, ilvPoint, d2, d3, d4);
    }

    public IlvHalfZoomingGraphic(IlvGraphic ilvGraphic, int n2, double d2, double d3, double d4) {
        this(ilvGraphic, n2, null, d2, d3, d4);
    }

    public IlvHalfZoomingGraphic(IlvHalfZoomingGraphic ilvHalfZoomingGraphic) {
        super(ilvHalfZoomingGraphic);
        this.a = ilvHalfZoomingGraphic.a;
        this.b = ilvHalfZoomingGraphic.b;
        this.c = ilvHalfZoomingGraphic.c;
        this.setUnzoomedForeground(ilvHalfZoomingGraphic.d);
        this.setUnzoomedBackground(ilvHalfZoomingGraphic.e);
        this.f = ilvHalfZoomingGraphic.f;
        this.g = ilvHalfZoomingGraphic.g;
        this.h = ilvHalfZoomingGraphic.h;
        this.i = ilvHalfZoomingGraphic.i;
        this.setObjectInteractor(DELEGATE_INTERACTOR);
    }

    public IlvGraphic copy() {
        return new IlvHalfZoomingGraphic(this);
    }

    public IlvHalfZoomingGraphic(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.a = ilvInputStream.readDouble("minZoom");
        this.b = ilvInputStream.readDouble("maxZoom");
        this.c = ilvInputStream.readDouble("initialZoom");
        this.setUnzoomedForeground(ilvInputStream.readColor("foreground"));
        this.setUnzoomedBackground(ilvInputStream.readColor("background"));
        try {
            this.f = ilvInputStream.readBoolean("grayedWhenUnzoomed");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.g = ilvInputStream.readFloat("alpha");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.h = ilvInputStream.readBoolean("useAlphaBuffer");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
        try {
            this.i = ilvInputStream.readBoolean("rotatable");
        }
        catch (IlvFieldNotFoundException ilvFieldNotFoundException) {
            // empty catch block
        }
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("minZoom", this.a);
        ilvOutputStream.write("maxZoom", this.b);
        ilvOutputStream.write("initialZoom", this.c);
        ilvOutputStream.write("foreground", this.d);
        ilvOutputStream.write("background", this.e);
        ilvOutputStream.write("grayedWhenUnzoomed", this.f);
        ilvOutputStream.write("alpha", this.g);
        ilvOutputStream.write("useAlphaBuffer", this.h);
        ilvOutputStream.write("rotatable", this.i);
    }

    public void setGraphicBag(IlvGraphicBag ilvGraphicBag) {
        super.setGraphicBag(ilvGraphicBag);
        ((DelegateObjectInteractor)DELEGATE_INTERACTOR).b();
    }

    public final void setPosition(int n2) {
        super.setPosition(n2);
        this.d();
    }

    public final void setPoint(IlvPoint ilvPoint) {
        super.setPoint(ilvPoint);
        this.d();
    }

    public double getMinZoom() {
        return this.a;
    }

    public void setMinZoom(double d2) {
        this.a = d2;
    }

    public double getMaxZoom() {
        return this.b;
    }

    public void setMaxZoom(double d2) {
        this.b = d2;
    }

    public double getInitialZoom() {
        return this.c;
    }

    public void setInitialZoom(double d2) {
        if (d2 == 0.0) {
            d2 = 1.0;
        }
        this.c = d2;
    }

    public void setUnzoomedForeground(Color color) {
        Color color2 = this.d;
        this.d = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getUnzoomedForeground() {
        return this.d;
    }

    public void setUnzoomedBackground(Color color) {
        Color color2 = this.e;
        this.e = color;
        this.registerBlinkingResource(color2, color);
    }

    public Color getUnzoomedBackground() {
        return this.e;
    }

    public void setGrayedWhenUnzoomed(boolean bl) {
        this.f = bl;
    }

    public boolean isGrayedWhenUnzoomed() {
        return this.f;
    }

    public void setRotatable(boolean bl) {
        if (bl != this.i) {
            this.i = bl;
            this.d();
        }
    }

    public boolean isRotatable() {
        return this.i;
    }

    public void setAlpha(float f2) {
        if (f2 > 1.0f || f2 < 0.0f) {
            throw new IllegalArgumentException("alpha must be in the range [0.0,1.0]");
        }
        this.g = f2;
    }

    public float getAlpha() {
        return this.g;
    }

    public void setAlphaBufferEnabled(boolean bl) {
        this.h = bl;
        if (!bl) {
            IlvDrawWithBufferedImage.clearCache();
        }
    }

    public boolean isAlphaBufferEnabled() {
        return this.h;
    }

    public boolean isDelegateObjectInteractor(IlvObjectInteractor ilvObjectInteractor) {
        return ilvObjectInteractor == DELEGATE_INTERACTOR;
    }

    protected void notifyObjectInteractorToManager(IlvObjectInteractor ilvObjectInteractor) {
        ((DelegateObjectInteractor)DELEGATE_INTERACTOR).b();
        super.notifyObjectInteractorToManager(ilvObjectInteractor);
    }

    public IlvTransformer computeTransformer(IlvTransformer ilvTransformer) {
        int n2;
        for (n2 = 0; n2 < this.j.length; ++n2) {
            IlvTransformer ilvTransformer2;
            IlvTransformer ilvTransformer3 = this.k[n2];
            if (ilvTransformer3 == null || (ilvTransformer2 = this.j[n2]) == null || (ilvTransformer != null || !ilvTransformer2.isIdentity()) && !ilvTransformer2.equals(ilvTransformer)) continue;
            return this.k[n2];
        }
        double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
        IlvPoint ilvPoint = this.getPoint();
        IlvPoint ilvPoint2 = new IlvPoint(ilvPoint);
        double d3 = 0.0;
        if (ilvTransformer != null) {
            ilvTransformer.apply(ilvPoint2);
            if (this.i && ilvTransformer.getx21() != 0.0) {
                d3 = Math.atan2(ilvTransformer.getx21(), ilvTransformer.getx11());
            }
        }
        IlvTransformer ilvTransformer4 = new IlvTransformer();
        ilvTransformer4.setValues(1.0, 0.0, 0.0, 1.0, (double)ilvPoint2.x - (double)ilvPoint.x, (double)ilvPoint2.y - (double)ilvPoint.y);
        if (this.i && d3 != 0.0) {
            ilvTransformer4.rotate(ilvPoint2.x, ilvPoint2.y, Math.toDegrees(d3));
        }
        if (d2 < this.a * this.e()) {
            if (!this.f) {
                d2 = this.a;
            }
        } else {
            d2 = d2 > this.b * this.e() ? this.b : (d2 /= this.e());
        }
        ilvTransformer4.scale(ilvPoint.x, ilvPoint.y, d2, d2);
        int n3 = 0;
        for (n2 = 0; n2 < this.j.length; ++n2) {
            if (this.j[n2] != null) continue;
            n3 = n2;
            break;
        }
        this.k[n3] = ilvTransformer4;
        this.j[n3] = new IlvTransformer(ilvTransformer);
        return ilvTransformer4;
    }

    private void d() {
        this.j = new IlvTransformer[3];
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
        float f2 = this.getAlpha();
        boolean bl = false;
        Composite composite = null;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (f2 != 1.0f) {
            composite = graphics2D.getComposite();
            if (composite instanceof AlphaComposite && composite != AlphaComposite.Xor) {
                bl = true;
            }
            if (bl) {
                IlvUtility2D.SetAlphaComposite(graphics, f2);
            }
        }
        if (bl && this.isAlphaBufferEnabled()) {
            this.g = 1.0f;
            IlvDrawWithBufferedImage.drawWithBufferedImage(this, graphics2D, ilvTransformer);
            this.g = f2;
        } else {
            this.a(graphics2D, ilvTransformer);
        }
        if (bl && f2 != 1.0f) {
            graphics2D.setComposite(composite);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void a(Graphics2D graphics2D, IlvTransformer ilvTransformer) {
        if (this.f) {
            double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (d2 < this.a * this.e()) {
                IlvRect ilvRect = this.boundingBox(ilvTransformer);
                graphics2D.setColor(this.e);
                graphics2D.fillRect((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height);
                graphics2D.setColor(this.d);
                graphics2D.drawRect((int)ilvRect.x, (int)ilvRect.y, (int)ilvRect.width, (int)ilvRect.height);
                return;
            }
        }
        this.getObject().callDraw(graphics2D, this.computeTransformer(ilvTransformer));
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        if (this.f) {
            double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (d2 < this.a * this.e()) {
                IlvRect ilvRect = this.unzoomedBBox();
                if (ilvTransformer != null) {
                    ilvTransformer.apply(ilvRect);
                }
                return ilvRect;
            }
        }
        return this.getObject().boundingBox(this.computeTransformer(ilvTransformer));
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
        super.applyTransform(ilvTransformer);
        for (int i2 = 0; i2 < this.j.length; ++i2) {
            this.k[i2] = null;
        }
    }

    protected IlvRect unzoomedBBox() {
        return this.boundingBox(null);
    }

    protected double getReferenceZoom() {
        return 1.0;
    }

    private double e() {
        if (this.c == 0.0) {
            return 1.0;
        }
        return this.getReferenceZoom() / this.c;
    }

    public boolean zoomable() {
        IlvPoint ilvPoint = this.getPoint();
        IlvRect ilvRect = this.getObject().boundingBox(null);
        if (ilvPoint.x < ilvRect.x || ilvPoint.y < ilvRect.y || ilvPoint.x > ilvRect.x + ilvRect.width || ilvPoint.y > ilvRect.y + ilvRect.height) {
            return false;
        }
        return (this.f || this.a == 0.0) && this.b >= this.c && this.getObject().zoomable();
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.f) {
            double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (d2 < this.a * this.e()) {
                return this.boundingBox(ilvTransformer).inside(ilvPoint2.x, ilvPoint2.y);
            }
        }
        IlvTransformer ilvTransformer2 = this.computeTransformer(ilvTransformer);
        IlvPoint ilvPoint3 = new IlvPoint(ilvPoint);
        if (ilvTransformer != null && !ilvTransformer.isIdentity()) {
            ilvTransformer.apply(ilvPoint3);
        }
        if (!ilvTransformer2.isIdentity()) {
            ilvTransformer2.inverse(ilvPoint3);
        }
        return this.getObject().contains(ilvPoint3, ilvPoint2, ilvTransformer2);
    }

    public boolean intersects(IlvRect ilvRect, IlvRect ilvRect2, IlvTransformer ilvTransformer) {
        if (this.f) {
            double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (d2 < this.a * this.e()) {
                return this.boundingBox(ilvTransformer).intersects(ilvRect2);
            }
        }
        IlvTransformer ilvTransformer2 = this.computeTransformer(ilvTransformer);
        IlvRect ilvRect3 = new IlvRect(ilvRect2);
        ilvTransformer2.boundingBox(ilvRect3, true);
        return this.getObject().intersects(ilvRect3, ilvRect2, ilvTransformer2);
    }

    public boolean inside(IlvRect ilvRect, IlvRect ilvRect2, IlvTransformer ilvTransformer) {
        if (this.f) {
            double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (d2 < this.a * this.e()) {
                return ilvRect2.contains(this.boundingBox(ilvTransformer));
            }
        }
        IlvTransformer ilvTransformer2 = this.computeTransformer(ilvTransformer);
        IlvRect ilvRect3 = new IlvRect(ilvRect2);
        ilvTransformer2.boundingBox(ilvRect3, true);
        return this.getObject().inside(ilvRect3, ilvRect2, ilvTransformer2);
    }

    public IlvPoint getIntersectionWithOutline(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        if (this.f) {
            double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (d2 < this.a * this.e()) {
                return IlvClippingUtil.getClippedPoint(this.boundingBox(ilvTransformer), ilvPoint, ilvPoint2);
            }
        }
        IlvTransformer ilvTransformer2 = this.computeTransformer(ilvTransformer);
        return this.getObject().getIntersectionWithOutline(ilvPoint, ilvPoint2, ilvTransformer2);
    }

    public String getToolTipText(IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        if (this.f) {
            double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (d2 < this.a * this.e()) {
                return this.getToolTipText();
            }
        }
        IlvTransformer ilvTransformer2 = this.computeTransformer(ilvTransformer);
        String string = this.getObject().getToolTipText(ilvPoint, ilvTransformer2);
        if (string != null) {
            return string;
        }
        return this.getToolTipText();
    }

    public JPopupMenu getPopupMenu(IlvPoint ilvPoint, IlvTransformer ilvTransformer, IlvManagerView ilvManagerView, IlvPopupMenuManager ilvPopupMenuManager) {
        if (this.f) {
            double d2 = ilvTransformer != null ? ilvTransformer.zoomFactor() : 1.0;
            if (d2 < this.a * this.e()) {
                return super.getPopupMenu(ilvPoint, ilvTransformer, ilvManagerView, ilvPopupMenuManager);
            }
        }
        IlvTransformer ilvTransformer2 = this.computeTransformer(ilvTransformer);
        JPopupMenu jPopupMenu = this.getObject().getPopupMenu(ilvPoint, ilvTransformer2, ilvManagerView, ilvPopupMenuManager);
        if (jPopupMenu != null) {
            return jPopupMenu;
        }
        return this.getOriginalPopupMenu(ilvPoint, ilvTransformer, ilvManagerView, ilvPopupMenuManager);
    }

    public IlvSelection makeSelection() {
        IlvSelection ilvSelection = this.getObject().makeSelection();
        return new IlvGraphicHandleSelection(this, ilvSelection){

            protected IlvTransformer getVirtualViewTransformer(IlvTransformer ilvTransformer) {
                return IlvHalfZoomingGraphic.this.computeTransformer(ilvTransformer);
            }
        };
    }

    static class DelegateObjectInteractor
    extends IlvGraphicHandleInteractor {
        public DelegateObjectInteractor() {
            IlvObjectInteractor.Put(this.getClass().getName(), this);
        }

        protected boolean acceptObject(IlvGraphic ilvGraphic) {
            return ilvGraphic instanceof IlvHalfZoomingGraphic;
        }

        protected IlvTransformer getVirtualViewTransformer(IlvGraphic ilvGraphic, IlvTransformer ilvTransformer) {
            return ((IlvHalfZoomingGraphic)ilvGraphic).computeTransformer(ilvTransformer);
        }

        protected IlvTransformer getVirtualToRealViewTransformer(IlvGraphic ilvGraphic, IlvTransformer ilvTransformer) {
            return null;
        }
    }
}

