/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.beans.editor;

import ilog.views.IlvPoint;
import java.beans.PropertyEditorSupport;
import java.util.StringTokenizer;

public class IlvPointEditor
extends PropertyEditorSupport {
    private String a;
    private boolean b;

    public IlvPointEditor() {
        this("", false);
    }

    public IlvPointEditor(String string, boolean bl) {
        this.a = string;
        this.b = bl;
    }

    public String getJavaInitializationString() {
        IlvPoint ilvPoint = (IlvPoint)this.getValue();
        if (ilvPoint == null) {
            return "null";
        }
        if (ilvPoint.x == 0.0f && ilvPoint.y == 0.0f) {
            return "new ilog.views.IlvPoint()";
        }
        return "new ilog.views.IlvPoint((float)" + ilvPoint.x + "," + "(float)" + ilvPoint.y + ")";
    }

    public Object getValue() {
        Object object = super.getValue();
        if (object == null && !this.b) {
            object = new IlvPoint();
        }
        return object;
    }

    public void setValue(Object object) {
        if (object == null && !this.b) {
            object = new IlvPoint();
        }
        super.setValue(object);
    }

    public String getAsText() {
        IlvPoint ilvPoint = (IlvPoint)this.getValue();
        if (ilvPoint != null) {
            return ilvPoint.x + "," + ilvPoint.y;
        }
        return this.a;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (this.b && this.a.equals(string)) {
            this.setValue(null);
        } else {
            Object object;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            float[] fArray = new float[stringTokenizer.countTokens()];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken().trim();
                try {
                    fArray[n2] = Float.parseFloat((String)object);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("invalid point:" + string);
                }
                ++n2;
            }
            if (fArray.length != 2) {
                throw new IllegalArgumentException("invalid point:" + string);
            }
            object = new IlvPoint(fArray[0], fArray[1]);
            this.setValue(object);
        }
    }

    public static class EmptyNull
    extends IlvPointEditor {
        public EmptyNull() {
            super("", true);
        }
    }

    public static class NoNull
    extends IlvPointEditor {
        public NoNull() {
            super("", false);
        }
    }
}

