/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.settings.internal;

import ilog.views.appframe.settings.IlvMutableSettingsModel;
import ilog.views.appframe.settings.IlvSettings;
import ilog.views.appframe.settings.IlvSettingsElement;
import ilog.views.appframe.settings.IlvSettingsManager;
import ilog.views.appframe.settings.xml.IlvXMLSettings;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class IlvSettingsUtils {
    public static String INDENT = "";
    public static String INDENT_INC = "    ";
    private static List a = new ArrayList();

    public static int CompareDates(IlvSettingsElement ilvSettingsElement, IlvSettingsElement ilvSettingsElement2) {
        long l2;
        if (ilvSettingsElement == null) {
            return ilvSettingsElement2 == null ? 0 : 1;
        }
        if (ilvSettingsElement2 == null) {
            return -1;
        }
        long l3 = IlvSettingsUtils.GetDate(ilvSettingsElement);
        if (l3 < (l2 = IlvSettingsUtils.GetDate(ilvSettingsElement2))) {
            return 1;
        }
        if (l3 > l2) {
            return -1;
        }
        return 0;
    }

    public static long GetDate(IlvSettingsElement ilvSettingsElement) {
        long l2 = 0L;
        int n2 = ilvSettingsElement.getCascadedElementCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            IlvSettings ilvSettings = ilvSettingsElement.getCascadedSettings(i2);
            long l3 = IlvSettingsUtils.GetDate(ilvSettings);
            if (l3 <= l2) continue;
            l2 = l3;
        }
        return l2;
    }

    public static long GetDate(IlvSettings ilvSettings) {
        if (!(ilvSettings instanceof IlvXMLSettings)) {
            return 0L;
        }
        return IlvSettingsUtils.GetDate(((IlvXMLSettings)ilvSettings).getXMLFileURL());
    }

    public static long GetDate(URL uRL) {
        if (uRL == null) {
            return 0L;
        }
        File file = null;
        try {
            file = new File(uRL.getPath());
            return file.lastModified();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static void CopySettings(IlvSettings ilvSettings, IlvSettings ilvSettings2) {
        IlvSettingsElement[] ilvSettingsElementArray = ilvSettings.select((String)null, null);
        if (ilvSettingsElementArray == null) {
            return;
        }
        for (int i2 = 0; i2 < ilvSettingsElementArray.length; ++i2) {
            IlvSettingsUtils.AddNewElement(ilvSettings2, null, ilvSettingsElementArray[i2], -1);
        }
    }

    public static void ApplyModifications(IlvSettings ilvSettings, IlvSettingsManager ilvSettingsManager) {
        IlvSettingsUtils.ApplyModifications(ilvSettings, null, ilvSettingsManager.select((String)null, null));
    }

    public static void ApplyModifications(IlvSettings ilvSettings, IlvSettingsElement ilvSettingsElement, IlvSettingsElement[] ilvSettingsElementArray) {
        int n2;
        IlvSettingsElement[] ilvSettingsElementArray2 = ilvSettingsElement == null ? ilvSettings.select((String)null, null) : ilvSettingsElement.getChildren();
        ArrayList<IlvSettingsElement> arrayList = new ArrayList<IlvSettingsElement>(ilvSettingsElementArray2 == null ? 0 : ilvSettingsElementArray2.length);
        for (n2 = 0; n2 < ilvSettingsElementArray2.length; ++n2) {
            arrayList.add(ilvSettingsElementArray2[n2]);
        }
        for (n2 = 0; n2 < ilvSettingsElementArray.length; ++n2) {
            IlvSettingsElement ilvSettingsElement2;
            IlvSettingsElement ilvSettingsElement3 = ilvSettingsElementArray[n2];
            if (ilvSettingsElement3.getCascadedSettings(0) != ilvSettings) {
                IlvSettingsUtils.AddNewElement(ilvSettings, ilvSettingsElement, ilvSettingsElement3, n2);
                continue;
            }
            while (arrayList.size() != 0 && (ilvSettingsElement2 = (IlvSettingsElement)arrayList.get(0)).getCascadedElement(0) != ilvSettingsElement3.getCascadedElement(0)) {
                ilvSettings.removeSettingsElement(ilvSettingsElement2);
                arrayList.remove(0);
            }
            if (arrayList.size() != 0) {
                if (ilvSettingsElement3.getCascadedElementCount() == 1) continue;
                IlvSettingsUtils.ApplyAttributes(ilvSettingsElement3);
                continue;
            }
            IlvSettingsUtils.AddNewElement(ilvSettings, ilvSettingsElement, ilvSettingsElement3, n2);
        }
        while (arrayList.size() != 0) {
            ilvSettings.removeSettingsElement((IlvSettingsElement)arrayList.get(0));
            arrayList.remove(0);
        }
    }

    public static IlvSettingsElement AddNewElement(IlvSettings ilvSettings, IlvSettingsElement ilvSettingsElement, IlvSettingsElement ilvSettingsElement2, int n2) {
        IlvSettingsElement ilvSettingsElement3 = ilvSettings.createSettingsElement(ilvSettingsElement2.getType());
        String[] stringArray = ilvSettingsElement2.getAttributeNames();
        if (stringArray != null && stringArray.length != 0) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string = stringArray[i2];
                ilvSettingsElement3.setAttribute(string, ilvSettingsElement2.getAttribute(string));
            }
        }
        ilvSettings.addSettingsElement(ilvSettingsElement, ilvSettingsElement3, n2);
        IlvSettingsElement[] ilvSettingsElementArray = ilvSettingsElement2.getChildren();
        if (ilvSettingsElementArray == null || ilvSettingsElementArray.length == 0) {
            return ilvSettingsElement3;
        }
        for (int i3 = 0; i3 < ilvSettingsElementArray.length; ++i3) {
            IlvSettingsUtils.AddNewElement(ilvSettings, ilvSettingsElement3, ilvSettingsElementArray[i3], i3);
        }
        return ilvSettingsElement3;
    }

    public static Element GetDOMElement(IlvSettingsElement ilvSettingsElement) {
        if (ilvSettingsElement.getCascadedElementCount() == 1) {
            Object object = ilvSettingsElement.getCascadedElement(0);
            return object instanceof Element ? (Element)object : ilvSettingsElement;
        }
        return ilvSettingsElement;
    }

    public static void ApplyAttributes(IlvSettingsElement ilvSettingsElement) {
        int n2;
        String[] stringArray = ilvSettingsElement.getAttributeNames();
        Object object = ilvSettingsElement.getCascadedElement(0);
        IlvSettings ilvSettings = ilvSettingsElement.getCascadedSettings(0);
        IlvMutableSettingsModel ilvMutableSettingsModel = (IlvMutableSettingsModel)ilvSettings.getModel();
        String[] stringArray2 = ilvMutableSettingsModel.getAttributes(object);
        ArrayList<String> arrayList = null;
        if (stringArray2 != null && stringArray2.length != 0) {
            arrayList = new ArrayList<String>(stringArray2.length);
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                arrayList.add(stringArray2[n2]);
            }
        } else {
            if (stringArray != null) {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    String string = stringArray[i2];
                    ilvMutableSettingsModel.setAttributeValue(object, string, ilvSettingsElement.getAttribute(string));
                }
            }
            return;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            String string = stringArray[n2];
            Object object2 = ilvMutableSettingsModel.getAttributeValue(object, string);
            int n3 = arrayList.indexOf(string);
            if (n3 == -1) {
                ilvMutableSettingsModel.setAttributeValue(object, string, object2);
                continue;
            }
            arrayList.remove(n3);
            Object object3 = ilvMutableSettingsModel.getAttributeValue(object, string);
            if (object3 == null) {
                if (object2 == null) continue;
                ilvMutableSettingsModel.setAttributeValue(object, string, object2);
                continue;
            }
            if (object3.equals(object2)) continue;
            ilvMutableSettingsModel.setAttributeValue(object, string, object2);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            ilvMutableSettingsModel.setAttributeValue(object, (String)arrayList.get(n2), null);
        }
    }

    public static void DumpModel(IlvSettings ilvSettings) {
        IlvSettingsUtils.Println("Model " + IlvSettingsUtils.GetModelID(ilvSettings) + " [" + IlvSettingsUtils.ObjectHashCode(ilvSettings) + "]");
        IlvSettingsUtils.Inc();
        IlvSettingsElement[] ilvSettingsElementArray = ilvSettings.select((String)null, null);
        if (ilvSettingsElementArray != null) {
            for (int i2 = 0; i2 < ilvSettingsElementArray.length; ++i2) {
                IlvSettingsUtils.DumpElement(ilvSettingsElementArray[i2]);
            }
        }
        IlvSettingsUtils.Dec();
    }

    public static String GetModelID(IlvSettings ilvSettings) {
        String string;
        if (ilvSettings instanceof IlvXMLSettings) {
            IlvXMLSettings ilvXMLSettings = (IlvXMLSettings)ilvSettings;
            URL uRL = ilvXMLSettings.getXMLFileURL();
            if (uRL != null) {
                string = uRL.getPath();
                int n2 = string.lastIndexOf("\\");
                if (n2 == -1) {
                    n2 = string.lastIndexOf("/");
                }
                if (n2 != -1) {
                    string = string.substring(n2 + 1);
                }
            } else {
                string = ilvXMLSettings.getName();
            }
        } else {
            string = ilvSettings.getName();
        }
        return string;
    }

    public static String ObjectHashCode(Object object) {
        for (int i2 = 0; i2 < a.size(); ++i2) {
            if (a.get(i2) != object) continue;
            return Integer.toString(i2 + 1);
        }
        a.add(object);
        return Integer.toString(a.size());
    }

    public static void DumpElement(IlvSettingsElement ilvSettingsElement) {
        int n2;
        IlvSettingsElement[] ilvSettingsElementArray = ilvSettingsElement.getChildren();
        boolean bl = ilvSettingsElementArray != null && ilvSettingsElementArray.length != 0;
        IlvSettingsUtils.Print(INDENT + "<" + ilvSettingsElement.getType());
        String[] stringArray = ilvSettingsElement.getAttributeNames();
        if (stringArray != null && stringArray.length != 0) {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                IlvSettingsUtils.Print(" " + stringArray[n2] + "=\"" + ilvSettingsElement.getString(stringArray[n2]) + "\"");
            }
        }
        IlvSettingsUtils.Print(" {");
        for (n2 = 0; n2 < ilvSettingsElement.getCascadedElementCount(); ++n2) {
            IlvSettingsUtils.Print((n2 == 0 ? "[" : ", [") + IlvSettingsUtils.ObjectHashCode(ilvSettingsElement.getCascadedElement(n2)) + " in " + IlvSettingsUtils.GetModelID(ilvSettingsElement.getCascadedSettings(n2)) + "(" + IlvSettingsUtils.ObjectHashCode(ilvSettingsElement.getCascadedSettings(n2)) + ")]");
        }
        IlvSettingsUtils.Print("}");
        if (bl) {
            IlvSettingsUtils.Print(">");
            IlvSettingsUtils.Println("");
            IlvSettingsUtils.Inc();
            for (n2 = 0; n2 < ilvSettingsElementArray.length; ++n2) {
                IlvSettingsUtils.DumpElement(ilvSettingsElementArray[n2]);
            }
            IlvSettingsUtils.Dec();
            IlvSettingsUtils.Println("<" + ilvSettingsElement.getType() + ">");
        } else {
            IlvSettingsUtils.Print("/>");
            IlvSettingsUtils.Println("");
        }
    }

    public static void Inc() {
        INDENT = INDENT + INDENT_INC;
    }

    public static void Dec() {
        INDENT = INDENT.substring(INDENT_INC.length());
    }

    public static void Println(String string) {
        System.out.println(INDENT + string);
    }

    public static void Print(String string) {
        System.out.print(string);
    }
}

