/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.appframe.form.swing.internal;

import ilog.views.appframe.IlvAction;
import ilog.views.appframe.form.IlvFormException;
import ilog.views.appframe.form.controls.IlvFormControl;
import ilog.views.appframe.form.events.ActivationEvent;
import ilog.views.appframe.form.events.ActivationListener;
import ilog.views.appframe.form.events.ControlListener;
import ilog.views.appframe.form.internal.AbstractControlNode;
import ilog.views.appframe.form.internal.IlvFormRuntimeException;
import ilog.views.appframe.form.services.IlvServicesProvider;
import ilog.views.appframe.swing.util.IlvSwingUtil;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;

public abstract class ComponentNode
extends AbstractControlNode
implements IlvFormControl {
    protected Component component;
    private static final String a = "labeledBy";

    public Object getControl() {
        return this.component;
    }

    public void setControl(Object object) {
        this.component = (Component)object;
    }

    public void addChild(AbstractControlNode abstractControlNode, Object object, int n2) {
        Serializable serializable;
        super.addChild(abstractControlNode, object, n2);
        Component component = (Component)abstractControlNode.getControl();
        if (component.getParent() != null && (component.getParent() == this.component || component.getParent().getParent() == this.component)) {
            return;
        }
        if (this.component instanceof JMenuBar) {
            ((JMenuBar)this.component).add(component);
        } else if (this.component instanceof JScrollPane) {
            ((JScrollPane)this.component).setViewportView(component);
        } else {
            Object object2;
            if (this.component instanceof RootPaneContainer) {
                serializable = ((RootPaneContainer)((Object)this.component)).getContentPane();
                object2 = this.component.getComponentOrientation();
                ComponentOrientation componentOrientation = ((Component)serializable).getComponentOrientation();
                if (!componentOrientation.equals(object2)) {
                    ((Component)serializable).setComponentOrientation((ComponentOrientation)object2);
                }
            } else {
                serializable = (Container)this.component;
            }
            if (n2 == -1 || n2 == ((Container)serializable).getComponentCount()) {
                if (object == null) {
                    ((Container)serializable).add(component);
                } else {
                    ((Container)serializable).add(component, object);
                }
            } else if (object == null) {
                ((Container)serializable).add(component, n2);
            } else {
                ((Container)serializable).add(component, object, n2);
            }
            object2 = IlvSwingUtil.GetAssociatedAction(component);
            IlvAction.RegisterActionInGroup((Action)object2, component);
        }
        serializable = this.component.getComponentOrientation();
        if (serializable != null) {
            component.setComponentOrientation((ComponentOrientation)serializable);
        }
    }

    public boolean removeChild(AbstractControlNode abstractControlNode) {
        if (!super.removeChild(abstractControlNode)) {
            return false;
        }
        if (this.component instanceof JScrollPane) {
            ((JScrollPane)this.component).setViewportView(null);
        } else {
            Component component = (Component)abstractControlNode.getControl();
            if (this.component instanceof RootPaneContainer) {
                ((RootPaneContainer)((Object)this.component)).getContentPane().remove(component);
            } else {
                ((Container)this.component).remove(component);
            }
        }
        return true;
    }

    public void setName(String string) {
        this.component.setName(string);
        super.setName(string);
    }

    public void putProperty(String string, Object object, IlvServicesProvider ilvServicesProvider) throws IlvFormException {
        if (string.equals("visible")) {
            this.component.setVisible(AbstractControlNode.GetBoolean(object, this.component.isVisible()));
            return;
        }
        if (string.equals("enabled")) {
            this.component.setEnabled(AbstractControlNode.GetBoolean(object, this.component.isEnabled()));
            return;
        }
        if (string.equals("font")) {
            if (!(object instanceof Font)) {
                throw new IlvFormRuntimeException(this.getForm(), "Form.Runtime.NotAFont", string, this.component.getClass().getName());
            }
            this.component.setFont((Font)object);
            return;
        }
        if (string.equals("x")) {
            this.component.setLocation(AbstractControlNode.GetInt(object, this.component.getX()), this.component.getY());
            return;
        }
        if (string.equals("y")) {
            this.component.setLocation(this.component.getX(), AbstractControlNode.GetInt(object, this.component.getY()));
            return;
        }
        if (string.equals("width")) {
            this.component.setSize(AbstractControlNode.GetInt(object, this.component.getWidth()), this.component.getHeight());
            return;
        }
        if (string.equals("height")) {
            this.component.setSize(this.component.getWidth(), AbstractControlNode.GetInt(object, this.component.getHeight()));
            return;
        }
        if (string.equals("modal")) {
            boolean bl = AbstractControlNode.GetBoolean(object, true);
            if (this.getControl() instanceof JDialog) {
                ((JDialog)this.getControl()).setModal(bl);
                return;
            }
            object = bl ? Boolean.TRUE : Boolean.FALSE;
        }
        super.putProperty(string, object, ilvServicesProvider);
    }

    protected Object installDeviceControlListener(Class clazz, ControlListener controlListener) {
        if (clazz == FocusListener.class) {
            SwingFocusListener swingFocusListener = new SwingFocusListener((ilog.views.appframe.form.events.FocusListener)controlListener);
            this.component.addFocusListener(swingFocusListener);
            return swingFocusListener;
        }
        if (clazz == ActivationListener.class) {
            FormActionListener formActionListener = new FormActionListener((ActivationListener)controlListener);
            this.addActionListener(formActionListener);
            return formActionListener;
        }
        return super.installDeviceControlListener(clazz, controlListener);
    }

    protected void uninstallDeviceControlListener(Class clazz, ControlListener controlListener, Object object) {
        if (clazz == FocusListener.class) {
            this.component.removeFocusListener((FocusListener)object);
        } else if (clazz == ActivationListener.class) {
            this.removeActionListener((ActionListener)object);
        } else {
            super.uninstallDeviceControlListener(clazz, controlListener, object);
        }
    }

    public void setEnabled(boolean bl) {
        this.component.setEnabled(bl);
        if (this.component instanceof JComponent) {
            Component component = (Component)((JComponent)this.component).getClientProperty(a);
            if (component != null) {
                component.setEnabled(bl);
            }
        }
        super.setEnabled(bl);
    }

    public boolean isEnabled() {
        return this.component.isEnabled();
    }

    public Rectangle getBounds() {
        return this.component.getBounds();
    }

    public void setBounds(Rectangle rectangle) {
        if (this.component instanceof Window) {
            ((Window)this.component).pack();
        }
        this.component.setBounds(rectangle);
    }

    public Dimension getPreferredSize() {
        return this.component.getPreferredSize();
    }

    public void setPreferredSize(Dimension dimension) {
        if (this.component instanceof JComponent) {
            ((JComponent)this.component).setPreferredSize(dimension);
        }
    }

    public Dimension getMinimumSize() {
        return this.component.getMinimumSize();
    }

    public void setMinimumSize(Dimension dimension) {
        if (this.component instanceof JComponent) {
            ((JComponent)this.component).setMinimumSize(dimension);
        }
    }

    public Dimension getMaximumSize() {
        return this.component.getMaximumSize();
    }

    public void setMaximumSize(Dimension dimension) {
        if (this.component instanceof JComponent) {
            ((JComponent)this.component).setMaximumSize(dimension);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isLocaleDependentProperty(String string) {
        if (string.equals("text")) return true;
        if (string.equals("title")) return true;
        if (!string.equals("label")) return false;
        return true;
    }

    protected void addActionListener(ActionListener actionListener) {
        throw new IllegalStateException("Components of type " + this.getControlType() + " cannot be added action listeners");
    }

    protected void removeActionListener(ActionListener actionListener) {
        throw new IllegalStateException("Components of type " + this.getControlType() + " cannot be added action listeners");
    }

    private static class FormActionListener
    implements ActionListener {
        private ActivationListener a;

        public FormActionListener(ActivationListener activationListener) {
            this.a = activationListener;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.a.controlActivated(new ActivationEvent(actionEvent.getSource()));
        }
    }

    private static class SwingFocusListener
    implements FocusListener {
        private ilog.views.appframe.form.events.FocusListener a;

        public SwingFocusListener(ilog.views.appframe.form.events.FocusListener focusListener) {
            this.a = focusListener;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.a.focusGained(new ilog.views.appframe.form.events.FocusEvent(focusEvent.getComponent()));
        }

        public void focusLost(FocusEvent focusEvent) {
            this.a.focusLost(new ilog.views.appframe.form.events.FocusEvent(focusEvent.getComponent()));
        }
    }
}

