/*
 * Decompiled with CFR 0.152.
 */
package ilog.jlm;

import ilog.jlm.Jlm;
import ilog.jlm.Jlm2;
import ilog.jlm.JlmKey;
import ilog.jlm.JlmUtilities;
import ilog.jlm.b;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Properties;

public abstract class JlmDialogs {
    public static final int COLUMN_ENTIRE_KEY = 0;
    public static final int COLUMN_SITENAME = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_PRODUCT_NAME = 3;
    public static final int COLUMN_PRODUCT_VERSION = 4;
    public static final int COLUMN_CHECKSUM = 5;
    public static final int COLUMN_EXPIRATION = 6;
    public static final int COLUMN_IS_ALIVE = 7;
    public static final int COLUMN_OPTIONS = 8;
    public static final int COLUMN_BANNER = 9;
    public static final int COLUMN_MAINTENANCE_END = 10;
    public static final int COLUMN_MAINTENANCE_ALIVE = 11;
    public static final int COLUMN_HOSTID = 12;
    public static final int COLUMN_HOSTID_MATCHES = 13;
    public static final int COLUMN_LICENSEID = 14;
    public static final int COLUMN_APPLICATION = 15;
    public static final int NUM_COLUMNS = 16;

    public abstract boolean isEventThread();

    public abstract void invokeLater(Runnable var1);

    public abstract void showExpiresWarning(int var1, String[] var2, ExpiresWarningSettings var3, int var4, String var5);

    public abstract void showFailureDialog(String[] var1, boolean var2, String var3);

    public abstract void showErrorDialog(String var1, String var2);

    public static String getString(String string) {
        return Jlm.b(string);
    }

    public static Object[] JlmKeyToRow(JlmKey jlmKey) {
        Object[] objectArray = new Object[]{jlmKey.getUserKey(), jlmKey.getSiteName(), JlmDialogs.prettyLicenseType(jlmKey.getLicenseType()), JlmUtilities.prettyProductName(jlmKey.getModuleName()), JlmDialogs.prettyVersionName(jlmKey.getModuleVersion()), jlmKey.getKeyPassword(), jlmKey.getExpirationDate(), jlmKey.c() ? Boolean.TRUE : Boolean.FALSE, jlmKey.getOptionalKey(), jlmKey.getBannerFlag() ? Boolean.TRUE : Boolean.FALSE, JlmDialogs.prettyMaintenanceEnd(jlmKey.getMaintenanceEnd()), Jlm.isMaintenanceAlive(jlmKey.getMaintenanceEnd(), jlmKey.getModuleName()) ? Boolean.TRUE : Boolean.FALSE, jlmKey.getHostID(), jlmKey.d() ? Boolean.TRUE : Boolean.FALSE, jlmKey.getCustomerLicenseID(), jlmKey.getApplicationName()};
        return objectArray;
    }

    public static String prettyLicenseType(int n2) {
        switch (n2) {
            case 1: {
                return b.a("KIZRC");
            }
            case 2: {
                return b.a("VMRC");
            }
            case 4: {
                return b.a("EFUV");
            }
            case 8: {
                return b.a("ILEKZDV");
            }
            case 16: {
                return b.a("JZKV");
            }
        }
        return b.a("LEBEFNE");
    }

    public static String prettyVersionName(double d2) {
        return new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.US)).format(d2);
    }

    public static Date prettyMaintenanceEnd(int n2) {
        if (n2 == 0) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(n2 / 10000, n2 / 100 % 100 - 1, n2 % 100);
        return gregorianCalendar.getTime();
    }

    protected static class WellFormedKeys
    implements KeysProducer {
        public JlmKey[] getKeys() {
            JlmKey[] jlmKeyArray = Jlm2.a(true).h();
            ArrayList<JlmKey> arrayList = new ArrayList<JlmKey>();
            for (int i2 = 0; i2 < jlmKeyArray.length; ++i2) {
                if (!jlmKeyArray[i2].a()) continue;
                arrayList.add(jlmKeyArray[i2]);
            }
            return arrayList.toArray(new JlmKey[arrayList.size()]);
        }
    }

    public static interface KeysProducer {
        public JlmKey[] getKeys();
    }

    protected static class ExpiresWarningSettings {
        private final URL a = Jlm.a(false);
        private final Properties b = Jlm.a(this.a);
        private final String c;
        private int d;
        private boolean e;
        private boolean f;
        private boolean g;

        ExpiresWarningSettings(String string) {
            this.c = string;
            try {
                this.d = Integer.parseInt(this.b.getProperty("Hide" + string + "WarningUntil", "0"));
            }
            catch (NumberFormatException numberFormatException) {
                this.d = 0;
            }
            this.e = "true".equals(this.b.getProperty("Hide" + string + "Warning1"));
            this.f = "true".equals(this.b.getProperty("Hide" + string + "Warning7"));
            this.g = false;
        }

        public URL getPreferencesFile() {
            return this.a;
        }

        public boolean shouldShowWarning(int n2) {
            return this.d < n2;
        }

        public boolean getHideExpireWarning1() {
            return this.e;
        }

        public void setHideExpireWarning1(boolean bl) {
            if (bl != this.e) {
                this.e = bl;
                this.g = true;
            }
        }

        public boolean getHideExpireWarning7() {
            return this.f;
        }

        public void setHideExpireWarning7(boolean bl) {
            if (bl != this.f) {
                this.f = bl;
                this.g = true;
            }
        }

        public void dialogDone(int n2) {
            if (this.e) {
                this.d = n2;
                this.g = true;
            }
            if (this.f && this.d < n2 + 6) {
                this.d = n2 + 6;
                this.g = true;
            }
            if (this.g) {
                this.b.setProperty("Hide" + this.c + "WarningUntil", Integer.toString(this.d));
                this.b.setProperty("Hide" + this.c + "Warning1", this.e ? "true" : "false");
                this.b.setProperty("Hide" + this.c + "Warning7", this.f ? "true" : "false");
                Jlm.a(Jlm.a(true), this.b);
            }
        }
    }
}

