/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.vop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.model.Displayable;
import oracle.jdeveloper.vcs.vop.DisplayProperty;
import oracle.jdeveloper.vcs.vop.MutableVersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationModelEvent;
import oracle.jdeveloper.vcs.vop.VersionOperationModelListener;

public class ClientVersionOperationModel
implements MutableVersionOperationModel {
    private boolean _isComplete = true;
    private final List _items = new ArrayList();
    private final List _propertyValues;
    private final DisplayProperty[] _properties;
    private final List _listeners = new ArrayList(1);
    private boolean _firingEvents;

    public ClientVersionOperationModel() {
        this._properties = null;
        this._propertyValues = null;
    }

    public ClientVersionOperationModel(DisplayProperty[] properties) {
        this._properties = properties;
        this._propertyValues = new ArrayList();
    }

    @Override
    public synchronized void add(Collection coll) {
        if (coll.isEmpty()) {
            return;
        }
        int start = this.getCount();
        for (Object item : coll) {
            if (this._items.contains(item)) continue;
            this._items.add(item);
            if (this._properties == null) continue;
            this._propertyValues.add(new HashMap());
        }
        int end = this.getCount() - 1;
        this.fireItemsInserted(start, end);
    }

    @Override
    public synchronized void remove(Collection coll) {
        if (coll.isEmpty()) {
            return;
        }
        for (Object o : coll) {
            int idx = this._items.indexOf(o);
            if (idx < 0) continue;
            this._items.remove(idx);
            if (this._properties != null) {
                this._propertyValues.remove(idx);
            }
            this.fireItemsRemoved(idx, idx);
        }
    }

    @Override
    public synchronized void update(Collection coll) {
        if (this._items.isEmpty()) {
            return;
        }
        Iterator i = coll.iterator();
        while (i.hasNext()) {
            int index = this._items.indexOf(i.next());
            if (index < 0) continue;
            this.fireItemsChanged(index, index);
        }
    }

    @Override
    public synchronized void replace(Collection coll) {
        boolean wasEmpty = this._items.isEmpty();
        if (!wasEmpty) {
            int last = this.getCount() - 1;
            this._items.clear();
            if (this._propertyValues != null) {
                this._propertyValues.clear();
            }
            this.fireItemsRemoved(0, last, true);
        }
        if (coll.isEmpty()) {
            if (!wasEmpty) {
                this.fireItemsInserted(0, -1);
            }
        } else {
            this.add(coll);
        }
    }

    @Override
    public void setProperties(int itemIndex, Map properties) {
        this._propertyValues.set(itemIndex, properties);
        this.fireItemsChanged(itemIndex, itemIndex);
    }

    @Override
    public void setProperty(int itemIndex, DisplayProperty property, Object value) {
        ((Map)this._propertyValues.get(itemIndex)).put(property, value);
        this.fireItemsChanged(itemIndex, itemIndex);
    }

    @Override
    public void setProperties(int startIndex, Collection propertyCollection) {
        int start = startIndex;
        int end = startIndex;
        Iterator i = propertyCollection.iterator();
        while (i.hasNext()) {
            this._propertyValues.set(end++, (Map)i.next());
        }
        this.fireItemsChanged(start, end);
    }

    @Override
    public final synchronized void setComplete(boolean isComplete) {
        if (this._isComplete != isComplete) {
            this._isComplete = isComplete;
            this.fireCompletenessChanged();
        }
    }

    @Override
    public final synchronized boolean isComplete() {
        return this._isComplete;
    }

    @Override
    public synchronized int getCount() {
        return this._items.size();
    }

    @Override
    public synchronized Displayable getItem(int index) {
        return (Displayable)this._items.get(index);
    }

    @Override
    public synchronized Displayable[] getItems() {
        return this._items.toArray(new Displayable[0]);
    }

    @Override
    public Displayable getCategory(Displayable item) {
        return null;
    }

    @Override
    public DisplayProperty[] getProperties() {
        return this._properties;
    }

    @Override
    public synchronized Object getPropertyValue(DisplayProperty property, int itemIndex) {
        if (this._propertyValues == null) {
            return null;
        }
        Map map = (Map)this._propertyValues.get(itemIndex);
        if (map == null) {
            return null;
        }
        return map.get(property);
    }

    @Override
    public void addVersionOperationModelListener(VersionOperationModelListener l) {
        this._listeners.add(l);
    }

    @Override
    public void removeVersionOperationListener(VersionOperationModelListener l) {
        this._listeners.remove(l);
    }

    protected void fireCompletenessChanged() {
        if (!this._listeners.isEmpty()) {
            ArrayList l = new ArrayList(this._listeners);
            VersionOperationModelEvent event = new VersionOperationModelEvent(this);
            Iterator i = l.iterator();
            while (i.hasNext()) {
                ((VersionOperationModelListener)i.next()).completenessChanged(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireItemsInserted(int start, int end) {
        if (this._firingEvents) {
            return;
        }
        this._firingEvents = true;
        try {
            if (!this._listeners.isEmpty()) {
                ArrayList l = new ArrayList(this._listeners);
                VersionOperationModelEvent event = new VersionOperationModelEvent(this, start, end);
                Iterator i = l.iterator();
                while (i.hasNext()) {
                    ((VersionOperationModelListener)i.next()).itemsInserted(event);
                }
            }
        }
        finally {
            this._firingEvents = false;
        }
    }

    protected void fireItemsRemoved(int start, int end) {
        this.fireItemsRemoved(start, end, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireItemsRemoved(int start, int end, boolean changing) {
        if (this._firingEvents) {
            return;
        }
        this._firingEvents = true;
        try {
            if (!this._listeners.isEmpty()) {
                ArrayList l = new ArrayList(this._listeners);
                VersionOperationModelEvent event = new VersionOperationModelEvent(this, start, end, changing);
                Iterator i = l.iterator();
                while (i.hasNext()) {
                    ((VersionOperationModelListener)i.next()).itemsRemoved(event);
                }
            }
        }
        finally {
            this._firingEvents = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireItemsChanged(int start, int end) {
        if (this._firingEvents) {
            return;
        }
        this._firingEvents = true;
        try {
            if (!this._listeners.isEmpty()) {
                ArrayList l = new ArrayList(this._listeners);
                VersionOperationModelEvent event = new VersionOperationModelEvent(this, start, end);
                Iterator i = l.iterator();
                while (i.hasNext()) {
                    ((VersionOperationModelListener)i.next()).itemsChanged(event);
                }
            }
        }
        finally {
            this._firingEvents = false;
        }
    }
}

