/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.VirtualFileSystemHelper;
import oracle.jdeveloper.vcs.cache.Depth;

public abstract class FileSystemLister {
    private static final FileSystemLister _defaultLister = new FileSystemLister(){

        @Override
        protected final URL[] listAncillary(URL directoryUrl) {
            return null;
        }
    };

    public static final FileSystemLister getDefaultLister() {
        return _defaultLister;
    }

    public final List<URL> listFiles(URL[] urls, ListMode mode, Depth depth, String adminPath) {
        ArrayList<URL> c = new ArrayList<URL>();
        for (URL url : urls) {
            boolean isDirectoryPath = URLFileSystem.isDirectoryPath((URL)url);
            this.addListedURL(url, mode, c, isDirectoryPath);
            if (!isDirectoryPath) continue;
            if (depth == Depth.IMMEDIATES) {
                VirtualFileSystemHelper.invalidateDirectory((URL)url);
            }
            if (depth == Depth.INFINITY) {
                VirtualFileSystemHelper.invalidateDirectoryTree((URL)url);
            }
            if (depth == Depth.EMPTY) continue;
            this.listDirectory(url, mode, depth, c, adminPath);
        }
        return c;
    }

    private final void listDirectory(URL directoryUrl, ListMode mode, Depth depth, List<URL> c, String adminPath) {
        URL[] ancillaryUrls;
        ArrayList<URL> urls = new ArrayList<URL>();
        URL[] listedUrls = URLFileSystem.list((URL)directoryUrl);
        if (listedUrls != null) {
            urls.addAll(Arrays.asList(listedUrls));
        }
        if ((ancillaryUrls = this.listAncillary(directoryUrl)) != null && ancillaryUrls.length > 0) {
            urls.addAll(Arrays.asList(ancillaryUrls));
        }
        for (URL url : urls) {
            boolean isDirectoryPath = URLFileSystem.isDirectoryPath((URL)url);
            if (adminPath != null && url.toExternalForm().endsWith(adminPath)) continue;
            this.addListedURL(url, mode, c, isDirectoryPath);
            if (!isDirectoryPath || depth == Depth.IMMEDIATES) continue;
            if (depth == Depth.INFINITY) {
                // empty if block
            }
            this.listDirectory(url, mode, depth, c, adminPath);
        }
    }

    private final void addListedURL(URL url, ListMode mode, Collection<URL> c, boolean isDirectoryPath) {
        if ((mode == ListMode.FILES_AND_DIRECTORIES || mode == ListMode.DIRECTORIES_ONLY) && isDirectoryPath) {
            c.add(url);
        }
        if (!(mode != ListMode.FILES_AND_DIRECTORIES && mode != ListMode.FILES_ONLY || isDirectoryPath)) {
            c.add(url);
        }
    }

    protected abstract URL[] listAncillary(URL var1);

    public static enum ListMode {
        FILES_ONLY,
        DIRECTORIES_ONLY,
        FILES_AND_DIRECTORIES;

    }
}

