/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic.util;

import java.net.URL;
import java.util.Collection;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.history.HistoryManager;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.algorithm.directory.DirectoryList;
import oracle.jdeveloper.compare.BinaryCompareContributor;
import oracle.jdeveloper.compare.CompareManager;
import oracle.jdeveloper.compare.CompareViewer;
import oracle.jdeveloper.compare.DirectoryCompareContributor;
import oracle.jdeveloper.compare.TextNodeContributor;
import oracle.jdeveloper.compare.URLContributor;
import oracle.jdeveloper.history.HistoryContext;
import oracle.jdeveloper.history.HistoryEntrySelector;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.generic.ActionCommand;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdevimpl.compare.CompareUtil;
import oracle.jdevimpl.vcs.generic.res.Resource;

public abstract class VCSCompareCommand
extends ActionCommand {
    public VCSCompareCommand(String commandId) {
        super(Ide.findCmdID((String)commandId));
        this.initializeCommandStyle(VCSCommandStyle.SINGLE);
    }

    @Override
    protected boolean locatablesValid(VCSProfile profile) {
        if (CompareViewer.get() == null) {
            return false;
        }
        try {
            if (this.getContext().getSelection().length != 1) {
                return false;
            }
            Collection selection = this.getFilteredSelection(this.getOperands(profile));
            if (selection != null && selection.size() == 1) {
                Locatable[] urls = selection.toArray(new Locatable[1]);
                URL url = urls[0].getURL();
                if (!URLFileSystem.exists((URL)url)) {
                    return false;
                }
                if (URLFileSystem.isDirectoryPath((URL)url)) {
                    return this.isDirectoryCompareSupported();
                }
                return CompareManager.getCompareManager().isContentComparable(url);
            }
            return false;
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException(e);
            return false;
        }
    }

    protected boolean isDirectoryCompareSupported() {
        return false;
    }

    @Override
    protected int doitImpl(VCSProfile profile) throws Exception {
        this.context = ChangeListWindow.handleContext(this.context);
        Collection selection = this.getFilteredSelection(this.getOperands(profile));
        if (selection.size() != 1) {
            return 9;
        }
        Locatable[] locatables = selection.toArray(new Locatable[selection.size()]);
        Object contextRevision = this.getContextRevision(profile, locatables[0]);
        if (this.hasHistoryEditorTab(locatables[0])) {
            return this.showHistoryTab(profile, locatables[0], contextRevision);
        }
        return this.showCompareViewer(profile, locatables[0], contextRevision);
    }

    protected int showHistoryTab(VCSProfile profile, Locatable source, Object revision) throws Exception {
        CompareContributor historicalContrib;
        Context historicalContext = new Context(this.getContext());
        this.setContext(historicalContext);
        if (source instanceof Node) {
            historicalContext.setNode((Node)source);
        }
        if ((historicalContrib = this.getHistoricalContributor(profile, source, revision)) != null) {
            CompareContributor currentContrib = this.getCurrentContributor(source);
            if (this.contributorsIdentical(historicalContext.getNode(), historicalContrib, currentContrib) && !CompareUtil.confirmIdenticalCompare()) {
                return 1;
            }
        }
        HistoryEntrySelector entrySelector = this.getHistoryEntrySelector(profile, source, revision);
        HistoryContext.setHistoryEntrySelectorLHS((Context)historicalContext, (HistoryEntrySelector)entrySelector);
        oracle.jdeveloper.history.HistoryManager.getHistoryManager().showHistory(historicalContext);
        return 0;
    }

    protected int showCompareViewer(VCSProfile profile, final Locatable source, Object revision) throws Exception {
        final CompareContributor currentContrib = this.getCurrentContributor(source);
        final CompareContributor historicalContrib = this.getHistoricalContributor(profile, source, revision);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CompareViewer.get().show(historicalContrib, currentContrib, source instanceof Element ? (Element)source : null);
            }
        });
        return 0;
    }

    protected CompareContributor getCurrentContributor(URL url) throws Exception {
        return this.getCurrentContributor((Locatable)NodeFactory.find((URL)url), url);
    }

    protected CompareContributor getCurrentContributor(Locatable locatable) throws Exception {
        return this.getCurrentContributor(locatable, locatable.getURL());
    }

    private CompareContributor getCurrentContributor(Locatable locatable, URL url) throws Exception {
        if (URLFileSystem.isDirectoryPath((URL)url)) {
            if (!this.isDirectoryCompareSupported()) {
                throw new IllegalStateException();
            }
            String label = Resource.format("COMPARE_LOCAL_DIRECTORY", URLFileSystem.getFileName((URL)url));
            return this.createDirectoryContributor(url, this.listDirectory(url), label);
        }
        if (locatable instanceof TextNode && ((TextNode)locatable).isDirty()) {
            return new TextNodeContributor((TextNode)locatable);
        }
        if (VCSFileSystemUtils.isContentTypeBinary(locatable.getURL())) {
            return new BinaryCompareContributor(locatable.getURL());
        }
        return new URLContributor(locatable.getURL());
    }

    protected CompareContributor createDirectoryContributor(URL url, DirectoryList directoryList, String label) {
        DirectoryCompareContributor contrib = new DirectoryCompareContributor(url);
        contrib.setShortLabel(label);
        contrib.setLongLabel(label);
        contrib.setDirectoryList(directoryList);
        return contrib;
    }

    protected DirectoryList listDirectory(URL directoryUrl) throws Exception, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    protected abstract Object getContextRevision(VCSProfile var1, Locatable var2) throws Exception;

    protected abstract CompareContributor getHistoricalContributor(VCSProfile var1, Locatable var2, Object var3) throws Exception;

    protected abstract HistoryEntrySelector getHistoryEntrySelector(VCSProfile var1, Locatable var2, Object var3) throws Exception;

    protected boolean hasHistoryEditorTab(Locatable locatable) {
        return locatable instanceof Element && HistoryManager.getHistoryManager().isHistoried((Element)locatable);
    }

    private boolean contributorsIdentical(Node contextNode, CompareContributor historical, CompareContributor current) throws CompareFailedException {
        CompareModel model = CompareUtil.createCompareModel((Node)contextNode, (CompareContributor)historical, (CompareContributor)current);
        return model != null && model.getDifferences().length == 0;
    }
}

