/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic.profile;

import java.util.HashMap;
import java.util.Map;
import javax.ide.Identifiable;
import javax.ide.extension.ExtensionRegistry;
import javax.ide.util.MetaClass;
import oracle.jdeveloper.vcs.generic.StatusResolver;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdevimpl.vcs.generic.profile.BaseInfo;
import oracle.jdevimpl.vcs.generic.profile.FileSystemInfo;
import oracle.jdevimpl.vcs.generic.profile.InitializableProfileObject;
import oracle.jdevimpl.vcs.generic.profile.StatusInfo;

public final class StatusesInfo
extends BaseInfo
implements InitializableProfileObject {
    private CachePolicyInfo _cachePolicyInfo;
    private FileSystemInfo _fsInfo;
    private MetaClass<StatusResolver> _resolverClass;
    private MetaClass<VCSOverlayItemProducer> _overlayClass;
    private final Map _statuses = new HashMap(20);
    private final Map _statusFilters = new HashMap(20);

    public void setCachePolicy(Object cachePolicy) {
        if (!(cachePolicy instanceof CachePolicyInfo)) {
            throw new IllegalArgumentException();
        }
        this._cachePolicyInfo = (CachePolicyInfo)cachePolicy;
    }

    public CachePolicyInfo getCachePolicy() {
        return this._cachePolicyInfo;
    }

    public void setResolverClass(String className) {
        this._resolverClass = new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader(this.getExtensionID()), className);
    }

    public Class<StatusResolver> getResolverClass() throws ClassNotFoundException {
        return this._resolverClass != null ? this._resolverClass.toClass() : null;
    }

    public void setOverlayProducerClass(String className) {
        this._overlayClass = new MetaClass(ExtensionRegistry.getExtensionRegistry().getClassLoader(this.getExtensionID()), className);
    }

    public Class<VCSOverlayItemProducer> getOverlayProducerClass() throws ClassNotFoundException {
        return this._overlayClass != null ? this._overlayClass.toClass() : null;
    }

    public void addStatus(Object status) {
        if (!(status instanceof StatusInfo)) {
            throw new IllegalArgumentException();
        }
        this._statuses.put(((StatusInfo)status).getID(), status);
    }

    public StatusInfo getStatus(String id) {
        return (StatusInfo)this._statuses.get(id);
    }

    public void addStatusFilter(Object filter) {
        if (!(filter instanceof VCSStatusFilter)) {
            throw new IllegalArgumentException();
        }
        this._statusFilters.put(filter instanceof Identifiable ? ((Identifiable)filter).getID() : filter.getClass().getName(), filter);
    }

    public VCSStatusFilter getStatusFilter(String id) {
        return (VCSStatusFilter)this._statusFilters.get(id);
    }

    @Override
    public void preInitialize(Object parent) {
        if (!(parent instanceof FileSystemInfo)) {
            throw new IllegalArgumentException();
        }
        this._fsInfo = (FileSystemInfo)parent;
    }

    @Override
    public void postInitialize() {
    }

    protected FileSystemInfo getFileSystemInfo() {
        return this._fsInfo;
    }

    public static final class CachePolicyInfo {
        private String _policyId;

        public void setPolicyId(String policyId) {
            this._policyId = policyId;
        }

        public String getPolicyId() {
            return this._policyId;
        }
    }
}

