/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.generic.changelist;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.ide.extension.ExtensionRegistry;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.layout.ViewId;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListDockableFactory;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdevimpl.vcs.ClassUtil;

public class GenericChangeListDockableFactory
extends ChangeListDockableFactory {
    private final String _windowID;
    private final String _windowClassName;
    private final VCSProfile _profile;

    public GenericChangeListDockableFactory(String windowID, String className, VCSProfile profile) {
        super(windowID, null, className, profile.getID());
        this._windowID = ViewId.validate((String)windowID);
        this._windowClassName = className;
        this._profile = profile;
    }

    @Override
    protected ChangeListWindow createChangeListWindow(ChangeList changeList) {
        if (this._windowClassName == null) {
            return new ChangeListWindow(changeList, this._windowID);
        }
        try {
            ClassLoader loader = ExtensionRegistry.getExtensionRegistry().getClassLoader(this._profile.getID());
            Class<?> c = Class.forName(this._windowClassName, true, loader);
            Constructor<?> constructor = c.getConstructor(String.class, VCSProfile.class);
            return (ChangeListWindow)((Object)ClassUtil.newInstance(constructor, this.getWindowId(), this._profile));
        }
        catch (InstantiationException e) {
            FeedbackManager.reportException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            FeedbackManager.reportException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            FeedbackManager.reportException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            FeedbackManager.reportException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            FeedbackManager.reportException((Throwable)e);
        }
        return null;
    }
}

