/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.config.FileTypesRecognizer;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.icons.OracleIcons;

public final class VCSNodeIconUtils {
    private VCSNodeIconUtils() {
    }

    public static Icon getIconForURL(URL url) {
        if (URLFileSystem.isDirectoryPath((URL)url)) {
            return OracleIcons.getIcon((String)"folder.png");
        }
        return VCSNodeIconUtils.getIconForSuffix(URLFileSystem.getSuffix((URL)url));
    }

    public static Icon getIconForSuffix(String suffix) {
        if (suffix == null || suffix.length() <= 0) {
            return OracleIcons.getIcon((String)"file.png");
        }
        String nodeType = FileTypesRecognizer.getClassNameForExtension((String)suffix);
        if (nodeType == null) {
            return OracleIcons.getIcon((String)"file.png");
        }
        DocumentInfo documentInfo = Recognizer.getDocumentInfo((String)nodeType);
        Icon icon = documentInfo != null ? documentInfo.getIcon() : null;
        return icon == null ? OracleIcons.getIcon((String)"file.png") : icon;
    }
}

