/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.util.PatternFilter;

public class VCSIgnoreFilters {
    private static PatternFilter[] ignoreDefaultList = new PatternFilter[]{PatternFilter.newInclude((String)"**/classes/**"), PatternFilter.newInclude((String)"**/temp/**"), PatternFilter.newInclude((String)"**/*.class"), PatternFilter.newInclude((String)"**/*.metadata"), PatternFilter.newInclude((String)"**/*#GRABTRANS*")};
    private static Collection<PatternFilter> ignoreList;

    private VCSIgnoreFilters() {
    }

    public static Collection<String> getAllIgnoreFilters() {
        PatternFilter[] filters;
        ArrayList<String> ignore = new ArrayList<String>();
        for (PatternFilter filter : filters = GlobalIgnoreList.getPatternFilters().getFilters()) {
            if (!filter.isExclude()) continue;
            ignore.add(filter.getPattern());
        }
        for (PatternFilter filter : ignoreDefaultList) {
            ignore.add(filter.getPattern());
        }
        Iterator it = VCSIgnoreFilters.getIgnoreList().iterator();
        while (it.hasNext()) {
            ignore.add(((PatternFilter)it.next()).getPattern());
        }
        return ignore;
    }

    public static Collection<PatternFilter> getAllIgnorePatternFilters() {
        PatternFilter[] filters;
        ArrayList<PatternFilter> ignore = new ArrayList<PatternFilter>();
        for (PatternFilter filter : filters = GlobalIgnoreList.getPatternFilters().getFilters()) {
            if (!filter.isExclude()) continue;
            ignore.add(filter);
        }
        for (PatternFilter filter : ignoreDefaultList) {
            ignore.add(filter);
        }
        Iterator it = VCSIgnoreFilters.getIgnoreList().iterator();
        while (it.hasNext()) {
            ignore.add((PatternFilter)it.next());
        }
        return ignore;
    }

    public static void addFilterPattern(String pattern) {
        VCSIgnoreFilters.getIgnoreList().add(PatternFilter.newInclude((String)pattern));
    }

    private static synchronized Collection getIgnoreList() {
        if (ignoreList == null) {
            ignoreList = new ArrayList<PatternFilter>();
        }
        return ignoreList;
    }
}

