/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.vcs.VCS;
import oracle.ide.vcs.VCSRegistry;
import oracle.jdeveloper.vcs.spi.VCSControlCache;
import oracle.jdeveloper.vcs.spi.VCSExtension;
import oracle.jdeveloper.vcs.util.VCSContextUtils;

public final class VCSExtensionUtils {
    private VCSExtensionUtils() {
    }

    public static final VCSExtension getActiveExtension(Context context) {
        return VCSExtensionUtils.getActiveExtension(VCSContextUtils.getContextLocatables(context));
    }

    public static final VCSExtension getActiveExtension(Node node) {
        return VCSExtensionUtils.getActiveExtension(VCSContextUtils.getExpandedLocatables(null, new Element[]{node}, null));
    }

    private static final VCSExtension getActiveExtension(Locatable[] locatables) {
        return locatables.length > 0 ? VCSExtensionUtils.getActiveExtension(locatables[0].getURL()) : null;
    }

    public static final VCSExtension getActiveExtension(URL url) {
        if (url == null) {
            return null;
        }
        for (String id : VCSRegistry.keySet()) {
            VCS vcs = VCSRegistry.lookup((String)id);
            if (!(vcs instanceof VCSExtension) || !VCSControlCache.getInstance().isControlled(url, vcs.getId())) continue;
            return (VCSExtension)vcs;
        }
        return null;
    }

    static int getExtensionCount() {
        int i = 0;
        for (String id : VCSRegistry.keySet()) {
            if (!(VCSRegistry.lookup((String)id) instanceof VCSExtension)) continue;
            ++i;
        }
        return i;
    }
}

