/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.tracking;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class VCSBugTrackingContext {
    private static final String MESSAGE = "bug-tracking-message";
    private static final String MESSAGE_BELOW = "bug-message-below-commit";
    public static final String PATCH_ATTACH_TASK = "patch-attach-task";
    private String _vcsType;
    private URL _url;
    private Map<String, Object> _properties = new HashMap<String, Object>();
    private Collection<PropertyChangeListener> _listeners = new ArrayList<PropertyChangeListener>();

    public VCSBugTrackingContext(String type) {
        this._vcsType = type;
    }

    public String getType() {
        return this._vcsType;
    }

    public URL getURL() {
        return this._url;
    }

    public void setURL(URL url) {
        this._url = url;
    }

    public void setProperty(String name, Object value) {
        Object oldValue = this._properties.get(name);
        this._properties.put(name, value);
        this.firePropertyChange(name, oldValue, value);
    }

    public Object getProperty(String name) {
        return this._properties.get(name);
    }

    public void setMessage(String msg) {
        this.setProperty(MESSAGE, msg);
    }

    public String getMessage() {
        return (String)this.getProperty(MESSAGE);
    }

    public void setMessageBelow(boolean value) {
        this.setProperty(MESSAGE_BELOW, value);
    }

    public boolean isMessageBelow() {
        Boolean value = (Boolean)this.getProperty(MESSAGE_BELOW);
        if (value == null) {
            return true;
        }
        return value;
    }

    public void addPropertyListener(PropertyChangeListener listener) {
        this._listeners.add(listener);
    }

    public void removePropertyListener(PropertyChangeListener listener) {
        this._listeners.remove(listener);
    }

    private void firePropertyChange(String name, Object oldValue, Object newValue) {
        PropertyChangeEvent pce = new PropertyChangeEvent(new Object(), name, oldValue, newValue);
        Iterator<PropertyChangeListener> it = this._listeners.iterator();
        while (it.hasNext()) {
            it.next().propertyChange(pce);
        }
    }
}

