/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.net.URL;
import java.util.Observable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import oracle.ide.config.Preferences;
import oracle.ide.explorer.IconOverlay;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.cache.StatusCacheBridge;
import oracle.jdeveloper.vcs.spi.VCSOverlayItem;
import oracle.jdeveloper.vcs.spi.VCSPreferences;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;

public class VCSOverlayItemProducer {
    private final String _extensionId;
    private final StatusCacheBridge<VCSStatus> _statusCache;
    private final Lock _prefsLock = new ReentrantLock();
    private VCSPreferences _prefs;

    public VCSOverlayItemProducer(String extensionId, StatusCacheBridge<VCSStatus> statusCache) {
        this._extensionId = extensionId;
        this._statusCache = statusCache.newLocalCache();
    }

    @Deprecated
    public VCSStatusCache getStatusCache() {
        return this._statusCache instanceof VCSStatusCache ? (VCSStatusCache)this._statusCache : null;
    }

    public StatusCache<VCSStatus> getPolicyStatusCache() {
        return this._statusCache instanceof StatusCache ? (StatusCache)this._statusCache : null;
    }

    public StatusCacheBridge<VCSStatus> getStatusCacheBridge() {
        return this._statusCache;
    }

    public Observable getObservable() {
        return (Observable)((Object)this._statusCache);
    }

    public VCSOverlayItem[] getOverlayItems(URL[] urls) throws Exception {
        VCSStatus[] statuses = this._statusCache.get(urls);
        IconOverlay[] iconOverlays = this.produceOverlays(urls, statuses);
        VCSOverlayItem[] overlayItems = new VCSOverlayItem[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            overlayItems[i] = new VCSOverlayItem(statuses[i], iconOverlays[i]);
        }
        return overlayItems;
    }

    protected IconOverlay[] produceOverlays(URL[] urls, VCSStatus[] statuses) throws Exception {
        return this.produceOverlays(urls, statuses, this.getPreferences());
    }

    protected IconOverlay[] produceOverlays(URL[] urls, VCSStatus[] statuses, VCSPreferences prefs) throws Exception {
        IconOverlay[] iconOverlays = new IconOverlay[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            iconOverlays[i] = this.produceOverlay(urls[i], statuses[i]);
        }
        return iconOverlays;
    }

    protected IconOverlay produceOverlay(URL url, VCSStatus status) throws Exception {
        return this.produceOverlay(url, status, this.getPreferences());
    }

    protected IconOverlay produceOverlay(URL url, VCSStatus status, VCSPreferences prefs) throws Exception {
        return status.getOverlay();
    }

    public void preferencesChanged() {
        this._prefsLock.lock();
        try {
            this._prefs = null;
        }
        finally {
            this._prefsLock.unlock();
        }
    }

    private final VCSPreferences getPreferences() {
        if (this._extensionId == null) {
            return null;
        }
        this._prefsLock.lock();
        try {
            if (this._prefs == null) {
                this._prefs = this.getPreferences((PropertyStorage)Preferences.getPreferences());
            }
            VCSPreferences vCSPreferences = this._prefs;
            return vCSPreferences;
        }
        finally {
            this._prefsLock.unlock();
        }
    }

    protected VCSPreferences getPreferences(PropertyStorage prefs) {
        return VCSPreferences.getInstance(prefs, this._extensionId);
    }
}

