/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Observable;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.vcs.VCS;
import oracle.ide.vcs.VCSRegistry;
import oracle.javatools.util.Maps;
import oracle.jdeveloper.vcs.spi.VCSExtension;

public class VCSControlCache
extends Observable {
    private static final VCSControlCache _instance = new VCSControlCache();
    private static final int CACHE_SIZE = 5000;
    private Map<String, String> _cache = new Maps.CacheMap(5000, Maps.CacheMap.NOT_CANONICAL);
    private Collection<VCSExtension> _extensions;

    private VCSControlCache() {
    }

    public static final VCSControlCache getInstance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isControlled(URL url, String vcsId) {
        URL directoryUrl;
        if (url == null) {
            return false;
        }
        if (JarUtil.isJarURL((URL)url)) {
            url = JarUtil.getJarFileURL((URL)url);
        }
        URL uRL = directoryUrl = URLFileSystem.isDirectoryPath((URL)url) ? url : URLFileSystem.getParent((URL)url);
        if (directoryUrl == null) {
            return false;
        }
        String externalUrl = directoryUrl.toExternalForm();
        Map<String, String> map = this._cache;
        synchronized (map) {
            if (this._cache.containsKey(externalUrl)) {
                return this.nullSafeEquals(this._cache.get(externalUrl), vcsId);
            }
        }
        for (VCSExtension currentExtension : this.getExtensions()) {
            if (!currentExtension.isControlled(url)) continue;
            Map<String, String> map2 = this._cache;
            synchronized (map2) {
                this._cache.put(externalUrl, currentExtension.getId());
                return this.nullSafeEquals(currentExtension.getId(), vcsId);
            }
        }
        map = this._cache;
        synchronized (map) {
            this._cache.put(externalUrl, null);
            return vcsId == null;
        }
    }

    private boolean nullSafeEquals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireControlStateChanged(String vcsId) {
        Map<String, String> map = this._cache;
        synchronized (map) {
            this._cache.clear();
        }
        this.setChanged();
        this.notifyObservers(vcsId);
    }

    private Collection<VCSExtension> getExtensions() {
        if (this._extensions != null) {
            if (this._extensions.size() != VCSRegistry.keySet().size()) {
                this._extensions = null;
            } else {
                return this._extensions;
            }
        }
        ArrayList<VCSExtension> extensions = new ArrayList<VCSExtension>();
        for (String id : VCSRegistry.keySet()) {
            VCS vcs = VCSRegistry.lookup((String)id);
            if (!(vcs instanceof VCSExtension)) continue;
            extensions.add((VCSExtension)vcs);
        }
        Collections.sort(extensions, new Comparator<VCSExtension>(){

            @Override
            public int compare(VCSExtension extension1, VCSExtension extension2) {
                return extension1.getControlPrecedence() - extension2.getControlPrecedence();
            }
        });
        this._extensions = extensions;
        return this._extensions;
    }

    public static final void resetExtensions() {
        VCSControlCache._instance._extensions = null;
    }
}

