/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.table.GenericTable;
import oracle.jdeveloper.resource.VCSArb;

public abstract class VCSCommandLinePanel
extends JPanel {
    public static final String NAME = "Name";
    public static final String PATH = "Path";
    public static final String OTHERPATH = "OtherPath";
    private JLabel _lblIdentify = new JLabel();
    private JRadioButton _radName = new JRadioButton();
    private JRadioButton _radPath = new JRadioButton();
    private JRadioButton _radOtherPath = new JRadioButton();
    private ButtonGroup _grpPath = new ButtonGroup();
    private JButton _btnBrowse = new JButton();
    private JTextField _txtName = new JTextField();
    private GenericTable _tblPaths = new GenericTable((TableModel)new CommandPathTableModel());
    private JTextField _txtOtherpath = new JTextField();

    public VCSCommandLinePanel() {
        super(new GridBagLayout());
        this.initComponents();
        this.layoutComponents();
        this.addListeners();
        this.defaultValues();
    }

    protected abstract String getIdentifyLabel();

    protected abstract String getDefaultClient();

    protected abstract URL[] getCommandLocations();

    public void setCommandRevisions(Map<String, String> commandRevisions) {
        CommandPathTableModel model = (CommandPathTableModel)this._tblPaths.getModel();
        ArrayList<String> revList = new ArrayList<String>();
        for (int r = 0; r < model.getRowCount(); ++r) {
            String revision = commandRevisions.get(model.getValueAt(r, 0));
            if (revision == null) {
                revList.add(VCSArb.get("CLP_PREFERNECE_NO_REVISION"));
                continue;
            }
            revList.add(revision);
        }
        model.setValue(revList.toArray(new String[0]), 1);
    }

    private void initComponents() {
        this._tblPaths.setPreferredVisibleRowCount(4);
        this._tblPaths.setVisibleRows(4);
        this._tblPaths.setSelectionMode(0);
        ResourceUtils.resLabel((JLabel)this._lblIdentify, (Component)this._radName, (String)this.getIdentifyLabel());
        ResourceUtils.resButton((AbstractButton)this._radName, (String)VCSArb.get("CLP_PREFERENCE_NAME"));
        ResourceUtils.resButton((AbstractButton)this._radPath, (String)VCSArb.get("CLP_PREFERENCE_PATH"));
        ResourceUtils.resButton((AbstractButton)this._radOtherPath, (String)VCSArb.get("CLP_PREFERENCE_OTHERPATH"));
        this._grpPath.add(this._radName);
        this._grpPath.add(this._radPath);
        this._grpPath.add(this._radOtherPath);
        this._radName.setName(NAME);
        this._radPath.setName(PATH);
        this._radOtherPath.setName(OTHERPATH);
        ResourceUtils.resButton((AbstractButton)this._btnBrowse, (String)VCSArb.get("CLP_PREFERENCE_OTHERPATH_BROWSE"));
    }

    private void layoutComponents() {
        Insets ins = new Insets(5, 5, 5, 5);
        Insets topleft = new Insets(0, 25, 5, 5);
        Insets top = new Insets(0, 5, 5, 5);
        this.add((Component)this._lblIdentify, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this._radName, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this._txtName, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, topleft, 0, 0));
        this.add((Component)this._radPath, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)new JScrollPane((Component)this._tblPaths), new GridBagConstraints(0, 4, 2, 3, 1.0, 1.0, 17, 1, topleft, 0, 0));
        this.add((Component)this._radOtherPath, new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 2, ins, 0, 0));
        this.add((Component)this._txtOtherpath, new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 17, 2, topleft, 0, 0));
        this.add((Component)this._btnBrowse, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 13, 0, top, 0, 0));
        this.add((Component)new JPanel(), new GridBagConstraints(1, 9, 1, 1, 0.0, 1.0, 17, 3, top, 0, 0));
    }

    public void setPathRadio(String value) {
        if (this._radName.getName().equals(value)) {
            this._grpPath.setSelected(this._radName.getModel(), true);
            this.initRadioMembers(false, false, true);
        } else if (this._radPath.getName().equals(value)) {
            this._grpPath.setSelected(this._radPath.getModel(), true);
            this.initRadioMembers(false, true, false);
        } else if (this._radOtherPath.getName().equals(value)) {
            this._grpPath.setSelected(this._radOtherPath.getModel(), true);
            this.initRadioMembers(true, false, false);
        }
    }

    public String getPathRadio() {
        if (this._grpPath.isSelected(this._radName.getModel())) {
            return this._radName.getName();
        }
        if (this._grpPath.isSelected(this._radPath.getModel())) {
            return this._radPath.getName();
        }
        if (this._grpPath.isSelected(this._radOtherPath.getModel())) {
            return this._radOtherPath.getName();
        }
        return null;
    }

    public void setPathLocation(String command) {
        if (this._grpPath.isSelected(this._radName.getModel())) {
            this._txtName.setText(command);
        } else if (this._grpPath.isSelected(this._radPath.getModel())) {
            this.setSelected(command);
        } else if (this._grpPath.isSelected(this._radOtherPath.getModel())) {
            this._txtOtherpath.setText(command);
        }
    }

    public String getPathLocation() {
        if (this._grpPath.isSelected(this._radName.getModel())) {
            return this._txtName.getText();
        }
        if (this._grpPath.isSelected(this._radPath.getModel())) {
            int row = this._tblPaths.getSelectedRowInModel();
            return (String)this._tblPaths.getModel().getValueAt(row, 0);
        }
        if (this._grpPath.isSelected(this._radOtherPath.getModel())) {
            return this._txtOtherpath.getText();
        }
        return null;
    }

    private void initRadioMembers(boolean otherPath, boolean paths, boolean name) {
        this._txtOtherpath.setEnabled(otherPath);
        this._btnBrowse.setEnabled(otherPath);
        this._tblPaths.setEnabled(paths);
        this._txtName.setEnabled(name);
    }

    private void addListeners() {
        this._radName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VCSCommandLinePanel.this.initRadioMembers(false, false, true);
            }
        });
        this._radPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VCSCommandLinePanel.this.initRadioMembers(false, true, false);
                if (VCSCommandLinePanel.this._tblPaths.getSelectedRowCount() == 0) {
                    VCSCommandLinePanel.this._tblPaths.setSelectedRowInModel(0);
                }
            }
        });
        this._radOtherPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VCSCommandLinePanel.this.initRadioMembers(true, false, false);
            }
        });
        this._btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                URLChooser chooser = DialogUtil.newURLChooser((URL)URLFactory.newDirURL((String)VCSCommandLinePanel.this._txtOtherpath.getText()));
                int ret = chooser.showOpenDialog((Component)Ide.getMainWindow());
                if (ret == 0) {
                    URL url = chooser.getSelectedURL();
                    VCSCommandLinePanel.this._txtOtherpath.setText(URLFileSystem.getPlatformPathName((URL)url));
                }
            }
        });
    }

    private void defaultValues() {
        this._txtOtherpath.setText(Ide.getOracleHomeDirectory());
        this._txtName.setText(this.getDefaultClient());
    }

    private void setSelected(String command) {
        CommandPathTableModel model = (CommandPathTableModel)this._tblPaths.getModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            String cmd = (String)model.getValueAt(row, 0);
            if (!cmd.equals(command)) continue;
            this._tblPaths.setSelectedRowInModel(row);
            return;
        }
    }

    private class CommandPathTableModel
    extends AbstractTableModel {
        private String[] colNames = new String[]{VCSArb.get("CLP_PREFERENCE_TABLE_PATH"), VCSArb.get("CLP_PREFERENCE_TABLE_VERVSION")};
        private String[] _column2data;

        private CommandPathTableModel() {
        }

        @Override
        public int getRowCount() {
            if (VCSCommandLinePanel.this.getCommandLocations() != null) {
                return VCSCommandLinePanel.this.getCommandLocations().length;
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return URLFileSystem.getPlatformPathName((URL)VCSCommandLinePanel.this.getCommandLocations()[rowIndex]);
            }
            if (columnIndex == 1 && this._column2data != null && this._column2data.length > 0) {
                return this._column2data[rowIndex];
            }
            return null;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.colNames[columnIndex];
        }

        private void setValue(String[] data, int col) {
            if (col == 1) {
                this._column2data = data;
                this.fireTableRowsUpdated(0, this._column2data.length);
            }
        }
    }
}

