/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist;

import java.net.URL;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectContent;
import oracle.ide.net.URLPath;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.vcs.spi.VCSApplicationSystem;
import oracle.jdeveloper.vcs.spi.VCSCancellable;
import oracle.jdeveloper.vcs.util.VCSModelUtils;

public class ChangeListProjectContent
extends VCSApplicationSystem.ContentSetProxy {
    private static final URLPath EMPTY_PATH = new URLPath();
    private final Project _project;
    private ContentSet _contentSet;
    private URL[] _urls;

    @Override
    public ContentSet getContentSet(Project project) {
        if (this._project != project) {
            throw new IllegalStateException();
        }
        return this.getContentSet();
    }

    public ChangeListProjectContent(Project project) {
        this._project = project;
    }

    public URL[] getBaseDirectoryURLs() throws InterruptedException {
        return this.getBaseURLPath().asList().toArray(new URL[0]);
    }

    public URLPath getBaseURLPath() throws InterruptedException {
        return this._project.isOpen() ? this.getContentSet().getAllRootDirs() : EMPTY_PATH;
    }

    public URL[] listURLs(boolean includeDirs, VCSCancellable cancellable) throws InterruptedException {
        if (!this._project.isOpen()) {
            return new URL[0];
        }
        if (this._urls == null) {
            this._urls = VCSModelUtils.listProjectURLs(this._project, cancellable, includeDirs);
        }
        return this._urls;
    }

    @Deprecated
    public boolean canHaveMember(URL url) throws Exception {
        return this._project.isOpen() ? VCSApplicationSystem.getApplicationSystem().canProjectHaveMember(this._project, this, url) : false;
    }

    private final ContentSet getContentSet() {
        if (this._contentSet == null) {
            this._contentSet = this._project.isOpen() ? ProjectContent.getInstance((PropertyStorage)this._project).getAllContents() : null;
        }
        return this._contentSet;
    }
}

