/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellRenderer;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ActionMenuToolButton;
import oracle.ide.controls.ProgressTrackedTask;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.Assert;
import oracle.ideri.util.Product;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;
import oracle.jdeveloper.resource.VCSArb;
import oracle.jdeveloper.vcs.cache.LocalStatusCache;
import oracle.jdeveloper.vcs.cache.StatusCache;
import oracle.jdeveloper.vcs.cache.StatusCacheBridge;
import oracle.jdeveloper.vcs.cache.StatusCacheEvent;
import oracle.jdeveloper.vcs.cache.StatusCacheListener;
import oracle.jdeveloper.vcs.changelist.ChangeListCategorizer;
import oracle.jdeveloper.vcs.changelist.ChangeListCommentsCustomizer;
import oracle.jdeveloper.vcs.changelist.ChangeListContextMenuListener;
import oracle.jdeveloper.vcs.changelist.ChangeListEvent;
import oracle.jdeveloper.vcs.changelist.ChangeListEventQueue;
import oracle.jdeveloper.vcs.changelist.ChangeListLocalCache;
import oracle.jdeveloper.vcs.changelist.ChangeListLocalStatusCache;
import oracle.jdeveloper.vcs.changelist.ChangeListStatus;
import oracle.jdeveloper.vcs.changelist.ChangeListStatusCache;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.spi.VCSEBComponent;
import oracle.jdeveloper.vcs.spi.VCSEBMessage;
import oracle.jdeveloper.vcs.spi.VCSEventBus;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.spi.VCSNodeUpdate;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdeveloper.vcs.spi.VCSOverlayItemProducer;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusCache;
import oracle.jdeveloper.vcs.spi.VCSURLBasedCache;
import oracle.jdeveloper.vcs.spi.VCSURLBasedCacheEvent;
import oracle.jdeveloper.vcs.spi.VCSURLBasedCacheListener;
import oracle.jdeveloper.vcs.util.VCSCollectionUtils;
import oracle.jdeveloper.vcs.util.VCSComponents;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;
import oracle.jdeveloper.vcs.vop.BaseVersionOperationPanel;
import oracle.jdeveloper.vcs.vop.DisplayProperty;
import oracle.jdeveloper.vcs.vop.MutableVersionOperationModel;
import oracle.jdeveloper.vcs.vop.VersionOperationModelEvent;
import oracle.jdeveloper.vcs.vop.VersionOperationModelListener;
import oracle.jdeveloper.vcs.vop.VersionOperationTablePanel;
import oracle.jdevimpl.vcs.util.IdeObserver;
import oracle.jdevimpl.vcs.vop.ClientDisplayProperty;

public class ChangeList
extends JPanel {
    private IdeAction _toggleConflictFilterAction;
    private URLFilter _urlFilter = VCSURLFilters.createFileProtocolFilter();
    private VCSURLBasedCache _legacyStatusCache;
    private StatusCache _policyStatusCache;
    private VCSURLBasedCacheListener _statusURLBasedCacheListener;
    private StatusCacheListener _statusCacheListener;
    private VCSEBComponent _eventBusComponent;
    private EventQueueIdeObserver _projectObserver;
    private BaseVersionOperationPanel _vop = new VersionOperationTablePanel();
    private MutableVersionOperationModel _model;
    private Object[] _statuses;
    private VCSStatus[] _conflictStatuses;
    private boolean _isBusy = false;
    private boolean _shouldDefaultColumnWidths = false;
    private VCSOptionsCustomizer _optionsCustomizer = null;
    private ChangeListEventQueue _eventQueue;
    private VCSOverlayItemProducer _overlayItemProducer;
    private Observer _overlayObserver;
    private ProgressTrackedTask _progressTask;
    private Object[] _filterStatuses;
    private URLFilter _scopeFilter = null;
    private boolean _excludeDirectories = false;
    private Map<VCSHashURL, String> _categoryCache;
    private ChangeListener _categoryCacheListener;
    private final Object _modeId;
    private final DisplayProperty[] _displayProperties = this.createDisplayProperties();
    private ContextMenuListener _contextMenuListener;
    public static final String CHANGELIST_COUNT_PROPERTY = "changeListCount";
    private ChangeListCategorizer _categorizer;
    private String _windowId;
    private boolean _codeReview = false;
    public static final String COMMENTS_VISIBLE_PROPERTY = "optionsVisible";
    public static final String BUSY_PROPERTY = "busy";
    private String _vcsId;
    private Object[] _visableStatus;

    public final void setSystemId(String vcsId) {
        this._vcsId = vcsId;
    }

    public final String getSystemId() {
        return this._vcsId;
    }

    public ChangeList() {
        this((Object)null);
    }

    public ChangeList(Object modeId) {
        this._modeId = modeId;
        this.initializeVersionOperationPanel(this._vop);
        if (this.isMulti()) {
            this.initializeRenderers();
        }
        this.layoutPanel(this._vop);
    }

    protected final void initializeVersionOperationPanel(BaseVersionOperationPanel vop) {
        vop.setBorderLook(1);
        vop.setOptionsResizeable(true);
        vop.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                ChangeList.this.firePropertyChange(pce.getPropertyName(), pce.getOldValue(), pce.getNewValue());
            }
        });
        vop.setSelectOnRightClick(true);
        vop.setOptionsLocation(1);
    }

    protected void layoutPanel(BaseVersionOperationPanel vop) {
        this.setLayout(new BorderLayout(0, 0));
        this.add(vop);
    }

    public void setExcludeDirectories(boolean excludeDirectories) {
        this._excludeDirectories = excludeDirectories;
    }

    public boolean isExcludeDirectories() {
        return this._excludeDirectories;
    }

    public final void refresh(URL[] urls) {
        if (this._eventQueue == null) {
            return;
        }
        ChangeListEvent cle = new ChangeListEvent(0);
        cle.setURLs(urls);
        cle.setUpdate(true);
        this._eventQueue.enqueue(cle);
    }

    Component getFocusComponent() {
        return this._vop != null ? this._vop.getFocusComponent() : null;
    }

    Container getFocusContainer() {
        return this._vop != null ? this._vop : this;
    }

    private void initializeRenderers() {
        NiceTableCellRenderer statusRenderer = new NiceTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, column);
                if (!isSelected) {
                    this.setForeground(UIManager.getColor("controlText"));
                }
                if (value == null) {
                    this.setRendererText("");
                    return this;
                }
                if (value instanceof ChangeListStatus) {
                    ChangeListStatus status = (ChangeListStatus)value;
                    this.setRendererText(status.getChangeListLabel());
                    if (!isSelected && status.isChangeListCellHighlighted()) {
                        this.setForeground(Color.RED);
                    }
                } else {
                    this.setRendererText(value.toString());
                }
                return this;
            }

            private void setRendererText(String text) {
                this.setText(text);
                this.setToolTipText(text);
            }
        };
        NiceTableCellRenderer collectionRenderer = new NiceTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean isFocused, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, isFocused, row, column);
                if (value == null) {
                    this.setRendererText("");
                    return this;
                }
                if (value instanceof Collection) {
                    Collection c = (Collection)value;
                    if (c instanceof List) {
                        Collections.sort((List)c);
                    }
                    StringBuilder itemsBuffer = new StringBuilder();
                    Iterator itr = c.iterator();
                    while (itr.hasNext()) {
                        if (itemsBuffer.length() > 0) {
                            itemsBuffer.append(',');
                        }
                        itemsBuffer.append(itr.next().toString());
                    }
                    String text = itemsBuffer.toString();
                    if (c.size() > 1) {
                        text = MessageFormat.format("({0}) {1}", Integer.toString(c.size()), text);
                    }
                    this.setRendererText(text);
                } else {
                    this.setRendererText(value.toString());
                }
                return this;
            }

            private void setRendererText(String text) {
                this.setText(text);
                this.setToolTipText(text);
            }
        };
        this._vop.setDefaultRenderer(VCSStatus.class, (TableCellRenderer)statusRenderer);
        this._vop.setDefaultRenderer(ChangeListStatus.class, (TableCellRenderer)statusRenderer);
        this._vop.setDefaultRenderer(Collection.class, (TableCellRenderer)collectionRenderer);
    }

    boolean isMulti() {
        return this._modeId != null;
    }

    protected Object getModeId() {
        return this._modeId;
    }

    protected Icon getModeIcon() {
        return null;
    }

    protected String getModeLabel() {
        return this._modeId != null ? this._modeId.toString() : null;
    }

    protected String getModeLongLabel() {
        return this.getModeLabel();
    }

    final void initializeChangeList(ChangeListWindow window) {
        this._windowId = window.getId();
        this.initializeChangeList();
    }

    protected final String getWindowId() {
        return this._windowId;
    }

    protected void initializeChangeList() {
    }

    protected void addToolbarActions(ChangeListWindow window, Toolbar toolbar) {
        toolbar.removeAll();
        toolbar.add((ToggleAction)window.createLocalAction(51));
        this.addCodeReviewToolbarAction(window, toolbar);
    }

    protected void addCodeReviewToolbarAction(ChangeListWindow window, Toolbar toolbar) {
        if (this.isCodeReview()) {
            toolbar.addSeparator();
            toolbar.add((ToggleAction)window.getLocalAction(Ide.findOrCreateCmdID((String)"CREATE_CODE_REVIEW_ID")));
        }
    }

    protected DisplayProperty[] createDisplayProperties() {
        return null;
    }

    protected Object getModelValue(URL url, DisplayProperty displayProperty) throws Exception {
        if (ChangeListStatus.class.isAssignableFrom(displayProperty.getType()) || VCSStatus.class.isAssignableFrom(displayProperty.getType())) {
            return url != null ? this.getStatus(url) : null;
        }
        return null;
    }

    private final Object getStatus(URL url) throws Exception {
        if (this.getPolicyStatusCache() != null) {
            return this.getPolicyStatusCache().get(url);
        }
        if (this.getStatusCache() != null) {
            return this.getStatusCache().getValue(url);
        }
        return null;
    }

    protected String getStatusMessage(int count) {
        return "";
    }

    protected String getBusyStatusMessage() {
        return "";
    }

    protected void addContextMenuListeners(ContextMenu contextMenu) {
        this._contextMenuListener = new ChangeListContextMenuListener(this);
        contextMenu.addContextMenuListener(this._contextMenuListener);
    }

    protected void removeContextMenuListeners(ContextMenu contextMenu) {
        contextMenu.removeContextMenuListener(this._contextMenuListener);
        this._contextMenuListener = null;
    }

    protected void setProgressTask(ProgressTrackedTask progressTask) {
        this._progressTask = progressTask;
    }

    protected ProgressTrackedTask getProgressTask() {
        return this._progressTask;
    }

    protected boolean isProgressTracked() {
        return true;
    }

    public void setItemURLFilter(URLFilter urlFilter) {
        this._urlFilter = urlFilter;
    }

    public URLFilter getItemURLFilter() {
        return this._urlFilter;
    }

    public void setOverlayStatusCache(VCSStatusCache statusCache) {
        this.setOverlayItemProducer(new VCSOverlayItemProducer(this._vcsId, statusCache));
    }

    public void setOverlayItemProducer(VCSOverlayItemProducer overlayItemProducer) {
        this._overlayItemProducer = overlayItemProducer;
        if (overlayItemProducer == null) {
            this._overlayObserver = null;
            return;
        }
        this._overlayObserver = new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if (ChangeList.this._eventQueue == null) {
                    return;
                }
                ChangeListEvent cle = new ChangeListEvent(1);
                if (arg instanceof URL[]) {
                    cle.setURLs((URL[])arg);
                } else {
                    cle.setStatusCacheEvent((StatusCacheEvent)arg);
                }
                ChangeList.this._eventQueue.enqueue(cle);
            }
        };
    }

    public VCSStatusCache getOverlayStatusCache() {
        return this._overlayItemProducer != null ? this._overlayItemProducer.getStatusCache() : null;
    }

    public VCSOverlayItemProducer getOverlayItemProducer() {
        return this._overlayItemProducer;
    }

    public ChangeListEventQueue getEventQueue() {
        return this._eventQueue;
    }

    public boolean isFocusInOptions() {
        if (this._optionsCustomizer instanceof ChangeListCommentsCustomizer) {
            return ((ChangeListCommentsCustomizer)this._optionsCustomizer).hasFocus();
        }
        return false;
    }

    void requestFocusInChangeList() {
        this._vop.getFocusComponent().requestFocus();
    }

    void requestFocusInOptions() {
        if (this._optionsCustomizer instanceof ChangeListCommentsCustomizer) {
            ((ChangeListCommentsCustomizer)this._optionsCustomizer).requestFocus();
        }
    }

    public boolean isItemAtPosition(Point p) {
        return this._vop.isItemAtPosition(p);
    }

    @Override
    public void addMouseListener(MouseListener ml) {
        this._vop.addMouseListener(ml);
        if (this._optionsCustomizer instanceof ChangeListCommentsCustomizer) {
            ((ChangeListCommentsCustomizer)this._optionsCustomizer).addMouseListener(ml);
        }
    }

    @Override
    public void removeMouseListener(MouseListener ml) {
        this._vop.removeMouseListener(ml);
        if (this._optionsCustomizer instanceof ChangeListCommentsCustomizer) {
            ((ChangeListCommentsCustomizer)this._optionsCustomizer).removeMouseListener(ml);
        }
    }

    public Element[] getSelection() {
        return this._vop.getSelection();
    }

    protected void configureContext(Context context) {
    }

    public final Element[] getElements() {
        Element[] elements = new Element[this.getModel().getCount()];
        for (int i = 0; i < this.getModel().getCount(); ++i) {
            elements[i] = (Element)this.getModel().getItem(i);
        }
        return elements;
    }

    public final boolean isEmpty() {
        return this.getModel().getCount() == 0;
    }

    public final int getCount() {
        return this._model != null ? this._model.getCount() : 0;
    }

    public void addSelectionListener(ChangeListener listener) {
        this._vop.addSelectionListener(listener);
    }

    public void removeSelectionListener(ChangeListener listener) {
        this._vop.removeSelectionListener(listener);
    }

    public void selectAll() {
        this._vop.selectAll();
    }

    protected void setBorderLook(int vopLookConstant) {
        this._vop.setBorderLook(vopLookConstant);
    }

    public void setOptionsCustomizer(VCSOptionsCustomizer c) {
        c.getComponent().setVisible(false);
        this._vop.setOptionsComponent(c.getComponent());
        this._optionsCustomizer = c;
    }

    public final VCSOptionsCustomizer getOptionsCustomizer() {
        return this._optionsCustomizer;
    }

    public void setOptionsVisible(boolean isVisible) {
        this._vop.setOptionsVisible(isVisible);
    }

    public boolean isOptionsVisible() {
        return this._vop.isOptionsVisible();
    }

    void depersistVisualSettings(String persistenceKey) {
        Object settings = this._vop.depersistVisualSettings(persistenceKey);
        if (settings == null) {
            this._shouldDefaultColumnWidths = true;
        }
    }

    void persistVisualSettings(String persistenceKey) {
        this._vop.persistVisualSettings(persistenceKey);
    }

    @Deprecated
    public final void setStatusCache(VCSStatusCache statusCache) {
        this.setStatusCache((VCSURLBasedCache)statusCache);
    }

    @Deprecated
    public final void setStatusCache(ChangeListStatusCache statusCache) {
        this.setStatusCache((VCSURLBasedCache)statusCache);
    }

    @Deprecated
    protected final void setStatusCache(VCSURLBasedCache statusCache) {
        this.setStatusCache(statusCache, true);
    }

    private final void setStatusCache(VCSURLBasedCache statusCache, boolean localize) {
        this._legacyStatusCache = localize && statusCache instanceof VCSStatusCache && !statusCache.isLocalCache() && !(statusCache instanceof ChangeListLocalCache) ? statusCache.newLocalCache() : statusCache;
        this.initializeModel();
    }

    public final void setPolicyStatusCache(StatusCache statusCache) {
        this.setPolicyStatusCache(statusCache, true);
    }

    public final void setPolicyStatusCache(StatusCache statusCache, boolean localize) {
        this._policyStatusCache = localize ? statusCache.newLocalCache() : statusCache;
        this.initializeModel();
    }

    public final void setStatusCacheBridge(StatusCacheBridge statusCache) {
        this.setStatusCacheBridge(statusCache, true);
    }

    public final void setStatusCacheBridge(StatusCacheBridge statusCache, boolean localize) {
        if (statusCache instanceof VCSURLBasedCache) {
            this.setStatusCache((VCSURLBasedCache)((Object)statusCache), localize);
        }
        if (statusCache instanceof StatusCache) {
            this.setPolicyStatusCache((StatusCache)statusCache, localize);
        }
    }

    public final StatusCacheBridge getStatusCacheBridge() {
        if (this._legacyStatusCache instanceof StatusCacheBridge) {
            return (StatusCacheBridge)((Object)this._legacyStatusCache);
        }
        return this._policyStatusCache;
    }

    protected final void initializeModel() {
        this._model = this.createModel();
        this._model.addVersionOperationModelListener(new VersionOperationModelListener(){
            private boolean _lock = false;
            private boolean _isEmpty = ChangeList.access$200(ChangeList.this).getCount() == 0;

            @Override
            public void itemsChanged(VersionOperationModelEvent event) {
                if (this._lock) {
                    return;
                }
                try {
                    this._lock = true;
                    ChangeList.this.updateProperties(event.getStart(), event.getEnd());
                }
                finally {
                    this._lock = false;
                }
            }

            @Override
            public void itemsInserted(VersionOperationModelEvent event) {
                if (this._lock) {
                    return;
                }
                try {
                    this._lock = true;
                    ChangeList.this.insertProperties(event.getStart(), event.getEnd());
                    if (ChangeList.this._model.getCount() > 0 && this._isEmpty) {
                        ChangeList.this.defaultOptionsOnInitialInsert();
                    }
                    if (ChangeList.this._model.getCount() == 0 && !event.isChanging()) {
                        ChangeList.this.clearOptions();
                    }
                    this._lock = false;
                }
                catch (Throwable throwable) {
                    this._lock = false;
                    this._isEmpty = ChangeList.this._model.getCount() == 0;
                    throw throwable;
                }
                this._isEmpty = ChangeList.this._model.getCount() == 0;
            }

            @Override
            public void itemsRemoved(VersionOperationModelEvent event) {
                if (this._lock) {
                    return;
                }
                try {
                    this._lock = true;
                    if (ChangeList.this._model.getCount() == 0 && !this._isEmpty && !event.isChanging()) {
                        ChangeList.this.clearOptions();
                    }
                    this._lock = false;
                }
                catch (Throwable throwable) {
                    this._lock = false;
                    this._isEmpty = ChangeList.this._model.getCount() == 0;
                    throw throwable;
                }
                this._isEmpty = ChangeList.this._model.getCount() == 0;
            }

            @Override
            public void completenessChanged(VersionOperationModelEvent event) {
            }
        });
        this.installModel(this._model);
    }

    protected void installModel(MutableVersionOperationModel model) {
        this._vop.installModel(model);
        this._vop.setColumnAutoResizeMode(1);
        if (!this.isMulti()) {
            return;
        }
        model.addVersionOperationModelListener(new VersionOperationModelListener(){
            {
                ChangeList.this.putClientProperty(ChangeList.CHANGELIST_COUNT_PROPERTY, new Integer(0));
            }

            @Override
            public void itemsChanged(VersionOperationModelEvent event) {
                this.modelChanged(event);
            }

            @Override
            public void itemsInserted(VersionOperationModelEvent event) {
                this.modelChanged(event);
            }

            @Override
            public void itemsRemoved(VersionOperationModelEvent event) {
                this.modelChanged(event);
            }

            @Override
            public void completenessChanged(VersionOperationModelEvent event) {
                this.modelChanged(event);
            }

            private void modelChanged(VersionOperationModelEvent event) {
                int oldCount = (Integer)ChangeList.this.getClientProperty(ChangeList.CHANGELIST_COUNT_PROPERTY);
                int newCount = ChangeList.this.getCount();
                if (newCount == oldCount) {
                    return;
                }
                if (event.isChanging()) {
                    return;
                }
                ChangeList.this.putClientProperty(ChangeList.CHANGELIST_COUNT_PROPERTY, new Integer(newCount));
                ChangeList.this.firePropertyChange(ChangeList.CHANGELIST_COUNT_PROPERTY, oldCount, newCount);
            }
        });
    }

    protected ChangeListCategorizer createCategorizer() {
        return null;
    }

    final ChangeListCategorizer getCategorizer() {
        if (this._categorizer == null) {
            this._categorizer = this.createCategorizer();
        }
        return this._categorizer;
    }

    @Deprecated
    public VCSURLBasedCache getStatusCache() {
        return this._legacyStatusCache;
    }

    public StatusCache getPolicyStatusCache() {
        return this._policyStatusCache;
    }

    public final void setConflictStatuses(VCSStatus[] statuses) {
        this._conflictStatuses = statuses;
    }

    public final void setVisibleStatuses(VCSStatus[] statuses) {
        this.setVisibleStatuses((Object[])statuses);
    }

    public final void setVisibleStatuses(ChangeListStatus[] statuses) {
        this.setVisibleStatuses((Object[])statuses);
    }

    public void setConflictFilterStatus(boolean filter) {
        if (filter) {
            if (this._visableStatus == null) {
                this._visableStatus = this._statuses;
            }
            this.setVisibleStatuses(this._conflictStatuses);
        } else if (this._visableStatus.length > 0) {
            this.setVisibleStatuses(this._visableStatus);
        }
    }

    private final void setVisibleStatuses(Object[] statuses) {
        this._statuses = statuses;
        if (this.isStarted()) {
            this._refresh();
        }
    }

    Object[] getVisibleStatuses() {
        return this._statuses;
    }

    public void refilter(VCSStatus[] filterStatuses) {
        this.setFilterStatuses(filterStatuses);
    }

    public void setFilterStatuses(final VCSStatus[] filterStatuses) {
        if (this._eventQueue == null) {
            throw new IllegalStateException();
        }
        ChangeListEvent cle = new ChangeListEvent(2);
        cle.setRunnable(new Runnable(){

            @Override
            public void run() {
                ChangeList.this.setFilterStatusesImpl(filterStatuses);
            }
        });
        this._eventQueue.enqueue(cle);
        this._refresh();
    }

    protected final void updateCategoryCache() {
        if (this._categorizer != null) {
            this._refresh();
        }
    }

    void setFilterStatusesImpl(Object[] filterStatuses) {
        this._filterStatuses = filterStatuses;
    }

    public Object[] getFilterStatuses() {
        return this._filterStatuses;
    }

    public void setScopeFilter(final URLFilter scopeFilter) {
        if (Boolean.getBoolean("ide.vcs.noapplications") || Product.isRaptor()) {
            return;
        }
        if (this._scopeFilter != null && scopeFilter != null && this._scopeFilter.equals((Object)scopeFilter)) {
            this.setScopeFilterImpl(scopeFilter);
            return;
        }
        if (this._eventQueue == null) {
            this.setScopeFilterImpl(scopeFilter);
            return;
        }
        ChangeListEvent cle = new ChangeListEvent(2);
        cle.setRunnable(new Runnable(){

            @Override
            public void run() {
                ChangeList.this.setScopeFilterImpl(scopeFilter);
            }
        });
        this._eventQueue.enqueue(cle);
        this._refresh();
    }

    private void setScopeFilterImpl(URLFilter scopeFilter) {
        this._scopeFilter = scopeFilter;
    }

    public URLFilter getScopeFilter() {
        return this._scopeFilter;
    }

    public final boolean isBusy() {
        return this._isBusy;
    }

    public final void setBusy(boolean isBusy) {
        if (this._isBusy != isBusy) {
            this._isBusy = isBusy;
            this.firePropertyChange(BUSY_PROPERTY, !isBusy, isBusy);
        }
    }

    protected boolean isStarted() {
        return this._statusURLBasedCacheListener != null || this._statusCacheListener != null;
    }

    public final void stop() {
        if (this.isStarted()) {
            this.stopImpl();
        }
    }

    protected void stopImpl() {
        this._progressTask = null;
        if (this.getStatusCache() != null) {
            this.getStatusCache().removeCacheListener(this._statusURLBasedCacheListener);
        }
        this._statusURLBasedCacheListener = null;
        if (this.getPolicyStatusCache() != null) {
            this.getPolicyStatusCache().removeCacheListener(this._statusCacheListener);
        }
        this._statusCacheListener = null;
        if (this._eventBusComponent != null) {
            VCSEventBus.removeFromBus(this._eventBusComponent);
        }
        this._eventBusComponent = null;
        if (this._projectObserver != null) {
            this._projectObserver.stopObserving();
        }
        this._projectObserver = null;
        if (this._model != null) {
            this._model.replace(Collections.EMPTY_LIST);
        }
        if (this._overlayItemProducer != null) {
            this._overlayItemProducer.getObservable().deleteObserver(this._overlayObserver);
        }
        if (this._eventQueue != null) {
            this._eventQueue.stop();
        }
        this._eventQueue = null;
        if (this._legacyStatusCache instanceof ChangeListLocalStatusCache) {
            ((ChangeListLocalStatusCache)this._legacyStatusCache).detachGlobalCache();
        }
        if (this._legacyStatusCache != null) {
            this._legacyStatusCache.dispose();
        }
        this._legacyStatusCache = null;
        if (this._policyStatusCache instanceof LocalStatusCache) {
            ((LocalStatusCache)this._policyStatusCache).dispose();
        }
        this._policyStatusCache = null;
    }

    public final void start() {
        if (!this.isStarted()) {
            this.startImpl();
        }
    }

    protected void startImpl() {
        this._isBusy = false;
        this._eventQueue = this.createEventQueue();
        if (this._eventQueue != null) {
            this._eventQueue.setSystemId(this._vcsId);
            this.initializeEventQueue(this._eventQueue);
            this._eventQueue.start();
            this._projectObserver = new EventQueueIdeObserver();
            this._projectObserver.startObserving(this._eventQueue);
            if (this.getStatusCache() != null) {
                this._statusURLBasedCacheListener = new VCSURLBasedCacheListener(){

                    @Override
                    public void valuesCleared(VCSURLBasedCacheEvent e) {
                        ChangeListEvent cle = new ChangeListEvent(0);
                        cle.setURLs(e.getURLs());
                        cle.setUpdate(true);
                        ChangeList.this._eventQueue.enqueue(cle);
                    }
                };
                this.getStatusCache().addCacheListener(this._statusURLBasedCacheListener);
            }
            if (this.getPolicyStatusCache() != null) {
                this._statusCacheListener = new StatusCacheListener(){

                    @Override
                    public final void statusesCleared(StatusCacheEvent e) {
                        if (e.isInvalidate()) {
                            ChangeList.this._refresh();
                            return;
                        }
                        ChangeListEvent cle = new ChangeListEvent(0);
                        cle.setStatusCacheEvent(e);
                        cle.setUpdate(true);
                        ChangeList.this._eventQueue.enqueue(cle);
                    }
                };
                this.getPolicyStatusCache().addCacheListener(this._statusCacheListener);
            }
            this._eventBusComponent = new VCSEBComponent(){

                @Override
                public final void handleMessage(VCSEBMessage message) {
                    VCSNodeUpdate update;
                    if (message instanceof VCSNodeUpdate && (update = (VCSNodeUpdate)message).getWhat() == VCSNodeUpdate.RENAMED) {
                        ChangeListEvent cle = new ChangeListEvent(0);
                        cle.setURLs(new URL[]{update.getOldURL(), update.getNode().getURL()});
                        ChangeList.this._eventQueue.enqueue(cle);
                    }
                }
            };
            VCSEventBus.addToBus(this._eventBusComponent);
        }
        this.refresh();
        if (this._overlayItemProducer != null) {
            this._overlayItemProducer.getObservable().addObserver(this._overlayObserver);
        }
        if (this.getStatusCache() instanceof ChangeListLocalStatusCache) {
            ((ChangeListLocalStatusCache)this.getStatusCache()).attachGlobalCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this._eventQueue == null) {
            return;
        }
        ChangeListEventQueue changeListEventQueue = this._eventQueue;
        synchronized (changeListEventQueue) {
            ChangeListEvent cle = new ChangeListEvent(2);
            cle.setRunnable(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    StatusCache policyStatusCache;
                    VCSURLBasedCache legacyStatusCache = ChangeList.this.getStatusCache();
                    if (legacyStatusCache != null) {
                        VCSURLBasedCache vCSURLBasedCache = legacyStatusCache;
                        synchronized (vCSURLBasedCache) {
                            if (ChangeList.this._statusURLBasedCacheListener != null) {
                                legacyStatusCache.removeCacheListener(ChangeList.this._statusURLBasedCacheListener);
                            }
                            legacyStatusCache.clearValues();
                            if (ChangeList.this._statusURLBasedCacheListener != null) {
                                legacyStatusCache.addCacheListener(ChangeList.this._statusURLBasedCacheListener);
                            }
                        }
                    }
                    if ((policyStatusCache = ChangeList.this.getPolicyStatusCache()) != null) {
                        policyStatusCache.getInvalidationLock().writeLock().lock();
                        try {
                            if (ChangeList.this._statusCacheListener != null) {
                                policyStatusCache.removeCacheListener(ChangeList.this._statusCacheListener);
                            }
                            policyStatusCache.invalidate();
                            if (ChangeList.this._statusCacheListener != null) {
                                policyStatusCache.addCacheListener(ChangeList.this._statusCacheListener);
                            }
                        }
                        finally {
                            policyStatusCache.getInvalidationLock().writeLock().unlock();
                        }
                        ((LocalStatusCache)policyStatusCache).unshare();
                    }
                }
            });
            this._eventQueue.enqueue(cle);
            this._refresh();
            cle = new ChangeListEvent(2);
            cle.setRunnable(new Runnable(){

                @Override
                public void run() {
                    StatusCache policyStatusCache = ChangeList.this.getPolicyStatusCache();
                    if (policyStatusCache != null) {
                        ((LocalStatusCache)policyStatusCache).reshare();
                    }
                }
            });
            this._eventQueue.enqueue(cle);
        }
    }

    void refreshImpl() {
        this._refresh();
    }

    private void _refresh() {
        if (this._eventQueue == null) {
            return;
        }
        this._eventQueue.curtail();
        ChangeListEvent cle = new ChangeListEvent(0);
        cle.setWorkspaces(VCSModelUtils.findCachedWorkspaces());
        cle.setProjects(VCSModelUtils.findCachedProjects());
        cle.setReplace(true);
        this._eventQueue.enqueue(cle);
    }

    protected ChangeListEventQueue createEventQueue() {
        return new ChangeListEventQueue(this);
    }

    protected void initializeEventQueue(ChangeListEventQueue eventQueue) {
    }

    protected MutableVersionOperationModel getModel() {
        return this._model;
    }

    protected MutableVersionOperationModel createModel() {
        ClientDisplayProperty locationProperty = new ClientDisplayProperty(VCSArb.get("VOP_LOCATION"), null, 2, "C:\\some\\example\\path\\that\\is\\reasonably\\long\\now\\longer\\see\\bug\\9120153", null, String.class, 600);
        return VCSComponents.createFileListerModel(new ArrayList(), locationProperty, this._displayProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertProperties(int firstItem, int lastItem) {
        this.updateDisplayProperties(firstItem, lastItem);
        for (int i = firstItem; i <= lastItem; ++i) {
            Displayable d = this._model.getItem(i);
            if (!(d instanceof Locatable)) continue;
            URL url = ((Locatable)d).getURL();
            String location = URLFileSystem.getPlatformPathName((URL)URLFileSystem.getParent((URL)url));
            this._model.setProperty(i, this._model.getProperties()[0], location);
        }
        if (this._shouldDefaultColumnWidths) {
            try {
                this._vop.autoSizeColumnsToFit();
            }
            finally {
                this._shouldDefaultColumnWidths = false;
            }
        }
    }

    protected void updateProperties(int firstItem, int lastItem) {
        this.updateDisplayProperties(firstItem, lastItem);
    }

    private void updateDisplayProperties(int firstItem, int lastItem) {
        if (this._displayProperties == null) {
            return;
        }
        for (int i = firstItem; i <= lastItem; ++i) {
            this.updateDisplayProperties(i);
        }
    }

    private void updateDisplayProperties(int itemIndex) {
        Displayable item = this.getModel().getItem(itemIndex);
        if (!(item instanceof Locatable)) {
            return;
        }
        URL url = ((Locatable)item).getURL();
        if (url == null) {
            return;
        }
        try {
            for (int i = 0; this._displayProperties != null && i < this._displayProperties.length; ++i) {
                Object displayValue = this.getModelValue(url, this._displayProperties[i]);
                this.getModel().setProperty(itemIndex, this._displayProperties[i], displayValue);
            }
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    protected void defaultOptionsOnInitialInsert() {
    }

    protected void clearOptions() {
        if (this.getOptionsCustomizer() instanceof ChangeListCommentsCustomizer) {
            ((ChangeListCommentsCustomizer)this.getOptionsCustomizer()).clear();
        }
    }

    protected String getTabToggleKey() {
        return null;
    }

    final void setCategoryCacheListener(ChangeListener l) {
        this._categoryCacheListener = l;
    }

    public final Map<VCSHashURL, String> getCategoryCache() {
        if (this._categoryCache == null) {
            this._categoryCache = new HashMap<VCSHashURL, String>();
        }
        return Collections.unmodifiableMap(this._categoryCache);
    }

    protected final void setCategoryCache(Map<VCSHashURL, String> categoryCache) {
        if (this._categoryCache != null && this._categoryCache.equals(categoryCache)) {
            return;
        }
        this.setCategoryCacheImpl(categoryCache);
        this.fireCategoryCacheChanged();
    }

    protected void setCategoryCacheImpl(Map<VCSHashURL, String> categoryCache) {
        this._categoryCache = categoryCache;
        this._vop.setCategoryCache(categoryCache);
    }

    private final void fireCategoryCacheChanged() {
        if (this._categoryCacheListener != null) {
            this._categoryCacheListener.stateChanged(new ChangeEvent(this));
        }
    }

    protected ChangeListWindow.ScopeFilter createCategoryScopeFilter(String category) {
        return null;
    }

    public void setCodeReview(boolean codeReview) {
        this._codeReview = codeReview;
    }

    public boolean isCodeReview() {
        return this._codeReview;
    }

    public final ToggleAction getToggleConflictFilterAction(ChangeListWindow window) {
        if (this._toggleConflictFilterAction == null) {
            this._toggleConflictFilterAction = window.createLocalAction(ChangeListWindow.TOGGLE_CONFLICT_FILTER_COMMAND_ID);
        }
        return this._toggleConflictFilterAction;
    }

    protected String[] getPreferencesPath() {
        return null;
    }

    protected void addRefreshToolbarAction(ChangeListWindow window, Toolbar toolbar) {
        final IdeAction refreshAction = window.createLocalAction(51);
        ActionMenuToolButton refreshToolButton = new ActionMenuToolButton((Action)refreshAction);
        final RefreshAction localRefreshAction = new RefreshAction();
        refreshAction.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if (pce.getPropertyName().equals("enabled")) {
                    localRefreshAction.setEnabled(refreshAction.isEnabled());
                }
            }
        });
        refreshAction.updateAction();
        localRefreshAction.setEnabled(refreshAction.isEnabled());
        refreshToolButton.setMenuActions(new Action[]{localRefreshAction, null, window.getRefreshAllAction()});
        toolbar.add((Component)refreshToolButton);
    }

    protected final BaseVersionOperationPanel getVersionOperationPanel() {
        return this._vop;
    }

    private class RefreshAction
    extends AbstractAction {
        RefreshAction() {
            super(StringUtils.stripMnemonic((String)VCSArb.format("CHANGELIST_REFRESH_TEMPLATE", ChangeList.this.getModeLongLabel())));
            this.putValue("MnemonicKey", StringUtils.getMnemonicKeyCode((String)VCSArb.get("CHANGELIST_REFRESH_TEMPLATE")));
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            ChangeList.this.refresh();
        }
    }

    private class EventQueueIdeObserver
    extends IdeObserver {
        private ChangeListEventQueue _eventQueue;

        private EventQueueIdeObserver() {
        }

        ChangeListEventQueue getEventQueue() {
            return this._eventQueue;
        }

        public void startObserving(ChangeListEventQueue eventQueue) {
            this._eventQueue = eventQueue;
            super.startObserving();
        }

        @Override
        public void stopObserving() {
            super.stopObserving();
            this._eventQueue = null;
        }

        @Override
        protected void updateImpl(Object source, UpdateMessage updateMessage) {
            ChangeListEvent cle;
            int msgId = updateMessage.getMessageID();
            if (source == Ide.getWorkspaces() && msgId == UpdateMessage.CHILD_ADDED) {
                cle = new ChangeListEvent(0);
                cle.setWorkspaces((Workspace[])VCSCollectionUtils.toArrayType(updateMessage.getAddObjects(), Workspace.class));
                this._eventQueue.enqueue(cle);
            }
            if (source instanceof Workspace && msgId == UpdateMessage.OBJECT_OPENED) {
                cle = new ChangeListEvent(0);
                cle.setWorkspaces(new Workspace[]{(Workspace)source});
                this._eventQueue.enqueue(cle);
            }
            if (source instanceof Project) {
                if (msgId == UpdateMessage.CHILD_REMOVED) {
                    cle = new ChangeListEvent(0);
                    cle.setObjects(updateMessage.getRemoveObjects().toArray());
                    this._eventQueue.enqueue(cle);
                }
                if (msgId == UpdateMessage.CHILD_ADDED) {
                    cle = new ChangeListEvent(0);
                    cle.setObjects(updateMessage.getAddObjects().toArray());
                    this._eventQueue.enqueue(cle);
                }
                if (msgId == UpdateMessage.OBJECT_OPENED) {
                    cle = new ChangeListEvent(0);
                    cle.setProjects(new Project[]{(Project)source});
                    this._eventQueue.enqueue(cle);
                }
                if (msgId == UpdateMessage.PROPERTY_SET && updateMessage.containsProperty("contentProvidersPath")) {
                    ChangeList.this._refresh();
                }
            }
        }
    }
}

