/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.cache;

import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import oracle.jdeveloper.vcs.cache.LocalStatusCache;
import oracle.jdeveloper.vcs.cache.StatusCache;

public abstract class SynchronizedStatusCache<V>
extends StatusCache<V> {
    private final Lock _lock = new ReentrantLock();

    public SynchronizedStatusCache(Class<V> valueType) {
        super(valueType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T> T maybeCallSynchronized(Callable<T> c, boolean blocking) throws Exception {
        if (blocking) {
            this._lock.lock();
        } else if (!this._lock.tryLock()) {
            return null;
        }
        try {
            T t = c.call();
            return t;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public final LocalStatusCache<V> newLocalCache() {
        return new LocalStatusCache(this._valueType, this);
    }
}

