/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.merge;

import java.util.ArrayList;
import java.util.Collections;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.util.Assert;
import oracle.javatools.compare.CompareAlgorithm;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareFailedException;
import oracle.javatools.compare.CompareMergeAlgorithm;
import oracle.javatools.compare.CompareModel;
import oracle.javatools.compare.CompareType;
import oracle.jdeveloper.compare.CompareManager;
import oracle.jdeveloper.compare.CompareMethod;
import oracle.jdeveloper.compare.FileNotComparableException;
import oracle.jdeveloper.compare.IdeCompareContributor;
import oracle.jdevimpl.compare.CompareInvocation;
import oracle.jdevimpl.compare.CompareUtil;

public class MergeEngine {
    private static final MergeEngine _instance = new MergeEngine();
    private CompareContributor _contributor1;
    private CompareContributor _contributor2;
    private CompareContributor _contributorA;
    private CompareInvocation _invocationContext;

    private static final CompareInvocation createInvocationContext(Element contextNode, CompareContributor left, CompareContributor right, CompareContributor ancestor) {
        ArrayList<CompareMethod> compareMethods = new ArrayList<CompareMethod>();
        for (CompareMethod compareMethod : CompareManager.getCompareManager().getCompareMethods()) {
            if (!compareMethod.canMerge(contextNode, left, right, ancestor)) continue;
            compareMethods.add(compareMethod);
        }
        if (compareMethods.isEmpty()) {
            Assert.printStackTrace((Throwable)new IllegalStateException());
            return new CompareInvocation(contextNode, Collections.singleton(CompareUtil.getCompareMethodForType((CompareType)CompareType.TEXT)));
        }
        return new CompareInvocation(contextNode, compareMethods);
    }

    public static final MergeEngine getInstance() {
        return _instance;
    }

    @Deprecated
    public void prepareMerge(CompareContributor contributor1, CompareContributor contributor2, CompareContributor contributorA) {
        this.prepareMerge(contributor1, contributor2, contributorA, null);
    }

    public void prepareMerge(CompareContributor contributor1, CompareContributor contributor2, CompareContributor contributorA, Element contextNode) {
        this._contributor1 = contributor1;
        this._contributor2 = contributor2;
        this._contributorA = contributorA;
        this._invocationContext = MergeEngine.createInvocationContext(contextNode, contributor1, contributor2, contributorA);
    }

    public CompareModel executeMerge() throws CompareFailedException {
        return this.createMergeModel(this._contributor1, this._contributor2, this._contributorA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompareModel createMergeModel(CompareContributor contributor1, CompareContributor contributor2, CompareContributor contributorA) throws CompareFailedException {
        CompareMethod compareMethod = this._invocationContext.getCurrentMethod();
        if (compareMethod == null) {
            throw new FileNotComparableException();
        }
        compareMethod.processOptions();
        try {
            CompareAlgorithm compareAlgorithm;
            Element contextNode = this._invocationContext.getContextNode();
            if (contextNode instanceof Node) {
                Node contextNodeAsNode = (Node)contextNode;
                if (contributor1 instanceof IdeCompareContributor) {
                    ((IdeCompareContributor)contributor1).setContextNode(contextNodeAsNode);
                }
                if (contributor2 instanceof IdeCompareContributor) {
                    ((IdeCompareContributor)contributor2).setContextNode(contextNodeAsNode);
                }
                if (contributorA instanceof IdeCompareContributor) {
                    ((IdeCompareContributor)contributorA).setContextNode(contextNodeAsNode);
                }
            }
            if ((compareAlgorithm = this._invocationContext.getCurrentAlgorithm()) != null) {
                CompareModel compareModel = ((CompareMergeAlgorithm)compareAlgorithm).merge(contributor1, contributor2, contributorA);
                if (compareModel != null) {
                    compareModel.setType(compareMethod.getCompareType());
                }
                CompareModel compareModel2 = compareModel;
                return compareModel2;
            }
            if (this._invocationContext.isCanceled()) {
                CompareModel compareModel = null;
                return compareModel;
            }
            try {
                throw new IllegalArgumentException("cannot create merge model with " + contributor1 + " and " + contributor2);
            }
            catch (CompareFailedException cfe) {
                if (this._invocationContext.hasMoreMethods()) {
                    this._invocationContext.nextMethod();
                    CompareModel compareModel = this.createMergeModel(contributor1, contributor2, contributorA);
                    return compareModel;
                }
                throw cfe;
            }
        }
        finally {
            MergeEngine mergeEngine = this;
            synchronized (mergeEngine) {
                this._contributor1 = null;
                this._contributor2 = null;
                this._contributorA = null;
                this._invocationContext = null;
            }
        }
    }

    public synchronized boolean isCancelable() {
        return this._invocationContext != null && this._invocationContext.isCancelable();
    }

    public synchronized boolean isCanceled() {
        return this._invocationContext != null && this._invocationContext.isCanceled();
    }

    public synchronized void cancel() {
        if (this._invocationContext != null) {
            this._invocationContext.cancel();
        }
    }
}

