/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.vm;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import oracle.aurora.security.JServerPermission;
import oracle.aurora.vm.EnvironmentSpecific;
import oracle.aurora.vm.IUHandle;
import sun.misc.Launcher;

public final class OracleRuntime {
    public static final int WINDOWS_PORT = 1;
    public static final int LINUX_PORT = 2;
    private static int platform = 0;
    public static final int EXIT_CALL_WHEN_MAIN_THREAD_TERMINATES = 1;
    public static final int EXIT_CALL_WHEN_ALL_NON_DAEMON_THREADS_TERMINATE = 0;
    public static final int EXIT_CALL_WHEN_ALL_THREADS_TERMINATE = 2;
    public static final byte minNewspaceTenurePolicy = 0;
    public static final byte defaultNewspaceTenurePolicy = 0;
    public static final byte maxNewspaceTenurePolicy = 0;
    public static final int doSGCEndOfCall = 2;
    public static final int trackingSGCThreshold = 1;
    public static final int useSGCThreshold = 0;
    public static final int doNotSGCEndOfCall = -1;
    public static final int call = 0;
    public static final int session = 1;
    public static final int permanent = 2;
    private static final int SOFTREFPOLICY_MIN = 0;
    public static final int SOFTREFPOLICY_AGE = 0;
    public static final int SOFTREFPOLICY_CALLS = 1;
    private static final int SOFTREFPOLICY_MAX = 1;
    private static int softRefPolicy = 1;
    private static long softRefPolicyValue = 3L;
    public static final int INTERPRETED_METHOD = 1;
    public static final int SYSTEM_NATIVE_METHOD = 2;
    public static final int JNI_METHOD = 3;
    public static final int NCOMP_METHOD = 4;
    public static final int JIT_METHOD = 5;
    public static final int ABSTRACT_METHOD = 6;

    private OracleRuntime() {
    }

    public static void exitSession(int status) {
        OracleRuntime.exitSession_(status);
    }

    private static native void exitSession_(int var0);

    public static void exitCall(int status) {
        OracleRuntime.exitCall_(status);
    }

    private static native void exitCall_(int var0);

    public static int getPlatform() {
        if (platform == 0) {
            String file_separator = System.getProperty("file.separator");
            if (file_separator == null) {
                throw new NullPointerException();
            }
            char ch = file_separator.charAt(0);
            if (ch == '\\') {
                platform = 1;
            }
            if (ch == '/') {
                platform = 2;
            }
        }
        return platform;
    }

    public static native boolean inEndOfCall();

    public static native boolean definePackage(String var0);

    public static void setCallExitPolicy(int policy) {
        OracleRuntime.setCallExitPolicy_(policy);
    }

    private static native void setCallExitPolicy_(int var0);

    public static int getCallExitPolicy() {
        return OracleRuntime.getCallExitPolicy_();
    }

    private static native int getCallExitPolicy_();

    public static void setThreadTerminationPolicy(boolean policy) {
        OracleRuntime.setThreadTerminationPolicy_(policy);
    }

    private static native void setThreadTerminationPolicy_(boolean var0);

    public static boolean getThreadTerminationPolicy(boolean policy) {
        return OracleRuntime.getThreadTerminationPolicy_();
    }

    private static native boolean getThreadTerminationPolicy_();

    private static native long getMaxMemorySize_();

    public static long getMaxMemorySize() {
        return OracleRuntime.getMaxMemorySize_();
    }

    private static native void setMaxMemorySize_(long var0);

    public static void setMaxMemorySize(long maxSize) {
        OracleRuntime.setMaxMemorySize_(maxSize);
    }

    private static native void setMaxRunspaceSize_(long var0);

    public static void setMaxRunspaceSize(long maxSize) {
        OracleRuntime.setMaxRunspaceSize_(maxSize);
    }

    private static native long getMaxRunspaceSize_();

    public static long getMaxRunspaceSize() {
        return OracleRuntime.getMaxRunspaceSize_();
    }

    private static native long getMaxSessionSize_();

    public static long getMaxSessionSize() {
        return OracleRuntime.getMaxSessionSize_();
    }

    private static native long getSessionSoftLimit_();

    public static long getSessionSoftLimit() {
        return OracleRuntime.getSessionSoftLimit_();
    }

    private static native long getSessionSize_();

    public static long getSessionSize() {
        return OracleRuntime.getSessionSize_();
    }

    private static native long getNewspaceSize_();

    public static long getNewspaceSize() {
        return OracleRuntime.getNewspaceSize_();
    }

    private static native void setNewspaceSize_(long var0);

    public static void setNewspaceSize(long size) {
        OracleRuntime.setNewspaceSize_(size);
    }

    private static native boolean newspaceEnabled_();

    public static boolean newspaceEnabled() {
        return OracleRuntime.newspaceEnabled_();
    }

    private static native void enableNewspace_(boolean var0);

    public static void enableNewspace(boolean enable) {
        OracleRuntime.enableNewspace_(enable);
    }

    public static void setNewspaceMaxGeneration(byte arg) {
        if (arg < 0) {
            arg = 0;
        } else if (arg > 3) {
            arg = (byte)3;
        }
        OracleRuntime.setNewspaceMaxGeneration_aux(arg);
    }

    private static native void setNewspaceMaxGeneration_aux_(byte var0);

    public static void setNewspaceMaxGeneration_aux(byte arg) {
        OracleRuntime.setNewspaceMaxGeneration_aux_(arg);
    }

    private static native byte getNewspaceMaxGeneration_();

    public static byte getNewspaceMaxGeneration() {
        return OracleRuntime.getNewspaceMaxGeneration_();
    }

    public static void setNewspaceTenurePolicy(byte arg) {
        if (arg < 0 || 0 < arg) {
            arg = 0;
        }
        OracleRuntime.setNewspaceMaxGeneration_aux(arg);
    }

    private static native void setNewspaceTenurePolicy_aux_(byte var0);

    public static void setNewspaceTenurePolicy_aux(byte arg) {
        OracleRuntime.setNewspaceTenurePolicy_aux_(arg);
    }

    private static native byte getNewspaceTenurePolicy_();

    public static byte getNewspaceTenurePolicy() {
        return OracleRuntime.getNewspaceTenurePolicy_();
    }

    private static native void setSessionGCThreshold_(long var0);

    public static void setSessionGCThreshold(long size) {
        OracleRuntime.setSessionGCThreshold_(size);
    }

    private static native long getSessionGCThreshold_();

    public static long getSessionGCThreshold() {
        return OracleRuntime.getSessionGCThreshold_();
    }

    private static native void setSessionGCPolicy_(int var0);

    public static void setSessionGCPolicy(int policy) {
        OracleRuntime.setSessionGCPolicy_(policy);
    }

    private static native int getSessionGCPolicy_();

    public static int getSessionGCPolicy() {
        return OracleRuntime.getSessionGCPolicy_();
    }

    private static native void setThreadStackSize_(int var0);

    public static void setThreadStackSize(int size) {
        OracleRuntime.setThreadStackSize_(size);
    }

    private static native int getThreadStackSize_();

    public static int getThreadStackSize() {
        return OracleRuntime.getThreadStackSize_();
    }

    private static native void setJavaStackSize_(int var0);

    public static void setJavaStackSize(int size) {
        OracleRuntime.setJavaStackSize_(size);
    }

    private static native int getJavaStackSize_();

    public static int getJavaStackSize() {
        return OracleRuntime.getJavaStackSize_();
    }

    private static native Class findLoadedClass(ClassLoader var0, String var1);

    public static Class loadedClass(ClassLoader loader, String name) {
        return OracleRuntime.findLoadedClass(loader, name);
    }

    public static String intern(String str) {
        JServerPermission.check((String)"SGAIntern");
        return OracleRuntime.intern0(str);
    }

    private static native String intern0(String var0);

    public static long setInternTableMaxSize(long size) {
        JServerPermission.check((String)"SGAIntern");
        return OracleRuntime.setInternTableMaxSize_(size);
    }

    private static native long setInternTableMaxSize_(long var0);

    public static long getInternTableMaxSize() {
        return OracleRuntime.getInternTableMaxSize_();
    }

    private static native long getInternTableMaxSize_();

    public static long getInternTableSize() {
        return OracleRuntime.getInternTableSize_();
    }

    private static native long getInternTableSize_();

    public static long getJavaPoolSize() {
        return OracleRuntime.getJavaPoolSize_();
    }

    private static native long getJavaPoolSize_();

    private static native int memcode_(Object var0);

    public static int memcode(Object obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return OracleRuntime.memcode_(obj);
    }

    private static native void dumpAllHeaps_(String var0) throws IOException;

    public static void dumpAllHeaps(String pathname) throws IOException {
        JServerPermission.check((String)"HeapDump");
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(pathname);
        }
        OracleRuntime.dumpAllHeaps_(pathname);
    }

    private static native void dumpJITSymbolsForVTune_(String var0) throws IOException;

    public static void dumpJITSymbolsForVTune(String filename) throws IOException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite(filename);
        }
        OracleRuntime.dumpJITSymbolsForVTune_(filename);
    }

    private static native void nop_(Object var0);

    public static void nop(Object obj) {
        OracleRuntime.nop_(obj);
    }

    private static native int memtype_(Object var0);

    public static int memtype(Object obj) {
        return OracleRuntime.memtype_(obj);
    }

    public static native long asLong(Object var0);

    public static native Class getCallerClass();

    public static native boolean sandTest(int var0, int var1, int var2, Class var3);

    public static void setSoftRefPolicy(int policy, long value) {
        if (0 <= policy && policy <= 1) {
            softRefPolicy = policy;
            softRefPolicyValue = value;
        }
    }

    public static int getSoftRefPolicy() {
        return softRefPolicy;
    }

    public static long getSoftRefPolicyValue() {
        return softRefPolicyValue;
    }

    public static native boolean loadersAreTheSame(Class var0, Class var1);

    public static native int jitSomeMethods(Member[] var0);

    public static native void unjitSomeMethods(Member[] var0, boolean[] var1);

    private static int jitSomeMethods(int nMethods) {
        int numCompiled = 0;
        try {
            int i;
            IUHandle[] classHandles = new IUHandle[nMethods];
            int[] methodIndices = new int[nMethods];
            Member[] methodObjects = new Member[nMethods];
            for (i = 0; i < nMethods; ++i) {
                classHandles[i] = EnvironmentSpecific.getMethodToJit(i, methodIndices, methodObjects);
            }
            for (i = 0; i < nMethods; ++i) {
                Member rMeth = methodObjects[i];
                if (rMeth == null) continue;
                numCompiled += OracleRuntime.jitOneMethod(rMeth) ? 1 : 0;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return numCompiled;
    }

    private static native boolean jitOneMethod(Member var0);

    private static Object[] classAndMethodForRunJava(final String name, final boolean jarp) throws Exception {
        Launcher.reportClassPathException();
        try {
            return (Object[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String[] args;
                    Class[] parameterTypes;
                    Class<?> mainClass;
                    Method mainMethod;
                    String className = name;
                    if (jarp) {
                        Attributes attributes;
                        String jarFileName = className;
                        JarFile jarFile = new JarFile(jarFileName);
                        Manifest manifest = jarFile.getManifest();
                        className = null;
                        if (manifest != null && (attributes = manifest.getMainAttributes()) != null) {
                            className = attributes.getValue("Main-Class");
                        }
                        if (className == null) {
                            throw new IllegalArgumentException("Failed to find Main-Class manifest attribute in jarfile " + jarFileName);
                        }
                    }
                    if ((mainMethod = (mainClass = Class.forName(className, true, ClassLoader.getSystemClassLoader())).getMethod("main", parameterTypes = new Class[]{(args = new String[]{}).getClass()})) != null && !Modifier.isStatic(mainMethod.getModifiers())) {
                        mainMethod = null;
                    }
                    if (mainMethod == null) {
                        throw new IllegalArgumentException("No main method in " + mainClass.getName());
                    }
                    Object[] result = new Object[]{mainClass, mainMethod};
                    return result;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    private static int readStream(Object s, byte[] buf) throws Exception {
        return ((InputStream)s).read(buf);
    }

    public static native byte[] computeMD5(byte[] var0);

    public static native void emitStackTrace();

    public static native void dumpNativeMachineCode(Method var0);

    public static native void dumpNativeMachineCode(Constructor var0);

    public static void dumpNativeMachineCode(final String sClassName, final String sMethName, final String sMethSig) throws NoSuchMethodException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Class<?> clz = Class.forName(sClassName);
                    Class<?> clzAOT = Class.forName("oracle.aurora.zephyr.AOTDriver");
                    Method methFind = clzAOT.getDeclaredMethod("findMethod", Class.class, String.class, String.class);
                    methFind.setAccessible(true);
                    Member member = (Member)methFind.invoke(null, clz, sMethName, sMethSig);
                    if (member instanceof Method) {
                        OracleRuntime.dumpNativeMachineCode((Method)member);
                    } else {
                        OracleRuntime.dumpNativeMachineCode((Constructor)member);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            e.printStackTrace();
            if (e instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)e;
            }
            throw (RuntimeException)e;
        }
    }

    public static native int methodRuntimeType(Method var0);

    public static native int methodRuntimeType(Constructor var0);

    private static native void startGCSpy_(int var0);

    public static void startGCSpy(int port) {
        OracleRuntime.startGCSpy_(port);
    }
}

