/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util.tools;

import java.util.Enumeration;
import java.util.Hashtable;

class JDK2 {
    JDK2() {
    }

    static class Sorter {
        Comparator comparator;
        Object[] tmp;

        Sorter(Comparator comparator) {
            this.comparator = comparator;
        }

        void sort(Object[] a) {
            this.sort(a, 0, a.length);
        }

        synchronized void sort(Object[] a, int beg, int end) {
            this.tmp = new Object[end - beg];
            int x = beg;
            while (x + 1 < end) {
                this.swap(a, x);
                x += 2;
            }
            for (int increment = 2; increment < end - beg; increment *= 2) {
                int x2 = beg;
                while (x2 + increment < end) {
                    int limit = x2 + 2 * increment;
                    if (limit > end) {
                        limit = end;
                    }
                    this.merge(a, x2, x2 + increment, limit);
                    x2 += 2 * increment;
                }
            }
        }

        void p(String msg, Object[] a, int beg, int end) {
            System.out.println(msg);
            System.out.print("   ");
            for (int x = beg; x < end; ++x) {
                System.out.print(" " + x + ":" + a[x]);
            }
            System.out.println();
        }

        void merge(Object[] a, int beg, int mid, int end) {
            int lenTmp = mid - beg;
            System.arraycopy(a, beg, this.tmp, 0, lenTmp);
            int nextFill = beg;
            int nextTmp = 0;
            int nextB = mid;
            while (nextTmp < lenTmp && nextB < end) {
                if (this.comparator.compare(this.tmp[nextTmp], a[nextB]) <= 0) {
                    a[nextFill++] = this.tmp[nextTmp++];
                    continue;
                }
                a[nextFill++] = a[nextB++];
            }
            while (nextTmp < lenTmp) {
                a[nextFill++] = this.tmp[nextTmp++];
            }
        }

        void swap(Object[] a, int x) {
            if (this.comparator.compare(a[x], a[x + 1]) > 0) {
                Object t = a[x];
                a[x] = a[x + 1];
                a[x + 1] = t;
            }
        }
    }

    static interface Comparator {
        public int compare(Object var1, Object var2);
    }

    static class Map {
        Hashtable table = new Hashtable();
        Object nullValue;

        Map() {
        }

        Object get(Object key) {
            return key == null ? this.nullValue : this.table.get(key);
        }

        Object put(Object key, Object value) {
            Object old = this.get(key);
            if (key == null) {
                this.nullValue = value;
            } else {
                this.table.put(key, value);
            }
            return old;
        }

        Object remove(Object key) {
            Object old = this.get(key);
            if (key == null) {
                this.nullValue = null;
            } else {
                this.table.remove(key);
            }
            return old;
        }

        Set keySet() {
            Set set = new Set();
            set.table = this.table;
            return set;
        }

        int size() {
            return this.table.size();
        }
    }

    static class Set {
        Hashtable table = new Hashtable();
        boolean hasNull;

        Set() {
        }

        public Iterator iterator() {
            return new Iterator(this.table.keys());
        }

        public void add(Object o) {
            if (o == null) {
                this.hasNull = true;
            } else {
                this.table.put(o, o);
            }
        }

        public int size() {
            return this.table.size();
        }

        public boolean contains(Object o) {
            return o == null ? this.hasNull : this.table.containsKey(o);
        }

        public boolean remove(Object o) {
            boolean result;
            if (o == null) {
                result = this.hasNull;
                this.hasNull = false;
            } else {
                Object r = this.table.remove(o);
                result = r != null;
            }
            return result;
        }
    }

    static class Iterator
    implements Enumeration {
        Enumeration e;

        Iterator(Enumeration e) {
            this.e = e;
        }

        public boolean hasNext() {
            return this.e.hasMoreElements();
        }

        public Object next() {
            return this.e.nextElement();
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        public Object nextElement() {
            return this.next();
        }
    }
}

