/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util.classfile;

import oracle.aurora.util.classfile.Dig;
import oracle.aurora.util.classfile.Raw;

public class Mutable
extends Dig {
    static final String aPrefix = "aurora_";

    public Mutable(Raw.Class rawClass) {
        super(rawClass);
    }

    Dig.ConstantPool getConstants() {
        return this.getClazz().getConstants();
    }

    public byte[] stripAurora() {
        Raw.Constant c;
        int first;
        int size = this.getRaw().poolCount;
        Raw.Constant[] constantPool = this.getRaw().constantPool;
        for (first = 0; !(first >= size || (c = constantPool[first]) != null && c.tag == 1 && ((String)c.info).startsWith(aPrefix)); ++first) {
        }
        return this.stripAurora(first);
    }

    public byte[] stripAurora(int first_aurora_constant) {
        this.stripAuroraConstantPool(first_aurora_constant);
        this.stripAuroraFields();
        this.stripAuroraMethods();
        this.stripAuroraAttributes();
        return this.getRaw().classfile();
    }

    void stripAuroraConstantPool(int first) {
        if (first < this.getRaw().poolCount) {
            Raw.Constant[] newConstantPool = new Raw.Constant[first];
            System.arraycopy(this.getRaw().constantPool, 0, newConstantPool, 0, first);
            this.getRaw().constantPool = newConstantPool;
            this.getRaw().poolCount = first;
        }
    }

    void stripAuroraFields() {
        this.getRaw().fields = this.stripAurora(this.getRaw().fields);
        this.getRaw().fieldCount = this.getRaw().fields.length;
    }

    void stripAuroraMethods() {
        this.getRaw().methods = this.stripAurora(this.getRaw().methods);
        this.getRaw().methodCount = this.getRaw().methods.length;
    }

    void stripAuroraAttributes() {
        this.getRaw().attributes = this.stripAurora(this.getRaw().attributes);
        this.getRaw().attributeCount = this.getRaw().attributes.length;
    }

    Raw.Member[] stripAurora(Raw.Member[] members) {
        boolean count = false;
        for (int x = 0; x < members.length; ++x) {
            members[x].attributes = this.stripAurora(members[x].attributes);
            members[x].attributeCount = members[x].attributes.length;
        }
        return members;
    }

    public static boolean isAuroraAttributeName(String att) {
        return att != null && att.startsWith(aPrefix);
    }

    Raw.Attribute[] stripAurora(Raw.Attribute[] attributes) {
        int count = 0;
        int limit = this.getRaw().poolCount;
        int len = attributes.length;
        for (int x = 0; x < len; ++x) {
            Raw.Attribute att = attributes[x];
            if (att.nameIndex >= limit || Mutable.isAuroraAttributeName(this.getName(att))) {
                ++count;
                continue;
            }
            if (count <= 0) continue;
            attributes[x - count] = att;
        }
        if (count > 0) {
            int newlen = len - count;
            Raw.Attribute[] newAttributes = new Raw.Attribute[newlen];
            System.arraycopy(attributes, 0, newAttributes, 0, newlen);
            attributes = newAttributes;
        }
        return attributes;
    }
}

