/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.util.NoSuchElementException;
import oracle.aurora.util.Cursor;
import oracle.aurora.util.DynaHash;
import oracle.aurora.util.DynaHashStats;
import oracle.aurora.util.Identifier;
import oracle.aurora.util.NodeAssocFactory;
import oracle.aurora.util.NodeStat;
import oracle.aurora.util.NodeTraversal;
import oracle.aurora.util.NodeTraverser;
import oracle.aurora.util.OrderedCollection;

public class GraphWalker
implements Cursor {
    protected boolean allOwners;
    protected NodeTraverser node_enum;
    protected NodeAssocFactory naFact;
    protected Object root;
    protected Object current;
    protected NodeStat nodeStat;
    protected OrderedCollection context;
    protected int bfMode;
    protected int gIdx;
    protected DynaHash nodeHash;
    protected static final int bfmEnumerate = 0;
    protected static final int bfmTraverse = 1;

    public GraphWalker() {
        this(false, null, null);
    }

    public GraphWalker(boolean allOwners) {
        this(allOwners, null, null);
    }

    public GraphWalker(boolean allOwners, NodeTraverser trav, NodeAssocFactory fact) {
        this.allOwners = allOwners;
        this.node_enum = trav;
        this.naFact = fact;
        this.context = new OrderedCollection();
        this.nodeHash = new DynaHash(new Identifier(){

            public int hash(Object obj) {
                return System.identityHashCode(((NodeStat)obj).node);
            }

            public int findHash(Object obj) {
                return System.identityHashCode(obj);
            }

            public boolean identify(Object obj1, Object obj2) {
                return ((NodeStat)obj1).node == ((NodeStat)obj2).node;
            }

            public boolean findIdentify(Object obj, Object find) {
                return ((NodeStat)obj).node == find;
            }
        });
    }

    public void walkRoot(Object node, boolean resetNodeStat) {
        this.reset(resetNodeStat);
        this.root = node;
    }

    public void walkRoot(Object node, NodeTraverser trav, boolean resetNodeStat) {
        this.node_enum = trav;
        this.walkRoot(node, resetNodeStat);
    }

    protected NodeStat createNodeStat(Object obj) {
        NodeStat result = new NodeStat(obj, this.naFact == null ? null : this.naFact.create(obj));
        this.nodeHash.replace(result);
        return result;
    }

    protected NodeStat getNodeStat(Object obj) {
        NodeStat result = (NodeStat)this.nodeHash.find(obj);
        if (result == null) {
            result = this.createNodeStat(obj);
        }
        return result;
    }

    protected NodeTraversal push(Object obj) {
        return this.push(obj, null);
    }

    protected NodeTraversal push(Object obj, NodeStat ns) {
        if (ns == null) {
            ns = this.getNodeStat(obj);
        }
        if (!ns.traverse()) {
            return null;
        }
        Cursor curs = this.node_enum.beginTraverse(obj, ns);
        if (curs == null) {
            ns.status = 3;
            this.node_enum.endTraverse(obj, ns);
            return null;
        }
        NodeTraversal nt = new NodeTraversal(obj, curs, this.node_enum.scanMode(obj));
        this.context.push(nt);
        this.bfMode = 0;
        return nt;
    }

    protected NodeTraversal pop() {
        this.bfMode = 1;
        NodeTraversal result = (NodeTraversal)this.context.pop();
        NodeStat ns = this.getNodeStat(result.node);
        ns.status = 3;
        this.node_enum.endTraverse(result.node, ns);
        this.current = null;
        return result;
    }

    protected boolean setCurrent(Object obj) {
        if (obj == null) {
            this.current = null;
            this.nodeStat = null;
            return false;
        }
        NodeStat ns = this.getNodeStat(obj);
        if (!this.allOwners && ns.status != 0) {
            return false;
        }
        this.current = obj;
        if (ns.status == 0) {
            ns.status = 1;
        }
        this.nodeStat = ns;
        return true;
    }

    public boolean next() {
        if (this.gIdx++ == -1) {
            return this.setCurrent(this.root);
        }
        if (this.current == null) {
            return false;
        }
        if (this.context.getSize() == 0) {
            this.push(this.current);
            this.current = null;
        }
        block0: while (this.context.getSize() > 0) {
            NodeTraversal nt = (NodeTraversal)this.context.peek();
            if (nt.mode == 0) {
                if (this.current != null && this.push(this.current) != null) continue;
                while (nt.cursor.next()) {
                    if (!this.setCurrent(nt.cursor.get())) continue;
                    return true;
                }
                this.pop();
                continue;
            }
            if (this.bfMode == 0) {
                while (nt.cursor.next()) {
                    if (!this.setCurrent(nt.cursor.get())) continue;
                    return true;
                }
                nt.cursor.reset();
                this.bfMode = 1;
                continue;
            }
            while (nt.cursor.next()) {
                if (this.push(nt.cursor.get()) == null) continue;
                continue block0;
            }
            this.pop();
        }
        this.setCurrent(null);
        return false;
    }

    protected void assertValid() {
        if (this.gIdx == -1 || this.current == null) {
            throw new NoSuchElementException();
        }
    }

    public Object get() {
        this.assertValid();
        return this.current;
    }

    public OrderedCollection getContext() {
        this.assertValid();
        return this.context;
    }

    public NodeTraversal getTraversal(int idx) {
        this.assertValid();
        return (NodeTraversal)this.context.elementAt(idx);
    }

    public NodeStat getStatus() {
        this.assertValid();
        return this.nodeStat;
    }

    public NodeStat getStatusOrNull(Object node) {
        return (NodeStat)this.nodeHash.find(node);
    }

    public NodeStat getStatus(Object node) {
        NodeStat ns = (NodeStat)this.nodeHash.find(node);
        if (ns == null) {
            throw new NoSuchElementException("No status for node: " + node.toString() + " class: " + node.getClass().getName());
        }
        return ns;
    }

    public Cursor getAllNodes() {
        return this.nodeHash.enumerate();
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean resetNodeStat) {
        this.current = null;
        this.context.clear();
        this.gIdx = -1;
        if (resetNodeStat) {
            this.nodeHash = new DynaHash(this.nodeHash.getIdentifier());
        }
    }

    public DynaHashStats getNodeHashStats() {
        return this.nodeHash.getStats();
    }

    public int getIndex() {
        return this.gIdx;
    }
}

