/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.PrintWriter;
import oracle.aurora.util.Assertion;
import oracle.aurora.util.BTProbe;
import oracle.aurora.util.BTreeCursor;
import oracle.aurora.util.BTreeLNode;
import oracle.aurora.util.BTreeNode;
import oracle.aurora.util.Comparator;
import oracle.aurora.util.Cursor;
import oracle.aurora.util.Iterator;
import oracle.aurora.util.Printer;
import oracle.aurora.util.Random;

public class BTree {
    public static final Printer DEF_PRINTER = new Printer(){

        public void printOn(PrintWriter out, Object obj) {
            out.print("<" + obj.getClass().getName() + " #" + obj.hashCode() + ">");
        }
    };
    public static final short DEF_ORDER = 8;
    protected static Assertion oassert = new Assertion();
    protected static Random rand = new Random(0L);
    protected short inodeOrder;
    protected short lnodeOrder;
    protected BTreeNode root;
    protected Comparator comparator;
    protected Printer printer;

    public BTree(Comparator comparator) {
        this(comparator, DEF_PRINTER, 8, 8);
    }

    public BTree(Comparator comparator, Printer printer) {
        this(comparator, printer, 8, 8);
    }

    public BTree(Comparator comparator, Printer printer, short inodeOrder, short lnodeOrder) {
        if (oassert.on()) {
            Assertion.oassert(inodeOrder >= 3 && lnodeOrder >= 1);
        }
        this.comparator = comparator;
        this.printer = printer;
        this.inodeOrder = inodeOrder;
        this.lnodeOrder = lnodeOrder;
        this.root = new BTreeLNode(this, null);
    }

    public void printOn(PrintWriter out) {
        out.print("BTree: " + this.hashCode());
        this.root.printOn(out, true, 1);
    }

    public boolean contains(Object obj) {
        BTProbe probe = new BTProbe();
        return this.root.probe(obj, probe);
    }

    public Object find(Object obj) {
        BTProbe probe = new BTProbe();
        return this.root.probe(obj, probe) ? probe.node.getElement(probe.index) : null;
    }

    public Object insert(Object obj) {
        BTProbe probe = new BTProbe();
        if (this.root.probe(obj, probe)) {
            return probe.node.getElement(probe.index);
        }
        probe.node.insert(obj, probe);
        return null;
    }

    public Object replace(Object obj) {
        BTProbe probe = new BTProbe();
        if (this.root.probe(obj, probe)) {
            Object result = probe.node.getElement(probe.index);
            probe.node.setElement(probe.index, obj);
            return result;
        }
        probe.node.insert(obj, probe);
        return null;
    }

    public Object remove(Object obj) {
        BTProbe probe = new BTProbe();
        if (this.root.probe(obj, probe)) {
            Object result = probe.node.getElement(probe.index);
            probe.node.removeElement(probe.index);
            return result;
        }
        return null;
    }

    public Cursor enumerate() {
        return new BTreeCursor(this);
    }

    public void iterate(Iterator itr) {
        this.iterate(itr, null, null);
    }

    public void iterate(Iterator itr, Object first) {
        this.iterate(itr, first, null);
    }

    public void iterate(Iterator itr, Object first, Object last) {
        BTreeCursor curs = new BTreeCursor(this, first, last);
        while (curs.next()) {
            itr.eval(curs.get());
        }
    }

    public int size() {
        return this.root.totalSize();
    }

    public int capacity() {
        return this.root.totalCapacity();
    }

    public int free() {
        return this.capacity() - this.size();
    }

    protected void checkIntegrity() {
        this.root.checkIntegrity(null);
    }

    protected boolean random() {
        return rand.nextInt() % 2 == 0;
    }

    protected void setRoot(BTreeNode n) {
        this.root = n;
    }
}

